<?php
/*
  $Id: checkout.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2009 Wuxi Elootec Technology Co., Ltd;

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/
  require_once('includes/classes/china_address.php');
  require_once('includes/classes/order.php');

  class toC_Json_Cn_checkout {
    function checkShippingAddress() {
      global $osC_Language, $osC_Customer, $osC_ShoppingCart, $toC_Json, $osC_Payment;
      
      if ( $osC_Customer->isLoggedOn() ) {
        if ( $osC_ShoppingCart->hasShippingAddress() ) {
          osc_redirect(osc_href_link(FILENAME_CHECKOUT, 'cn_checkout', 'SSL'));
        } else {
          osc_redirect(osc_href_link(FILENAME_CHECKOUT, 'cn_shipping_address', 'SSL'));
        }
      } else {
        osc_redirect(osc_href_link(FILENAME_ACCOUNT, 'login', 'SSL'));
      }
    }
    
    function changeShippingMethod() {
      global $osC_ShoppingCart, $toC_Json;
      
      if (isset($_REQUEST['shipping_method'])) {
        self::_saveShippingMethod($_REQUEST['shipping_method']);
      }
      
      $order_confirmation_form = self::_getOrderConfirmationForm();
      
      $response = array('success' => true, 'order_confirmation_form' => $order_confirmation_form);
            
      echo $toC_Json->encode($response);
    }
    
    function changePaymentMethod() {
      global $osC_ShoppingCart, $toC_Json;
      
      $form_html = '';
      if (isset($_REQUEST['payment_method'])) {
        $form_html = self::_savePaymentMethod($_REQUEST['payment_method']);
      }
      
      $response = array('success' => true, 'form' => $form_html);
            
      echo $toC_Json->encode($response);
    }
    
    function _saveShippingMethod($shipping_method = null) {
      global $osC_Language, $osC_ShoppingCart, $osC_Shipping, $toC_Json, $osC_Customer, $osC_Currencies;
      
      $errors = array();

// load all enabled shipping modules
      if (class_exists('osC_Shipping') === false) {
        include('includes/classes/shipping.php');
      }
      
      if (class_exists('toC_China_Shipping') === false) {
        include('includes/classes/china_shipping.php');
      }

      $osC_Shipping = new osC_Shipping();
      
      if ($shipping_method == null && $osC_ShoppingCart->hasShippingMethod() === false) {
        $shipping_method = $osC_Shipping->getCheapestQuote();
      } else {
        $shipping_method = $shipping_method != null ? $shipping_method : $osC_ShoppingCart->getShippingMethod('id');
      }
      
// if no shipping method has been selected, automatically select the cheapest method.
      if ($osC_ShoppingCart->hasShippingMethod() === false) {
        $osC_ShoppingCart->setShippingMethod($shipping_method);
      }
      
      if ($osC_Shipping->hasQuotes()) {
        if (strpos($shipping_method, '_')) {
          list($module, $method) = explode('_', $shipping_method);
          $module = 'osC_Shipping_' . $module;

          if (is_object($GLOBALS[$module]) && $GLOBALS[$module]->isEnabled()) {
            $quote = $osC_Shipping->getQuote($shipping_method);

            if (isset($quote['error'])) {
              $osC_ShoppingCart->resetShippingMethod();
              
              $errors[] = $quote['error'];
            } else {
              $osC_ShoppingCart->setShippingMethod($quote);
            }
          } else {
            $osC_ShoppingCart->resetShippingMethod();
          }
        }
      } else {
        $osC_ShoppingCart->resetShippingMethod();
      }
      
      if (sizeof($errors) > 0) {
        return false;
      }
      
      return true;
    }
    
    function _savePaymentMethod($payment_method = null) {
      global $osC_Language, $osC_ShoppingCart, $osC_Payment, $messageStack, $toC_Json, $osC_Currencies;
      
      include('includes/classes/payment.php');
      if ( $payment_method == null && $osC_ShoppingCart->getBillingMethod('id') == '') {
        $osC_Payment = new osC_Payment();
            
        $selection = $osC_Payment->selection();
        foreach ($selection as $num => $select) {
          if ($num === 0) {
            $payment_method = $select['id'];
          }
        }
      } else {
        $osC_Payment = new osC_Payment($payment_method != null ? $payment_method : $osC_ShoppingCart->getBillingMethod('id'));
      }
      
      $errors = array();
      
      $osC_Language->load('account');
      $osC_Language->load('checkout');
      $osC_Language->load('order');
      
      if ( (isset($_POST['payment_comments'])) && (isset($_SESSION['payment_comments'])) && (empty($_POST['payment_comments'])) ) {
        unset($_SESSION['comments']);
      } elseif (!empty($_POST['payment_comments'])) {
        $_SESSION['comments'] = osc_sanitize_string($_POST['payment_comments']);
      }
      
      if (DISPLAY_CONDITIONS_ON_CHECKOUT == '1') {
        if (!isset($_POST['conditions']) || ($_POST['conditions'] != '1')) {
          $errors[] = $osC_Language->get('error_conditions_not_accepted');
        }
      }
      
      if($osC_ShoppingCart->isTotalZero() == false) {
        if ($payment_method != null) {
          $osC_ShoppingCart->setBillingMethod(array('id' => $payment_method, 'title' => $GLOBALS['osC_Payment_' . $payment_method]->getMethodTitle()));
        }
  
        if ( $osC_Payment->hasActive() && ((isset($GLOBALS['osC_Payment_' . $osC_ShoppingCart->getBillingMethod('id')]) === false) || (isset($GLOBALS['osC_Payment_' . $osC_ShoppingCart->getBillingMethod('id')]) && is_object($GLOBALS['osC_Payment_' . $osC_ShoppingCart->getBillingMethod('id')]) && ($GLOBALS['osC_Payment_' . $osC_ShoppingCart->getBillingMethod('id')]->isEnabled() === false))) ) {
          $errors[] = $osC_Language->get('error_no_payment_module_selected');
        }
  
        if ($osC_Payment->hasActive()) {
          $osC_Payment->pre_confirmation_check();
        }
        
        if ($messageStack->size('checkout_payment') > 0) {
          $errors =  array_merge($errors, $messageStack->getMessages('checkout_payment'));
        }
      } else {
        $osC_ShoppingCart->resetBillingMethod();
      }
      
      if ($osC_Payment->hasActionURL()) {
        $form_action_url = $osC_Payment->getActionURL();
      } else {
        $form_action_url = osc_href_link(FILENAME_CHECKOUT, 'process', 'SSL');
      }
  
      $form_html = '<form name="checkout_confirmation" action="' . $form_action_url . '" method="post">';
  
      if ($osC_Payment->hasActive()) {
        if ($confirmation = $osC_Payment->confirmation()) {
          $form_html .= '<div class="moduleBox">'; 
          $form_html .= '<h6>' . $osC_Language->get('order_payment_information_title') . '</h6>';
          $form_html .= '<div class="content">'; 
          $form_html .= '<p>' . $confirmation['title']. '</p>';
          
          if (isset($confirmation['fields'])) {
            $form_html .= '<table border="0" cellspacing="3" cellpadding="2">'; 

            for ($i=0, $n=sizeof($confirmation['fields']); $i<$n; $i++) {
              $form_html .= '<tr><td width="10">&nbsp;</td>';
              $form_html .= '<td>' . $confirmation['fields'][$i]['title'] . '</td>';
              $form_html .= '<td width="10">&nbsp;</td>';
              $form_html .= '<td>' . $confirmation['fields'][$i]['field'] . '</td>';
              $form_html .= '</tr>';
            }
            
            $form_html .= '</table>';
          }
  
          if (isset($confirmation['text'])) {
            $form_html .= '<p>' . $confirmation['text'] . '</p>';
          }
          $form_html .= '</div></div>';
        }
      }
    
      if ($osC_Payment->hasActive()) {
        $form_html .= $osC_Payment->process_button();
      }

      $form_html .= '</form><div style="text-align:right;">' . osc_draw_image_submit_button('button_confirm_order.gif', $osC_Language->get('button_confirm_order'), 'id="btnConfirmOrder"') . '</div>';
      
      return $form_html;
    }
    
    function _saveBillingAddress() {
      global $osC_Language, $osC_ShoppingCart, $osC_Shipping, $toC_Json, $osC_Customer, $osC_Payment, $osC_Currencies;

      $Qaddresses = osC_AddressBook::getListing();
      $address = array();
      
      while ($Qaddresses->next()) {
        $address[] = array('id' => $Qaddresses->valueInt('address_book_id'));
      }
      
      if (sizeof($address) > 0) {
        $osC_ShoppingCart->setBillingAddress($address[0]['id']);
      }
    }
    
    function saveShippingAddress() {
      global $toC_Json, $osC_Language, $osC_Database, $osC_ShoppingCart, $osC_Customer, $osC_Currencies;
      
      $errors = array();
      $data = array();
      
      $osC_Language->load('checkout');

      if ((!$osC_Customer->isLoggedOn()) || ($osC_Customer->isLoggedOn() && !isset($_REQUEST['shipping_address_id']))) {
        if (ACCOUNT_GENDER == '1') {
          if (isset($_REQUEST['shipping_gender']) && (($_REQUEST['shipping_gender'] == 'm') || ($_REQUEST['shipping_gender'] == 'f'))) {
            $data['gender'] = $_REQUEST['shipping_gender'];
          } else {
            $errors[] = $osC_Language->get('field_customer_gender_error');
          }
        } else {
          $data['gender'] = isset($_REQUEST['shipping_gender']) ? $_REQUEST['shipping_gender'] : '';
        }
  
        if (isset($_REQUEST['shipping_firstname']) && (strlen(trim($_REQUEST['shipping_firstname'])) >= ACCOUNT_FIRST_NAME)) {
          $data['firstname'] = $_REQUEST['shipping_firstname'];
        } else {
          $errors[] = sprintf($osC_Language->get('field_customer_first_name_error'), ACCOUNT_FIRST_NAME);
        }
  
        if (isset($_REQUEST['shipping_lastname']) && (strlen(trim($_REQUEST['shipping_lastname'])) >= ACCOUNT_LAST_NAME)) {
          $data['lastname'] = $_REQUEST['shipping_lastname'];
        } else {
          $errors[] = sprintf($osC_Language->get('field_customer_last_name_error'), ACCOUNT_LAST_NAME);
        }
  
        if (ACCOUNT_COMPANY > -1) {
          if (isset($_REQUEST['shipping_company']) && (strlen(trim($_REQUEST['shipping_company'])) >= ACCOUNT_COMPANY)) {
            $data['company'] = $_REQUEST['shipping_company'];
          } else {
            $errors[] = sprintf($osC_Language->get('field_customer_company_error'), ACCOUNT_COMPANY);
          }
        }
  
        if (isset($_REQUEST['shipping_street_address']) && (strlen(trim($_REQUEST['shipping_street_address'])) >= ACCOUNT_STREET_ADDRESS)) {
          $data['street_address'] = $_REQUEST['shipping_street_address'];
        } else {
          $errors[] = sprintf($osC_Language->get('field_customer_street_address_error'), ACCOUNT_STREET_ADDRESS);
        }
  
        if (ACCOUNT_SUBURB >= 0) {
          if (isset($_REQUEST['shipping_suburb']) && (strlen(trim($_REQUEST['shipping_suburb'])) >= ACCOUNT_SUBURB)) {
            $data['suburb'] = $_REQUEST['shipping_suburb'];
          } else {
            $errors[] = sprintf($osC_Language->get('field_customer_suburb_error'), ACCOUNT_SUBURB);
          }
        }
  
        if (ACCOUNT_POST_CODE > -1) {
          if (isset($_REQUEST['shipping_postcode']) && (strlen(trim($_REQUEST['shipping_postcode'])) >= ACCOUNT_POST_CODE)) {
            $data['postcode'] = $_REQUEST['shipping_postcode'];
          } else {
            $errors[] = sprintf($osC_Language->get('field_customer_post_code_error'), ACCOUNT_POST_CODE);
          }
        }
  
        if (isset($_REQUEST['shipping_city']) && (strlen(trim($_REQUEST['shipping_city'])) >= ACCOUNT_CITY)) {
          $data['city'] = $_REQUEST['shipping_city'];
        } else {
          $errors[] = sprintf($osC_Language->get('field_customer_city_error'), ACCOUNT_CITY);
        }
  
        if (ACCOUNT_STATE >= 0) {
          $Qcheck = $osC_Database->query('select zone_id from :table_zones where zone_country_id = :zone_country_id limit 1');
          $Qcheck->bindTable(':table_zones', TABLE_ZONES);
          $Qcheck->bindInt(':zone_country_id', $_REQUEST['shipping_country']);
          $Qcheck->execute();
  
          $entry_state_has_zones = ($Qcheck->numberOfRows() > 0);
  
          if ($entry_state_has_zones === true) {
            $Qzone = $osC_Database->query('select zone_id from :table_zones where zone_country_id = :zone_country_id and zone_code like :zone_code');
            $Qzone->bindTable(':table_zones', TABLE_ZONES);
            $Qzone->bindInt(':zone_country_id', $_REQUEST['shipping_country']);
            $Qzone->bindValue(':zone_code', $_REQUEST['shipping_state']);
            $Qzone->execute();
  
            if ($Qzone->numberOfRows() === 1) {
              $data['zone_id'] = $Qzone->valueInt('zone_id');
            } else {
              $Qzone = $osC_Database->query('select zone_id from :table_zones where zone_country_id = :zone_country_id and zone_name like :zone_name');
              $Qzone->bindTable(':table_zones', TABLE_ZONES);
              $Qzone->bindInt(':zone_country_id', $_REQUEST['shipping_country']);
              $Qzone->bindValue(':zone_name', $_REQUEST['shipping_state'] . '%');
              $Qzone->execute();
  
              if ($Qzone->numberOfRows() === 1) {
                $data['zone_id'] = $Qzone->valueInt('zone_id');
              } else {
                $errors[] = $osC_Language->get('field_customer_state_select_pull_down_error');
              }
            }
          } else {
            if (strlen(trim($_REQUEST['shipping_state'])) >= ACCOUNT_STATE) {
              $data['state'] = $_REQUEST['shipping_state'];
            } else {
              $errors[] = sprintf($osC_Language->get('field_customer_state_error'), ACCOUNT_STATE);
            }
          }
        } else {
          if (strlen(trim($_REQUEST['shipping_state'])) >= ACCOUNT_STATE) {
            $data['state'] = $_REQUEST['shipping_state'];
          } else {
            $errors[] = sprintf($osC_Language->get('field_customer_state_error'), ACCOUNT_STATE);
          }
        }
  
        if (isset($_REQUEST['shipping_country']) && is_numeric($_REQUEST['shipping_country']) && ($_REQUEST['shipping_country'] >= 1)) {
          $data['country_id'] = $_REQUEST['shipping_country'];
        } else {
          $errors[] = $osC_Language->get('field_customer_country_error');
        }
  
        if (ACCOUNT_TELEPHONE >= 0) {
          if (isset($_REQUEST['shipping_telephone']) && (strlen(trim($_REQUEST['shipping_telephone'])) >= ACCOUNT_TELEPHONE)) {
            $data['telephone'] = $_REQUEST['shipping_telephone'];
          } else {
            $errors[] = sprintf($osC_Language->get('field_customer_telephone_number_error'), ACCOUNT_TELEPHONE);
          }
        }
  
        if (ACCOUNT_FAX >= 0) {
          if (isset($_REQUEST['shipping_fax']) && (strlen(trim($_REQUEST['shipping_fax'])) >= ACCOUNT_FAX)) {
            $data['fax'] = $_REQUEST['shipping_fax'];
          } else {
            $errors[] = sprintf($osC_Language->get('field_customer_fax_number_error'), ACCOUNT_FAX);
          }
        }
      }
      
      if (sizeof($errors) > 0) {
        $response = array('success' => false, 'errors' => $errors);
      } else {
        if ($osC_Customer->isLoggedOn()) {
          if (isset($_REQUEST['shipping_address_id']) && $_REQUEST['shipping_address_id'] > 0) {
            $osC_ShoppingCart->setShippingAddress($_REQUEST['shipping_address_id']);
            
            osc_redirect(osc_href_link(FILENAME_CHECKOUT, 'cn_checkout', 'SSL'));
          } else {
            $osC_ShoppingCart->setRawShippingAddress($data);
          }
        } else {
          $osC_ShoppingCart->setRawShippingAddress($data);
        }

        $response = array('success' => true, 'url' => osc_href_link(FILENAME_CHECKOUT, 'cn_checkout', 'SSL'));
      }
      
      echo $toC_Json->encode($response);
    }
    
    function countryChange() {
      global $toC_Json, $osC_Database, $osC_Language;
      
      $zones_array = array();
      foreach (osC_Address::getZones($_REQUEST['country_id']) as $country) {
        $zones_array[] = array('id' => $country['name'], 'text' => $country['name']);
      }
      
      if (sizeof($zones_array) > 0) {
        $response = array(
          'success' => true, 
          'html' => osc_draw_pull_down_menu($_REQUEST['type'] . '_state', $zones_array));
      } else {
        $response = array(
          'success' => true, 
          'html' => osc_draw_input_field($_REQUEST['type'] . '_state'));
      }
      
      echo $toC_Json->encode($response);
    }
      
    function stateChange() {
      global $toC_Json, $osC_Database, $osC_Language;
      
      $cities_array = array();
      foreach (toC_China_Address::getCities($_REQUEST['state_name']) as $city) {
        $cities_array[] = array('id' => $city['name'],
                                'text' => $city['name']);
      }
  
      if (sizeof($cities_array) > 0) {
        $response = array(
          'success' => true, 
          'html' => osc_draw_pull_down_menu($_REQUEST['type'] . '_city', $cities_array));
      } else {
        $response = array(
          'success' => true, 
          'html' => osc_draw_input_field($_REQUEST['type'] . '_city'));
      }
      
      echo $toC_Json->encode($response);
    }
    
    function cityChange() {
      global $toC_Json, $osC_Database, $osC_Language;
      
      $city_id = toC_China_Address::getChinaRegionId($_REQUEST['city_name'], REGION_TYPE_CITY);
      
      $suburb_array = array();
      foreach (toC_China_Address::getDistricts($city_id) as $suburb) {
        $suburb_array[] = array('id' => $suburb['name'],
                                'text' => $suburb['name']);
      }
  
      if (sizeof($suburb_array) > 0) {
        $response = array(
          'success' => true, 
          'html' => osc_draw_pull_down_menu($_REQUEST['type'] . '_suburb', $suburb_array));
      } else {
        $response = array(
          'success' => true, 
          'html' => osc_draw_input_field($_REQUEST['type'] . '_suburb'));
      }
      
      echo $toC_Json->encode($response);
    }
    
    function redeemGiftCertificate() {
      global $toC_Json, $osC_Language, $osC_Payment, $osC_ShoppingCart, $osC_Currencies;
      
      $osC_Language->load('checkout');
      
      $errors = array();
      
      if ($osC_ShoppingCart->isTotalZero()) {
        $errors[] = $osC_Language->get('error_shopping_cart_total_zero');
      }
      
      if ($osC_ShoppingCart->containsGiftCertifcate($_POST['gift_certificate_code'])) {
        $errors[] = $osC_Language->get('error_gift_certificate_exist');
      }
      
      include('includes/classes/gift_certificates.php');
      if (!toC_Gift_Certificates::isGiftCertificateValid($_POST['gift_certificate_code'])) {
        $errors[] = $osC_Language->get('error_invalid_gift_certificate');
      }
      
      if(sizeof($errors) == 0){
        $osC_ShoppingCart->addGiftCertificateCode($_POST['gift_certificate_code']);
      
        $payment_method_form = self::_getPaymentMethodForm();
        $order_confirmation_form = self::_getOrderConfirmationForm();
        
        $response = array('success' => true, 'payment_method_form' => $payment_method_form, 'order_confirmation_form' => $order_confirmation_form);
      } else {
        $response = array('success' => false, 'errors' => $errors);   
      }

      echo $toC_Json->encode($response);
    }

    function deleteGiftCertificate() {
      global $toC_Json, $osC_Payment, $osC_ShoppingCart;
      
      $osC_ShoppingCart->deleteGiftCertificate($_POST['gift_certificate_code']);
      
      $payment_method_form = self::_getPaymentMethodForm();
      $order_confirmation_form = self::_getOrderConfirmationForm();
        
      $response = array('success' => true, 'payment_method_form' => $payment_method_form, 'order_confirmation_form' => $order_confirmation_form);
      
      echo $toC_Json->encode($response);
    }
    
    function redeemCoupon() {
      global $toC_Json, $osC_Language, $osC_Payment, $osC_ShoppingCart, $osC_Currencies, $osC_Payment, $osC_Customer;
    
      $osC_Language->load('checkout');
      
      include('includes/classes/coupon.php');
      $toC_Coupon = new toC_Coupon($_POST['coupon_redeem_code']);

      $errors = array();

      if(!$toC_Coupon->isExist()){
        $errors[] = $osC_Language->get('error_coupon_not_exist');
      }

      if(!$toC_Coupon->isValid()){
        $errors[] = $osC_Language->get('error_coupon_not_valid');
      }

      if(!$toC_Coupon->isDateValid()){
        $errors[] = $osC_Language->get('error_coupon_invalid_date');
      }

      if(!$toC_Coupon->isUsesPerCouponValid()){
        $errors[] = $osC_Language->get('error_coupon_exceed_uses_per_coupon');
      }

      if(!$toC_Coupon->isUsesPerCustomerValid()){
        $errors[] = $osC_Language->get('error_coupon_exceed_uses_per_customer');
      }

      if($toC_Coupon->hasRestrictCategories() || $toC_Coupon->hasRestrictProducts()){
        if(!$toC_Coupon->containRestrictProducts()){
          $errors[] = $osC_Language->get('error_coupon_no_match_products');
        }
      }

      if(!$toC_Coupon->checkMinimumOrderQuantity()){
        $errors[] = $osC_Language->get('error_coupon_minimum_order_quantity');
      }

      if(sizeof($errors) == 0){
        $osC_ShoppingCart->setCouponCode($_POST['coupon_redeem_code']);
      
        $payment_method_form = self::_getPaymentMethodForm();
        $order_confirmation_form = self::_getOrderConfirmationForm();
        
        $response = array('success' => true, 'payment_method_form' => $payment_method_form, 'order_confirmation_form' => $order_confirmation_form);
      } else {
        $response = array('success' => false, 'errors' => $errors);   
      }
      
      echo $toC_Json->encode($response);
    }
    
    function deleteCoupon() {
      global $toC_Json, $osC_Language, $osC_Payment, $osC_ShoppingCart, $osC_Currencies, $osC_Payment, $osC_Customer;
      
      $osC_Language->load('checkout');
      
      $osC_ShoppingCart->deleteCoupon();

      $payment_method_form = self::_getPaymentMethodForm();
      $order_confirmation_form = self::_getOrderConfirmationForm();
      
      $response = array('success' => true, 'payment_method_form' => $payment_method_form, 'order_confirmation_form' => $order_confirmation_form);
      
      echo $toC_Json->encode($response);
    }
    
    function useStoreCredit() {
      global $toC_Json, $osC_Language, $osC_ShoppingCart, $osC_Customer, $osC_Payment, $osC_Currencies;
      
      $errors = array();
      
      if (isset($_REQUEST['value']) && ($_REQUEST['value'] == 'true')) {
        if ($osC_ShoppingCart->isTotalZero()) {
          $errors[] = $osC_Language->get('error_shopping_cart_order_total_zero');  
        } else {
          $osC_ShoppingCart->setUseStoreCredit(true);
        }
      } else {
        $osC_ShoppingCart->setUseStoreCredit(false);
      }      
      
      if(sizeof($errors) == 0){
        $response = array('success' => true, 'isTotalZero' => $osC_ShoppingCart->isTotalZero());
      } else {
        $response = array('success' => false, 'errors' => $errors);
      }      

      echo $toC_Json->encode($response);      
    }
    
    function _getPaymentMethodForm() {
      global $toC_Json, $osC_Language, $osC_ShoppingCart, $osC_Currencies, $osC_Customer;
      
      //get payment method form
      ob_start();
      
      include('includes/modules/payment_method_form.php'); 
      $payment_method_form = ob_get_contents();
      
      ob_end_clean();
      
      return $payment_method_form;
    }
    
    function _getOrderConfirmationForm() {
      global $toC_Json, $osC_Language, $osC_ShoppingCart, $osC_Currencies, $osC_Customer;
      
      //get order confirmation form
      ob_start();
      
      include('includes/modules/order_confirmation_form.php'); 
      $order_confirmation_form = ob_get_contents();
      
      ob_end_clean();
      
      return $order_confirmation_form;
    }
    
    function saveComments() {
      global $toC_Json;

      if ( (isset($_POST['payment_comments'])) && (isset($_SESSION['payment_comments'])) && (empty($_POST['payment_comments'])) ) {
        unset($_SESSION['comments']);
      } elseif (!empty($_POST['payment_comments'])) {
        $_SESSION['comments'] = osc_sanitize_string($_POST['payment_comments']);
      }
      
      if (!empty($_POST['shipping_comments'])) {
        $_SESSION['comments'] = osc_sanitize_string($_POST['shipping_comments']);
      }
      
      if (!empty($_POST['gift_wrapping_comments'])) {
        $_SESSION['gift_wrapping_comments'] = osc_sanitize_string($_POST['gift_wrapping_comments']);
      }
      
      $response = array('success' => true, 'error' => '');
      
      echo $toC_Json->encode($response);
    }
    
    function saveGiftWrapping() {
      global $toC_Json, $osC_ShoppingCart;
      
      if (isset($_POST['gift_wrapping']) && ($_POST['gift_wrapping'] == 'true')) {
        $osC_ShoppingCart->setGiftWrapping(true);
      } else {
        $osC_ShoppingCart->setGiftWrapping(false);
      }
      
      $order_confirmation_form = self::_getOrderConfirmationForm();
      
      $response = array('success' => true, 'order_confirmation_form' => $order_confirmation_form);
      
      echo $toC_Json->encode($response);
    }
  }
?>