<?php
/*
  $Id: checkout.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2009 Wuxi Elootec Technology Co., Ltd;

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/
  require_once('includes/classes/china_address.php');
  
  class toC_Json_Address_book {
    
    function countryChange() {
      global $toC_Json, $osC_Database, $osC_Language;
      
      $zones_array = array();
      foreach (osC_Address::getZones($_REQUEST['country_id']) as $country) {
        $zones_array[] = array('id' => $country['name'], 'text' => $country['name']);
      }
      
      if (sizeof($zones_array) > 0) {
        $response = array(
          'success' => true, 
          'html' => osc_draw_label($osC_Language->get('field_customer_state'), null, 'state', (ACCOUNT_STATE > 0)) . osc_draw_pull_down_menu('address_book_state', $zones_array));
      } else {
        $response = array(
          'success' => true, 
          'html' => osc_draw_label($osC_Language->get('field_customer_state'), null, 'state', (ACCOUNT_STATE > 0)) . osc_draw_input_field('address_book_state'));
      }
      
      echo $toC_Json->encode($response);
    }
    
    function stateChange() {
      global $toC_Json, $osC_Database, $osC_Language;
      
      $cities_array = array();
      foreach (toC_China_Address::getCities($_REQUEST['state_name']) as $city) {
        $cities_array[] = array('id' => $city['name'],
                                'text' => $city['name']);
      }
  
      if (sizeof($cities_array) > 0) {
        $response = array(
          'success' => true, 
          'html' => osc_draw_label($osC_Language->get('field_customer_city'), null, 'city', true) . osc_draw_pull_down_menu('address_book_city', $cities_array));
      } else {
        $response = array(
          'success' => true, 
          'html' => osc_draw_label($osC_Language->get('field_customer_city'), null, 'city', true) . osc_draw_input_field('address_book_city'));
      }
      
      echo $toC_Json->encode($response);
    }
    
    function cityChange() {
      global $toC_Json, $osC_Database, $osC_Language;
      
      $city_id = toC_China_Address::getChinaRegionId($_REQUEST['city_name'], REGION_TYPE_CITY);
      
      $suburb_array = array();
      foreach (toC_China_Address::getDistricts($city_id) as $suburb) {
        $suburb_array[] = array('id' => $suburb['name'],
                                'text' => $suburb['name']);
      }
  
      if (sizeof($suburb_array) > 0) {
        $response = array(
          'success' => true, 
          'html' => osc_draw_label($osC_Language->get('field_customer_suburb'), 'suburb', 'suburb', (ACCOUNT_SUBURB > 0)) . osc_draw_pull_down_menu('address_book_suburb', $suburb_array));
      } else {
        $response = array(
          'success' => true, 
          'html' => osc_draw_label($osC_Language->get('field_customer_suburb'), 'suburb', 'suburb', (ACCOUNT_SUBURB > 0)) . osc_draw_input_field('address_book_suburb'));
      }
      
      echo $toC_Json->encode($response);
    }
  }
?>