<?php
/*
  $Id: purchased_history.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2010 Wuxi Elootec Technology Co., Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/

  class osC_Content_purchased_history extends osC_Modules {
    var $_title,
        $_code = 'purchased_history',
        $_author_name = 'TomatoCart',
        $_author_www = 'http://www.tomatocart.cn',
        $_group = 'content';

/* Class constructor */

    function osC_Content_purchased_history() {
      global $osC_Language;

      $this->_title = $osC_Language->get('purchased_history_title');
    }

    function initialize() {
      global $osC_Database, $osC_Language, $osC_Product, $osC_Image;

      if (isset($osC_Product)) {
        $Qorders = $osC_Database->query('select o.customers_name, o.date_purchased, op.products_quantity, os.orders_status_name from :table_orders o, :table_orders_products op, :table_orders_status os where o.orders_id = op.orders_id and op.products_id = :products_id and o.orders_status = os.orders_status_id order by o.date_purchased DESC limit :limit');
        $Qorders->bindTable(':table_orders', TABLE_ORDERS);
        $Qorders->bindTable(':table_orders_products', TABLE_ORDERS_PRODUCTS);
        $Qorders->bindTable(':table_orders_status', TABLE_ORDERS_STATUS);
        $Qorders->bindInt(':products_id', $osC_Product->getID());
        $Qorders->bindInt(':limit', MODULE_CONTENT_PURCHASED_HISTORY_MAX_DISPLAY);
        
        if (MODULE_CONTENT_PURCHASED_HISTORY_CACHE > 0) {
          $Qorders->setCache('purchased_history-' . $osC_Product->getID(), MODULE_CONTENT_PURCHASED_HISTORY_CACHE);
        }
        $Qorders->execute();
        
        $this->_content .= '<table border="0" width="100%" cellspacing="20" cellpadding="2" style="text-align: center;">';
        
        if ( $Qorders->numberOfRows() >= MODULE_CONTENT_PURCHASED_HISTORY_MIN_DISPLAY ) {
          $this->_content .= '<tr><td>用户名</td><td>购买数量</td><td>购买时间</td><td>订单状态</td>';

          while ($Qorders->next()) {
            $this->_content .= '<tr>';
            $this->_content .= '<td>' . $Qorders->value('customers_name') . '</td>';
            $this->_content .= '<td>' . $Qorders->value('products_quantity') . '</td>';
            $this->_content .= '<td>' . $Qorders->value('date_purchased') . '</td>';
            $this->_content .= '<td>' . $Qorders->value('orders_status_name') . '</td>';
            $this->_content .= '</tr>';
          }
        } else {
          $this->_content .= '目前还没有会员购买过该商品';
        }
        
        $this->_content .= '</table>';
        
        $Qorders->freeResult();
      }
    }

    function install() {
      global $osC_Database;

      parent::install();

      $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('最少显示商品购买记录数', 'MODULE_CONTENT_PURCHASED_HISTORY_MIN_DISPLAY', '1', '在列表中最少显示商品购买记录数。', '6', '0', now())");
      $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('最多显示商品购买记录数', 'MODULE_CONTENT_PURCHASED_HISTORY_MAX_DISPLAY', '6', '在列表中最多显示商品购买记录数。', '6', '0', now())");
      $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('缓存数据时间', 'MODULE_CONTENT_PURCHASED_HISTORY_CACHE', '60', '您希望缓存商品购买记录数据多少分钟 (0表示不缓存数据)。', '6', '0', now())");
    }

    function getKeys() {
      if (!isset($this->_keys)) {
        $this->_keys = array('MODULE_CONTENT_PURCHASED_HISTORY_MIN_DISPLAY', 'MODULE_CONTENT_PURCHASED_HISTORY_MAX_DISPLAY', 'MODULE_CONTENT_PURCHASED_HISTORY_CACHE');
      }

      return $this->_keys;
    }
  }
?>
