<?php
/*
  $Id: friend_link.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2011 Wuxi Elootec Technology Co., Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/

  class osC_Content_friend_link extends osC_Modules {
    var $_title,
        $_code = 'friend_link',
        $_author_name = 'TomatoCart',
        $_author_www = 'http://www.tomatocart.cn',
        $_group = 'content';

/* Class constructor */

    function osC_Content_friend_link() {
      global $osC_Language;

      $this->_title = $osC_Language->get('friend_link_title');
    }

    function initialize() {
      global $osC_Database, $osC_Services, $osC_Language, $osC_Image, $osC_Template, $osC_Currencies;

      $Qfl = $osC_Database->query('select fl.friend_link_id, fl.friend_link_url, fl.friend_link_image, fld.friend_link_name from :table_friend_link fl, :table_friend_link_description fld where fl.friend_link_id = fld.friend_link_id and fld.language_id = :language_id and fl.friend_link_status = 1 order by fl.friend_link_order, fld.friend_link_name');
      $Qfl->bindTable(':table_friend_link', TABLE_FRIEND_LINK);
      $Qfl->bindTable(':table_friend_link_description', TABLE_FRIEND_LINK_DESCRIPTION);
      $Qfl->bindInt(':language_id', $osC_Language->getID());
      $Qfl->setCache('friend_link-' . $osC_Language->getCode() . '-' . $osC_Currencies->getCode());
      $Qfl->execute();

      while ($Qfl->next()) {
        $this->_content .= '<ul>';
        
        $friend_link_image = $Qfl->value('friend_link_image');
        if (!empty($friend_link_image) && file_exists(DIR_WS_IMAGES . 'friendlink/' . $friend_link_image)) {
          $this->_content .= '<li>' . '<a href="' . $Qfl->value('friend_link_url') . '" target="_blank">' . osc_image("images/friendlink/" . $friend_link_image, $Qfl->value('friend_link_name'), '25', '25') . '</a></li>';
        } else {
          $this->_content .= '<li>' . '<a href="' . $Qfl->value('friend_link_url') . '" target="_blank">' . $Qfl->value('friend_link_name') . '</a></li>';
        }
        
        $this->_content .= '</ul>';
      }
      $Qfl->freeResult();
    }
  }
?>
