<?php
/*
  $Id: article_category_list.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2011 Wuxi Elootec Technology Co., Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/

  class osC_Content_article_category_list extends osC_Modules {
    var $_title,
        $_code = 'article_category_list',
        $_author_name = 'TomatoCart',
        $_author_www = 'http://www.tomatocart.cn',
        $_group = 'content';

/* Class constructor */

    function osC_Content_article_category_list() {
      global $osC_Language;

      $this->_title = $osC_Language->get('article_category_list_title');
    }

    function initialize() {
      global $osC_Database, $osC_Services, $osC_Language, $osC_Image, $osC_Template;

      $Qac = $osC_Database->query('select cd.articles_categories_id, cd.articles_categories_name from :table_articles_categories c, :table_articles_categories_description cd where c.articles_categories_id = cd.articles_categories_id and cd.language_id = :language_id and c.articles_categories_status = 1 order by c.articles_categories_order, cd.articles_categories_name');
      $Qac->bindTable(':table_articles_categories', TABLE_ARTICLES_CATEGORIES);
      $Qac->bindTable(':table_articles_categories_description', TABLE_ARTICLES_CATEGORIES_DESCRIPTION);
      $Qac->bindInt(':language_id', $osC_Language->getID());
      $Qac->execute();
      
      $i = 0;
      while ($Qac->next()) {
        if($Qac->valueInt('articles_categories_id') > 1){
          $i ++;
          if(($i % 5) == 1){
            $this->_content .= '<div class="art-list-row">';
          }          
        
          $this->_content .= '<div style="float: left;width: 20%;">';
        
          $this->_content .= '<ul>';
          $this->_content .= '<li class="art-list-title"><span>|</span>' . osc_link_object(osc_href_link(FILENAME_INFO, 'articles_categories&articles_categories_id='.$Qac->value('articles_categories_id')), $Qac->value('articles_categories_name')) . '</li>';
          
          $Qarticles = $osC_Database->query('select ad.articles_id, ad.articles_name from :table_articles a, :table_articles_description ad where a.articles_id = ad.articles_id and ad.language_id = :language_id and a.articles_status = 1 and a.articles_categories_id = :articles_categories_id order by a.articles_order');
          $Qarticles->bindTable(':table_articles', TABLE_ARTICLES);
          $Qarticles->bindTable(':table_articles_description', TABLE_ARTICLES_DESCRIPTION);
          $Qarticles->bindInt(':articles_categories_id', $Qac->valueInt('articles_categories_id'));
          $Qarticles->bindInt(':language_id', $osC_Language->getID());
          $Qarticles->execute();
           
          while ( $Qarticles->next() ) {
            $this->_content .= '<li>' . osc_link_object(osc_href_link(FILENAME_INFO, 'articles&articles_id='.$Qarticles->value('articles_id')), $Qarticles->value('articles_name')) . '</li>';
          }
          $Qarticles->freeResult();
          
          $this->_content .= '</ul>';
          
          $this->_content .= '<div style="clear: both;"></div></div>';
        }
        
        if(($i % 5) == 0 && $i != 0){
          $this->_content .= '<div style="clear: both;"></div></div>';
        }  
      }
      $Qac->freeResult();
    }
  }
?>
