<?php
/*
  $Id: store_notice.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2009 Wuxi Elootec Technology Co., Ltd;  Copyright (c) 2006 osCommerce

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/

  class osC_Boxes_store_notice extends osC_Modules {
    var $_title,
        $_code = 'store_notice',
        $_author_name = 'TomatoCart',
        $_author_www = 'http://www.tomatocart.com',
        $_group = 'boxes';

    function osC_Boxes_store_notice() {
      global $osC_Language;

      $this->_title = $osC_Language->get('box_store_notice_heading');
    }

    function initialize() {
      global $osC_Database, $osC_Language;

      $Qnotice = $osC_Database->query('select n.notice_id, nd.notice_name, nd.notice_url from :table_notice n, :table_notice_description nd where n.notice_id = nd.notice_id and nd.language_id = :language_id and n.notice_status = 1 order by n.notice_order');
			$Qnotice->bindTable(':table_notice', TABLE_NOTICE);
			$Qnotice->bindTable(':table_notice_description', TABLE_NOTICE_DESCRIPTION);
			$Qnotice->bindInt(':language_id', $osC_Language->getID());
			$Qnotice->bindInt(':max_dispaly', BOX_STORE_NOTICE_MAX_LIST);
			$Qnotice->setCache('box_notice-' . $osC_Language->getCode());
      $Qnotice->execute();

      if ($Qnotice->numberOfRows() >= BOX_STORE_NOTICE_MIN_LIST) {
        $i = 0;
        $this->_content = '<ul>';

        while ($Qnotice->next()) {
          $i ++;
          if($i == $Qnotice->numberOfRows()){
            $this->_content .= '<li class="clearborder notice-item">'. osc_link_object(osc_href_link(FILENAME_INFO, 'notice&notice_id='.$Qnotice->valueInt('notice_id')), $Qnotice->value('notice_name')). '</li>';
          }else {
            $this->_content .= '<li class="notice-item">'. osc_link_object(osc_href_link(FILENAME_INFO, 'notice&notice_id='.$Qnotice->valueInt('notice_id')), $Qnotice->value('notice_name')). '</li>';
          }
        }

        $this->_content .= '</ul>';
      }

      $Qnotice->freeResult();
      
    }

    function install() {
      global $osC_Database;

      parent::install();

      $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('最少显示公告个数', 'BOX_STORE_NOTICE_MIN_LIST', '3', '在列表中最少显示公告个数。', '6', '0', now())");
      $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('最多显示公告个数', 'BOX_STORE_NOTICE_MAX_LIST', '10', '在列表中最多显示公告个数。', '6', '0', now())");
    }

    function getKeys() {
      if (!isset($this->_keys)) {
        $this->_keys = array('BOX_STORE_NOTICE_MIN_LIST',
                             'BOX_STORE_NOTICE_MAX_LIST');
      }

      return $this->_keys;
    }
  }
?>
