<?php
/*
  $Id: news.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2009 Wuxi Elootec Technology Co., Ltd;  Copyright (c) 2006 osCommerce

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/

  class osC_Boxes_news extends osC_Modules {
    var $_title,
        $_code = 'news',
        $_author_name = 'TomatoCart',
        $_author_www = 'http://www.tomatocart.cn',
        $_group = 'boxes';

    function osC_Boxes_news() {
      global $osC_Language;

      $this->_title = $osC_Language->get('box_news_heading');
    }

    function initialize() {
      global $osC_Database,$osC_Language;
      
      $Qnews = $osC_Database->query('select n.news_id, nd.news_name, nd.news_url from :table_news n, :table_news_description nd where n.news_id = nd.news_id and nd.language_id = :language_id and n.news_status = 1 order by n.news_order');
      $Qnews->bindTable(':table_news', TABLE_NEWS);
      $Qnews->bindTable(':table_news_description', TABLE_NEWS_DESCRIPTION);
      $Qnews->bindInt(':language_id', $osC_Language->getID());
      $Qnews->bindInt(':max_display_news_list_size', BOX_NEWS_LIST_SIZE);
      $Qnews->setCache('box_news-' . $osC_Language->getCode());
      $Qnews->execute();

      if ( $Qnews->numberOfRows() > 0 ) {
        $this->_content = '<ul>';

        while ($Qnews->next()) {
          $this->_content .= '<li>' . osc_link_object(osc_href_link(FILENAME_INFO, 'news&news_id='.$Qnews->valueInt('news_id')), $Qnews->value('news_name')) . '</li>';
        }
    
        $this->_content .= '</ul>';
      }
      $Qnews->freeResult();
    }

    function install() {
      global $osC_Database;

      parent::install();

      $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('最多显示商城新闻数目', 'BOX_NEWS_LIST_SIZE', '10', '在列表中最多显示商城新闻数目。', '6', '0', now())");
      
    }

    function getKeys() {
      if (!isset($this->_keys)) {
        $this->_keys = array('BOX_NEWS_LIST_SIZE');
      }

      return $this->_keys;
    }
  }
?>
