<?php
/*
  $Id: express_search.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2010 Wuxi Elootec Technology Co., Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/

  class osC_Boxes_express_search extends osC_Modules {
    var $_title,
        $_code = 'express_search',
        $_author_name = 'TomatoCart',
        $_author_www = 'http://www.tomatocart.cn',
        $_group = 'boxes';

    function osC_Boxes_express_search() {
      global $osC_Language;

      $this->_title = $osC_Language->get('box_express_search_heading');
    }

    function initialize() {
      global $osC_Database, $osC_Language, $osC_Template;

      $osC_Language->load('express_search');
      
      $Qorder = $osC_Database->query('select orders_id, tracking_no from :table_orders order by orders_id DESC limit :max_display_orders');
      $Qorder->bindTable(':table_orders', TABLE_ORDERS);
      $Qorder->bindInt(':max_display_orders', BOX_EXPRESS_SEARCH_MAX_LIST);
      
      if (BOX_EXPRESS_SEARCH_CACHE > 0) {
        $Qorder->setCache('box_express_search-0-' . $osC_Language->getCode(), BOX_EXPRESS_SEARCH_CACHE);
      }
      
      $Qorder->execute();
      
      if ($Qorder->numberOfRows() >= BOX_EXPRESS_SEARCH_MIN_LIST) {
        while ( $Qorder->next() ) {
          if ( $Qorder->value('tracking_no') != null ) {
            $this->_content .= '<div id="express_search">' . $osC_Language->get('orders_id') . $Qorder->valueInt('orders_id') . '<br>' . $osC_Language->get('tracking_no'). $Qorder->value('tracking_no') . '</div>';
          }
        }
      }
    }
    
    function install() {
      global $osC_Database;

      parent::install();

      $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('最少显示订单个数', 'BOX_EXPRESS_SEARCH_MIN_LIST', '1', '在列表中最少显示订单个数。', '6', '0', now())");
      $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('最多显示订单个数', 'BOX_EXPRESS_SEARCH_MAX_LIST', '10', '在列表中最多显示订单个数。', '6', '0', now())");
      $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('缓存数据时间', 'BOX_EXPRESS_SEARCH_CACHE', '60', '您希望缓存订单数据多少分钟 (0表示不缓存数据)。', '6', '0', now())");
    }
    
    function getKeys() {
      if (!isset($this->_keys)) {
        $this->_keys = array('BOX_EXPRESS_SEARCH_MIN_LIST', 'BOX_EXPRESS_SEARCH_MAX_LIST', 'BOX_EXPRESS_SEARCH_CACHE');
      }

      return $this->_keys;
    }
  }
?>
