<?php
/*
  $Id: best_sellers.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2009 Wuxi Elootec Technology Co., Ltd;  Copyright (c) 2006 osCommerce

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/

  class osC_Boxes_best_sellers extends osC_Modules {
    var $_title,
        $_code = 'best_sellers',
        $_author_name = 'osCommerce',
        $_author_www = 'http://www.oscommerce.com',
        $_group = 'boxes';

    function osC_Boxes_best_sellers() {
      global $osC_Language;

      $this->_title = $osC_Language->get('box_best_sellers_heading');
    }

    function initialize() {
      global $osC_Database, $osC_Language, $current_category_id, $osC_Image, $osC_Currencies;

      if (isset($current_category_id) && ($current_category_id > 0)) {
        $Qbestsellers = $osC_Database->query('select distinct p.products_id, pd.products_name, pd.products_keyword, p.products_price, pi.image from :table_products p, :table_products_description pd, :table_products_to_categories p2c, :table_categories c, :table_products_images pi where p.products_status = 1 and p.products_ordered > 0 and p.products_id = pd.products_id and p.products_id = pi.products_id and pi.default_flag = 1 and pd.language_id = :language_id and p.products_id = p2c.products_id and p2c.categories_id = c.categories_id and :current_category_id in (c.categories_id, c.parent_id) order by p.products_ordered desc, pd.products_name limit :max_display_bestsellers');
        $Qbestsellers->bindTable(':table_products', TABLE_PRODUCTS);
        $Qbestsellers->bindTable(':table_products_description', TABLE_PRODUCTS_DESCRIPTION);
        $Qbestsellers->bindTable(':table_products_to_categories', TABLE_PRODUCTS_TO_CATEGORIES);
        $Qbestsellers->bindTable(':table_categories', TABLE_CATEGORIES);
        $Qbestsellers->bindTable(':table_products_images', TABLE_PRODUCTS_IMAGES);
        $Qbestsellers->bindInt(':language_id', $osC_Language->getID());
        $Qbestsellers->bindInt(':current_category_id', $current_category_id);
        $Qbestsellers->bindInt(':max_display_bestsellers', BOX_BEST_SELLERS_MAX_LIST);

        if (BOX_BEST_SELLERS_CACHE > 0) {
          $Qbestsellers->setCache('box_best_sellers-' . $current_category_id . '-' . $osC_Language->getCode(), BOX_BEST_SELLERS_CACHE);
        }

        $Qbestsellers->execute();
      } else {
        $Qbestsellers = $osC_Database->query('select p.products_id, pd.products_name, pd.products_keyword, p.products_price, pi.image from :table_products p, :table_products_description pd, :table_products_images pi where p.products_status = 1 and p.products_ordered > 0 and p.products_id = pd.products_id and p.products_id = pi.products_id and pi.default_flag = 1 and pd.language_id = :language_id order by p.products_ordered desc, pd.products_name limit :max_display_bestsellers');
        $Qbestsellers->bindTable(':table_products', TABLE_PRODUCTS);
        $Qbestsellers->bindTable(':table_products_description', TABLE_PRODUCTS_DESCRIPTION);
        $Qbestsellers->bindTable(':table_products_images', TABLE_PRODUCTS_IMAGES);
        $Qbestsellers->bindInt(':language_id', $osC_Language->getID());
        $Qbestsellers->bindInt(':max_display_bestsellers', BOX_BEST_SELLERS_MAX_LIST);

        if (BOX_BEST_SELLERS_CACHE > 0) {
          $Qbestsellers->setCache('box_best_sellers-0-' . $osC_Language->getCode(), BOX_BEST_SELLERS_CACHE);
        }

        $Qbestsellers->execute();
      }

      if ($Qbestsellers->numberOfRows() >= BOX_BEST_SELLERS_MIN_LIST) {
        $i = 0;
        $this->_content = '<ol>';

        while ($Qbestsellers->next()) {
          if($i == 0) {
            $this->_content .= '<li class="withborderbottom">'.
                                  '<div class="sequenceimage">'. osc_image('/images/top1.jpg', null, 27, 30). '</div>'.
                                  '<div class="top3productimage">'. osc_link_object(osc_href_link(FILENAME_PRODUCTS, $Qbestsellers->value('products_id')), $osC_Image->show($Qbestsellers->value('image'), null, 'class="bestseller"')). '</div>'.  
                                  '<div class="productname">'.
                                    '<div>'. osc_link_object(osc_href_link(FILENAME_PRODUCTS, $Qbestsellers->value('products_id')), $Qbestsellers->value('products_name')). '</div>'. 
                                    '<div class="bestsellerprice">'. $osC_Currencies->displayPrice($Qbestsellers->value('products_price'), 0). '</div>'. 
                                  '</div>'. 
                                  '<div style="clear: both;"></div>'.
                               '</li>';
          }else if($i == 1){
            $this->_content .= '<li class="withborderbottom">'.
                                  '<div class="sequenceimage"><a href="">'. osc_image('/images/top2.jpg', null, 27, 30). '</a></div>'.
                                  '<div class="top3productimage">'. osc_link_object(osc_href_link(FILENAME_PRODUCTS, $Qbestsellers->value('products_id')), $osC_Image->show($Qbestsellers->value('image'), null, 'class="bestseller"')). '</div>'.
                                  '<div class="productname">'.     
	                                  '<div>'.osc_link_object(osc_href_link(FILENAME_PRODUCTS, $Qbestsellers->value('products_id')), $Qbestsellers->value('products_name')). '</div>'. 
	                                  '<div class="bestsellerprice">'.$osC_Currencies->displayPrice($Qbestsellers->value('products_price'), 0). '</div>'.
                                  '</div>'. 
                                  '<div style="clear: both;"></div>'.
                               '</li>';
          }else if($i == 2){
            $this->_content .= '<li class="withborderbottom">'.
                                  '<div class="sequenceimage"><a href="">'. osc_image('/images/top3.jpg', null, 27, 30). '</a></div>'. 
                                  '<div class="top3productimage">'. osc_link_object(osc_href_link(FILENAME_PRODUCTS, $Qbestsellers->value('products_id')), $osC_Image->show($Qbestsellers->value('image'), null, 'class="bestseller"')). '</div>'.  
                                  '<div class="productname">'.
	                                  '<div>'.osc_link_object(osc_href_link(FILENAME_PRODUCTS, $Qbestsellers->value('products_id')), $Qbestsellers->value('products_name')). '</div>'.
	                                  '<div class="bestsellerprice">'.$osC_Currencies->displayPrice($Qbestsellers->value('products_price'), 0). '</div>'.
                                  '</div>'.
                                  '<div style="clear: both;"></div>'.
                               '</li>';
          }else{
            $k = $i + 1;
            $this->_content .= '<li class="withborderbottom">' .
                                  '<div class="sequence">'. $k. '</div>'. 
                                  '<div class="productnameonly">'. osc_link_object(osc_href_link(FILENAME_PRODUCTS, $Qbestsellers->value('products_id')), $Qbestsellers->value('products_name')). '</div>'.
                                  '<div style="clear: both;"></div>'.
                               '</li>';
          }
          $i ++;
        }

        $this->_content .= '</ol>';
      }

      $Qbestsellers->freeResult();
    }

    function install() {
      global $osC_Database;

      parent::install();

      $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('最少显示商品个数', 'BOX_BEST_SELLERS_MIN_LIST', '3', '在列表中最少显示商品个数。', '6', '0', now())");
      $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('最多显示商品个数', 'BOX_BEST_SELLERS_MAX_LIST', '10', '在列表中最多显示商品个数。', '6', '0', now())");
      $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('缓存数据时间', 'BOX_BEST_SELLERS_CACHE', '60', '您希望缓存热销商品数据多少分钟 (0表示不缓存数据)。', '6', '0', now())");
    }

    function getKeys() {
      if (!isset($this->_keys)) {
        $this->_keys = array('BOX_BEST_SELLERS_MIN_LIST',
                             'BOX_BEST_SELLERS_MAX_LIST',
                             'BOX_BEST_SELLERS_CACHE');
      }

      return $this->_keys;
    }
  }
?>
