<?php
/*
  $Id: address_book_details.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2009 Wuxi Elootec Technology Co., Ltd;  Copyright (c) 2006 osCommerce

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/

  $country_id = isset($Qentry) ? $Qentry->valueInt('entry_country_id') : STORE_COUNTRY;
  $state = isset($Qentry) ? $Qentry->value('entry_state') : null;
  $city = isset($Qentry) ? $Qentry->value('entry_city') : null;
  $zone_id = isset($Qentry) ? $Qentry->value('entry_zone_id') : null;
  $suburb = isset($Qentry) ? $Qentry->value('entry_suburb') : null;
  
  if ($zone_id > 0) { $state = $zone_id; }
?>

<ol>

<?php
  if (ACCOUNT_GENDER > -1) {
    $gender_array = array(array('id' => 'm', 'text' => $osC_Language->get('gender_male')),
                          array('id' => 'f', 'text' => $osC_Language->get('gender_female')));
?>

  <li><?php echo osc_draw_label($osC_Language->get('field_customer_gender'), 'gender1', 'fake', (ACCOUNT_GENDER > 0)) . osc_draw_radio_field('gender', $gender_array, (isset($Qentry) ? $Qentry->value('entry_gender') : (!$osC_Customer->hasDefaultAddress() ? $osC_Customer->getGender() : null))); ?></li>

<?php
  }
?>

  <li><?php echo osc_draw_label($osC_Language->get('field_customer_last_name'), 'lastname', 'lastname', true) . osc_draw_input_field('lastname', (isset($Qentry) ? $Qentry->value('entry_lastname') : (!$osC_Customer->hasDefaultAddress() ? $osC_Customer->getLastName() : null))); ?></li>
  <li><?php echo osc_draw_label($osC_Language->get('field_customer_first_name'), 'firstname', 'firstname', true) . osc_draw_input_field('firstname', (isset($Qentry) ? $Qentry->value('entry_firstname') : (!$osC_Customer->hasDefaultAddress() ? $osC_Customer->getFirstName() : null))); ?></li>

<?php
  if (ACCOUNT_COMPANY > -1) {
?>

  <li><?php echo osc_draw_label($osC_Language->get('field_customer_company'), 'company', 'company', (ACCOUNT_COMPANY > 0)) . osc_draw_input_field('company', (isset($Qentry) ? $Qentry->value('entry_company') : null)); ?></li>

<?php
  }
?>

<?php
  if (ACCOUNT_POST_CODE > -1) {
?>

  <li><?php echo osc_draw_label($osC_Language->get('field_customer_post_code'), 'postcode', 'postcode', (ACCOUNT_POST_CODE > 0)) . osc_draw_input_field('postcode', (isset($Qentry) ? $Qentry->value('entry_postcode') : null)); ?></li>

<?php
  }
?>

  <li id="address_book-country">
<?php
  echo osc_draw_label($osC_Language->get('field_customer_country'), 'country', 'country', true);

  $countries_array = array(array('id' => '',
                                 'text' => $osC_Language->get('pull_down_default')));

  foreach (osC_Address::getCountries() as $country) {
    $countries_array[] = array('id' => $country['id'],
                               'text' => $country['name']);
  }

  echo osc_draw_pull_down_menu('address_book_country', $countries_array, $country_id, 'onchange="countryChange();"');
?>

  </li>
  
<?php
  if (ACCOUNT_STATE > -1) {
?>

  <li id="address_book-state">

<?php
    echo osc_draw_label($osC_Language->get('field_customer_state'), 'state', 'state', (ACCOUNT_STATE > 0));
    
    $zones_array = array();
    foreach (osC_Address::getZones($country_id) as $zone) {
      $zones_array[] = array('id' => $zone['name'], 'text' => $zone['name']);
    }

    if (is_numeric($state)) {
      $state = osC_Address::getZoneName($state);
    }

    if (sizeof($zones_array) > 0) {
      echo osc_draw_pull_down_menu('address_book_state', $zones_array, $state, 'onchange="stateChange();"');
    } else {
      echo osc_draw_input_field('address_book_state', $state);
    }
?>

  </li>

<?php
  }
?>

  <li id="address_book-city">
    <?php 
      echo osc_draw_label($osC_Language->get('field_customer_city'), 'city', 'city', true);
      
      $cities_array = array();
      if ($country_id == CHINA_COUNTRY_ID) {
        if ($state == null) {
          if (sizeof($zones_array) > 0) {
            $state = $zones_array[0]['text'];
          }
        }
        
        if ($state !== null) {
          foreach (toC_China_Address::getCities($state) as $region) {
            $cities_array[] = array('id' => $region['name'], 'text' => $region['name']);
          }        
        }
      }

      if (sizeof($cities_array) > 0) {
        echo osc_draw_pull_down_menu('address_book_city', $cities_array, $city, 'onchange="cityChange();"');
      } else {
        echo osc_draw_input_field('address_book_city', $city);
      }
    ?>
  </li>

<?php
  if (ACCOUNT_SUBURB > -1) {
?>

  <li id="address_book-suburb">
  <?php
    echo osc_draw_label($osC_Language->get('field_customer_suburb'), 'suburb', 'suburb', (ACCOUNT_SUBURB > 0));

    $suburb_array = array();
    if ($country_id == CHINA_COUNTRY_ID) {
      if ($city == null) {
        if (sizeof($cities_array) > 0) {
          $city = $cities_array[0]['text'];
        }
      }
            
      if ($city !== null) {
        $city_id = toC_China_Address::getChinaRegionId($city, REGION_TYPE_CITY);
        foreach (toC_China_Address::getDistricts($city_id) as $region) {
          $suburb_array[] = array('id' => $region['name'], 'text' => $region['name']);
        }        
      }
    }
    
    if (sizeof($suburb_array) > 0) {
      echo osc_draw_pull_down_menu('address_book_suburb', $suburb_array, $suburb);
    } else {
      echo osc_draw_input_field('address_book_suburb', $suburb);
    }
  ?>
  </li>

<?php
  }
?>

  <li><?php echo osc_draw_label($osC_Language->get('field_customer_street_address'), 'street_address', 'street_address', true) . osc_draw_input_field('street_address', (isset($Qentry) ? $Qentry->value('entry_street_address') : null)); ?></li>

<?php
  if (ACCOUNT_TELEPHONE > -1) {
?>

  <li><?php echo osc_draw_label($osC_Language->get('field_customer_telephone_number'), 'telephone', 'telephone', (ACCOUNT_TELEPHONE > 0)) . osc_draw_input_field('telephone', (isset($Qentry) ? $Qentry->value('entry_telephone') : null)); ?></li>

<?php
  }

  if (ACCOUNT_FAX > -1) {
?>

  <li><?php echo osc_draw_label($osC_Language->get('field_customer_fax_number'), 'fax', 'fax', (ACCOUNT_FAX > 0)) . osc_draw_input_field('fax', (isset($Qentry) ? $Qentry->value('entry_fax') : null)); ?></li>

<?php
  }

  if ($osC_Customer->hasDefaultAddress() && ((isset($_GET['edit']) && ($osC_Customer->getDefaultAddressID() != $_GET['address_book'])) || isset($_GET['new'])) ) {
?>

  <li><?php echo osc_draw_checkbox_field('primary', array(array('id' => 'on', 'text' => $osC_Language->get('set_as_primary'))), false); ?></li>

<?php
  }
?>

</ol>
