/*
  $Id: order_search.js $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2010 Wuxi Elootec Technology Co., Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/

  var OrderSearch = new Class({
    initialize: function () {
      this.iniTabs();
    },
    
    sendRequest: function(data, fnSuccess) {
      data.module = 'order_search';
      
      var loadRequest = new Request({
        url: 'json.php',
        data: data,
        
        onSuccess: fnSuccess.bind(this)
      }).send();
    },

    iniTabs: function() {
    	$('orderSearch').addEvent('click', function() {
    	  var params = {
          action: 'search_order',
          orders_id: $('order_id').value
        };
        $("order_search_result").empty().addClass('loading');
        
        this.sendRequest(params, function(response) {
          var result = JSON.decode(response);
          $("order_search_result").removeClass('loading');
          
          if (result.success == true) {
            $('order_search_result').set('html', result.html);
          } else {
            alert(result.html);
          }
        });
    	}.bind(this));
    } 
  });