<?php
/*
  $Id: notice.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2011 Wuxi Elootec Technology Co., Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/

  class osC_Info_Notice extends osC_Template {

/* Private variables */

    var $_module = 'notice',
        $_group = 'info',
        $_page_title,
        $_page_contents = 'notice.php',
        $_page_image = 'table_background_reviews_new.gif';

/* Class constructor */

    function osC_Info_Notice() {
      global $osC_Language, $osC_Services, $breadcrumb, $osC_Database, $notice;
      
      if ( isset($_GET['notice_id']) && !empty($_GET['notice_id']) ) {
        $Qnotice = $osC_Database->query('select * from :table_notice n, :table_notice_description nd where n.notice_id = nd.notice_id and nd.language_id = :language_id and n.notice_id = :notice_id');
        $Qnotice->bindTable(':table_notice', TABLE_NOTICE);
        $Qnotice->bindTable(':table_notice_description', TABLE_NOTICE_DESCRIPTION);
        $Qnotice->bindInt(':language_id', $osC_Language->getID());
        $Qnotice->bindInt(':notice_id', $_GET['notice_id']);
        $Qnotice->execute();
        
        $notice = $Qnotice->toArray();
        
        if ( $Qnotice->numberOfRows() > 0 ) {
          $this->_page_title = $notice['notice_name'];
          
          if (!empty($notice['page_title'])) {
            $this->setMetaPageTitle($notice['page_title']);        
          }
          
          if (!empty($notice['meta_keywords'])) {
            $this->addPageTags('keywords', $notice['meta_keywords']);
          }
          
          if (!empty($notice['meta_description'])) {
            $this->addPageTags('description', $notice['meta_description']);
          }
          
          if ($osC_Services->isStarted('breadcrumb')) {
            $breadcrumb->add($notice['notice_name'], osc_href_link(FILENAME_INFO, 'notice&notice_id=' . $_GET['notice_id']));
          }
        }
      } else {
        $this->_page_title = $osC_Language->get('info_not_found_heading');
        $this->_page_contents = 'info_not_found.php';
      }
    }
  }
?>
