<?php
/*
  $Id: news.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2011 Wuxi Elootec Technology Co., Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/

  class osC_Info_News extends osC_Template {

/* Private variables */

    var $_module = 'news',
        $_group = 'info',
        $_page_title,
        $_page_contents = 'news.php',
        $_page_image = 'table_background_reviews_new.gif';

/* Class constructor */

    function osC_Info_News() {
      global $osC_Language, $osC_Services, $breadcrumb, $osC_Database, $news;
      
      if ( isset($_GET['news_id']) && !empty($_GET['news_id']) ) {
        $Qnews = $osC_Database->query('select * from :table_news n, :table_news_description nd where n.news_id = nd.news_id and nd.language_id = :language_id and n.news_id = :news_id');
        $Qnews->bindTable(':table_news', TABLE_NEWS);
        $Qnews->bindTable(':table_news_description', TABLE_NEWS_DESCRIPTION);
        $Qnews->bindInt(':language_id', $osC_Language->getID());
        $Qnews->bindInt(':news_id', $_GET['news_id']);
        $Qnews->execute();
        
        $news = $Qnews->toArray();
        
        if ( $Qnews->numberOfRows() > 0 ) {
          $this->_page_title = $news['news_name'];
          
          if (!empty($news['page_title'])) {
            $this->setMetaPageTitle($news['page_title']);        
          }
          
          if (!empty($news['meta_keywords'])) {
            $this->addPageTags('keywords', $news['meta_keywords']);
          }
          
          if (!empty($news['meta_description'])) {
            $this->addPageTags('description', $news['meta_description']);
          }
          
          if ($osC_Services->isStarted('breadcrumb')) {
            $breadcrumb->add($news['news_name'], osc_href_link(FILENAME_INFO, 'news&news_id=' . $_GET['news_id']));
          }
        }
      } else {
        $this->_page_title = $osC_Language->get('info_not_found_heading');
        $this->_page_contents = 'info_not_found.php';
      }
    }
  }
?>
