<?php
/*
  $Id: china_shipping.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2010 Wuxi Elootec Technology Co., Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/
  require_once('includes/classes/shipping.php');
  require_once('includes/classes/china_address.php');
  
  class toC_China_Shipping extends osC_Shipping {
  
// class constructor
    function toC_China_Shipping($module = '') {
      parent::osC_Shipping($module);
    }
    
    function getChinaShippingAreaId() {
      global $osC_Database, $osC_ShoppingCart;
      
      if ($osC_ShoppingCart->getShippingAddress('country_id') === CHINA_COUNTRY_ID) {
        $Qzone = $osC_Database->query('select zone_name from :table_zones where zone_id = :zone_id');
        $Qzone->bindTable(':table_zones', TABLE_ZONES);
        $Qzone->bindInt(':zone_id', $osC_ShoppingCart->getShippingAddress('zone_id'));
        $Qzone->execute();
        
        if ($Qzone->numberOfRows() === 1) {
          $state_id = toC_China_Address::getChinaRegionId($Qzone->value('zone_name'), REGION_TYPE_PROVINCE);
        }

        if (is_numeric($state_id)) {
          $city_id = toC_China_Address::getChinaRegionId($osC_ShoppingCart->getShippingAddress('city'), REGION_TYPE_CITY, $state_id);

          if (is_numeric($city_id)) {
            $district_id = toC_China_Address::getChinaRegionId($osC_ShoppingCart->getShippingAddress('suburb'), REGION_TYPE_DISTRICT, $city_id);

            if (is_numeric($district_id)) {
              $region_data = array('district_id' => $district_id,
                                   'city_id' => $city_id,
                                   'state_id' => $state_id,
                                   'country_id' => 1);
              
              foreach ($region_data as $id) {
                $Qcheck = $osC_Database->query('select catr.china_region_id, csa.china_shipping_area_id from :table_china_area_to_region catr inner join :table_china_shipping_area csa on catr.china_shipping_area_id = csa.china_shipping_area_id where csa.china_shipping_code = :china_shipping_code and catr.china_region_id = :china_region_id');
                $Qcheck->bindTable(':table_china_area_to_region', TABLE_CHINA_AREA_TO_REGION);
                $Qcheck->bindTable(':table_china_shipping_area', TABLE_CHINA_SHIPPING_AREA);
                $Qcheck->bindValue(':china_shipping_code', $this->_code);
                $Qcheck->bindInt(':china_region_id', $id);
                $Qcheck->execute();
                
                if ($Qcheck->numberOfRows() > 0) {
                  $shipping_area_id = $Qcheck->valueInt('china_shipping_area_id');
                  
                  return $shipping_area_id;
                }
              }
            }
          }
        }
      }

      return false;
    }
    
    function getQuotes() {
      global $osC_ShippingCart;
      
      foreach ($this->_modules as $module) {
        if ($GLOBALS['osC_Shipping_' . $module]->isEnabled()) {
          $include_quotes[] = 'osC_Shipping_' . $module;
        }
      }
      
      foreach ($include_quotes as $module) {
        $quotes = $GLOBALS[$module]->quote();

        if (is_array($quotes)) {
          $_quotes[] = $quotes;
        }
      }
      
      self::_calculate();
      
      return $_quotes;
    }
  }