<?php
/*
  $Id: china_address.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2010 Wuxi Elootec Technology Co., Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/

  class toC_China_Address extends osC_Address {
    
    function getCities($name = null) {
      global $osC_Database;
      
      $cities_array = array();
      
      $state_id = self::getChinaRegionId($name, REGION_TYPE_PROVINCE);
      
      $Qcities = $osC_Database->query('select china_region_id, region_name from :table_china_region where parent_id = :parent_id and region_type = :type');
      $Qcities->bindTable(':table_china_region', TABLE_CHINA_REGION);
      $Qcities->bindInt(':parent_id', $state_id);
      $Qcities->bindInt(':type', REGION_TYPE_CITY);
      $Qcities->execute();
      
      while ($Qcities->next()) {
        $cities_array[] = array('id' => $Qcities->valueInt('china_region_id'),
                                'name' => $Qcities->value('region_name'));
      }
      
      return $cities_array;
    }
    
    function getDistricts($id = null) {
      global $osC_Database;
      
      $districts_array = array();
      
      $Qdistricts = $osC_Database->query('select china_region_id, region_name from :table_china_region where');
      
      if (!empty($id)) {
        $Qdistricts->appendQuery('parent_id = :id');
      }
      
      $Qdistricts->bindTable(':table_china_region', TABLE_CHINA_REGION);
      $Qdistricts->bindInt(':id', $id);
      $Qdistricts->execute();
      
      while ($Qdistricts->next()) {
        $districts_array[] = array('id' => $Qdistricts->valueInt('china_region_id'),
                                   'name' => $Qdistricts->value('region_name'));
      }
      
      return $districts_array;
    }
    
    function getAreaNameById($id = null) {
      global $osC_Database;
      
      $region_name = '';
      
      $Qselecet = $osC_Database->query('select region_name from :table_china_region where china_region_id = :id');
      $Qselecet->bindTable(':table_china_region', TABLE_CHINA_REGION);
      $Qselecet->bindInt(':id', $id);
      $Qselecet->execute();
      
      if ($Qselecet->numberOfRows() === 1) {
        $region_name = $Qselecet->value('region_name');
      }
      
      return $region_name;
    }
    
    function getChinaRegionId($name, $type, $parent_id = 0) {
      global $osC_Database;
      
      $Qregion = $osC_Database->query('select china_region_id from :table_china_region where region_name = :name and region_type = :type');
      $Qregion->bindTable(':table_china_region', TABLE_CHINA_REGION);
      $Qregion->bindValue(':name', $name);
      $Qregion->bindInt(':type', $type);
      
      if ($parent_id > 0) {
        $Qregion->appendQuery('and parent_id = :parent_id');
        $Qregion->bindInt(':parent_id', $parent_id);
      }
      
      $Qregion->execute();

      $region_id = false;
      if ($Qregion->numberOfRows() === 1) {
        $region_id = $Qregion->valueInt('china_region_id');
      }
      
      return $region_id;
    }
  }
?>
