<?php
/*
  $Id: paypal_standard.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2010 Wuxi Elootec Technology Co., Ltd;

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/

/**
 * The administration side of the PayPal Standard payment module
 */

  class osC_Payment_paypal_standard extends osC_Payment_Admin {

/**
 * The administrative title of the payment module
 *
 * @var string
 * @access private
 */
  var $_title;
  
/**
 * The code of the payment module
 *
 * @var string
 * @access private
 */

  var $_code = 'paypal_standard';
  
/**
 * The developers name
 *
 * @var string
 * @access private
 */

  var $_author_name = 'tomatocart';
  
/**
 * The developers address
 *
 * @var string
 * @access private
 */  
  
  var $_author_www = 'http://www.tomatocart.com';
  
/**
 * The status of the module
 *
 * @var boolean
 * @access private
 */

  var $_status = false;
  
/**
 * Constructor
 */

  function osC_Payment_paypal_standard() {
    global $osC_Language;
    
    $this->_title = $osC_Language->get('payment_paypal_standard_title');
    $this->_description = $osC_Language->get('payment_paypal_standard_description');
    $this->_method_title = $osC_Language->get('payment_paypal_standard_method_title');
    $this->_status = (defined('MODULE_PAYMENT_PAYPAL_STANDARD_STATUS') && (MODULE_PAYMENT_PAYPAL_STANDARD_STATUS == '1') ? true : false);
    $this->_sort_order = (defined('MODULE_PAYMENT_PAYPAL_STANDARD_SORT_ORDER') ? MODULE_PAYMENT_PAYPAL_STANDARD_SORT_ORDER : null);
  }
  
/**
 * Checks to see if the module has been installed
 *
 * @access public
 * @return boolean
 */

  function isInstalled() {
    return (bool)defined('MODULE_PAYMENT_PAYPAL_STANDARD_STATUS');
  }
  
/**
 * Installs the module
 *
 * @access public
 * @see osC_Payment_Admin::install()
 */

  function install() {
    global $osC_Database, $osC_Language;
    
    parent::install();
    
    $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('激活PayPal标准支付方式', 'MODULE_PAYMENT_PAYPAL_STANDARD_STATUS', '-1', '您希望激活PayPal标准支付方式吗？', '6', '1', 'osc_cfg_set_boolean_value(array(1, -1))', now())");
    $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('E-Mail邮件地址', 'MODULE_PAYMENT_PAYPAL_STANDARD_ID', '', '店主的邮件地址用于接受PayPal支付。', '6', '2', now())");
    $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('排序', 'MODULE_PAYMENT_PAYPAL_STANDARD_SORT_ORDER', '0', '支付方式排列顺序，数字越小位置越靠前。', '6', '3', now())");
    $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('支付区域', 'MODULE_PAYMENT_PAYPAL_STANDARD_ZONE', '0', '如果选择了区域，那么该支付方式只能在此区域中有效。', '6', '4', 'osc_cfg_use_get_zone_class_title', 'osc_cfg_set_zone_classes_pull_down_menu', now())");
    $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, use_function, date_added) values ('PayPal回执订单状态', 'MODULE_PAYMENT_PAYPAL_STANDARD_ORDER_STATUS_ID', '" . ORDERS_STATUS_PAID . "', 'Paypal返回回执信息时订单自动转换到该订单状态。', '6', '6', 'osc_cfg_set_order_statuses_pull_down_menu', 'osc_cfg_use_get_order_status_title', now())");
    $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('交易服务器', 'MODULE_PAYMENT_PAYPAL_STANDARD_GATEWAY_SERVER', 'Sandbox', '使用测试服务器(sandbox)或实际服务器(live gateway)进行交易?', '6', '7', 'osc_cfg_set_boolean_value(array(\'Live\', \'Sandbox\'))', now())");
    $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('发送购物车商品', 'MODULE_PAYMENT_PAYPAL_STANDARD_TRANSFER_CART', '1', '是否把购物车里的商品信息发送给PayPal?', '6', '8', 'osc_cfg_set_boolean_value(array(1, -1))', now())");
    $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('店主秘钥', 'MODULE_PAYMENT_PAYPAL_IPN_EWP_PRIVATE_KEY', '', '店主秘钥本地路径(*.pem)。', '6', '9', now())");
    $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('交易方法', 'MODULE_PAYMENT_PAYPAL_STANDARD_TRANSACTION_METHOD', 'Sale', '每个交易的处理方式。', '6', '10', 'osc_cfg_set_boolean_value(array(\'Authorization\', \'Sale\'))', now())");
    $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('页面样式', 'MODULE_PAYMENT_PAYPAL_STANDARD_PAGE_STYLE', '', 'PayPal交易页面样式(默认情况下将使用PayPal默认设置)。', '6', '11', now())");
    $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('调试邮件地址', 'MODULE_PAYMENT_PAYPAL_STANDARD_DEBUG_EMAIL', '', '所有错误的IPN回执信息参数将被发送到该邮件地址。', '6', '12', now())");
    $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('激活支付加密', 'MODULE_PAYMENT_PAYPAL_STANDARD_EWP_STATUS', '-1', '您希望使用支付加密吗?', '6', '13', 'osc_cfg_set_boolean_value(array(1, -1))', now())");
    $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('店主秘钥', 'MODULE_PAYMENT_PAYPAL_STANDARD_EWP_PRIVATE_KEY', '', '店主秘钥本地路径(*.pem)。', '6', '14', now())");
    $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('店主公钥', 'MODULE_PAYMENT_PAYPAL_STANDARD_EWP_PUBLIC_KEY', '', '店主公钥本地路径(*.pem)。', '6', '15', now())");
    $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('PayPal公钥', 'MODULE_PAYMENT_PAYPAL_STANDARD_EWP_PAYPAL_KEY', '', 'PayPal公钥本地路径。', '6', '16', now())");
    $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('店主PayPal公钥ID', 'MODULE_PAYMENT_PAYPAL_STANDARD_EWP_CERT_ID', '', '店主PayPal公钥ID。', '6', '17', now())");
    $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('OpenSSL路径', 'MODULE_PAYMENT_PAYPAL_STANDARD_EWP_OPENSSL', '/usr/bin/openssl', 'OpenSSL本地路径。', '6', '19', now())");
  }

/**
 * Return the configuration parameter keys in an array
 *
 * @access public
 * @return array
 */

  function getKeys() {
    if (!isset($this->_keys)) {
      $this->_keys = array('MODULE_PAYMENT_PAYPAL_STANDARD_STATUS', 
                           'MODULE_PAYMENT_PAYPAL_STANDARD_ID', 
                           'MODULE_PAYMENT_PAYPAL_STANDARD_ZONE', 
                           'MODULE_PAYMENT_PAYPAL_STANDARD_ORDER_STATUS_ID', 
                           'MODULE_PAYMENT_PAYPAL_STANDARD_GATEWAY_SERVER', 
                           'MODULE_PAYMENT_PAYPAL_STANDARD_TRANSFER_CART',
                           'MODULE_PAYMENT_PAYPAL_STANDARD_TRANSACTION_METHOD', 
                           'MODULE_PAYMENT_PAYPAL_STANDARD_PAGE_STYLE', 
                           'MODULE_PAYMENT_PAYPAL_STANDARD_DEBUG_EMAIL', 
                           'MODULE_PAYMENT_PAYPAL_STANDARD_SORT_ORDER', 
                           'MODULE_PAYMENT_PAYPAL_STANDARD_EWP_STATUS', 
                           'MODULE_PAYMENT_PAYPAL_STANDARD_EWP_PRIVATE_KEY', 
                           'MODULE_PAYMENT_PAYPAL_STANDARD_EWP_PUBLIC_KEY', 
                           'MODULE_PAYMENT_PAYPAL_STANDARD_EWP_PAYPAL_KEY', 
                           'MODULE_PAYMENT_PAYPAL_STANDARD_EWP_CERT_ID', 
                           'MODULE_PAYMENT_PAYPAL_STANDARD_EWP_OPENSSL');
    }
  
    return $this->_keys;
 } 
}
?>
