<?php
/*
  $Id: alipay.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2009 Wuxi Elootec Technology Co., Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/

/**
 * The administration side of the Amazon payment module
 */

  class osC_Payment_alipay extends osC_Payment_Admin {

/**
 * The administrative title of the payment module
 *
 * @var string
 * @access private
 */

    var $_title;

/**
 * The code of the payment module
 *
 * @var string
 * @access private
 */

    var $_code = 'alipay';

/**
 * The developers name
 *
 * @var string
 * @access private
 */

    var $_author_name = 'Arthur Xie';

/**
 * The developers address
 *
 * @var string
 * @access private
 */

  var $_author_www = 'http://os.jingxi8.com/';

/**
 * The status of the module
 *
 * @var boolean
 * @access private
 */

    var $_status = false;
  
/**
 * Constructor
 */

    function osC_Payment_alipay() {
      global $osC_Language;

      $this->_title = $osC_Language->get('payment_alipay_title');
      $this->_description = $osC_Language->get('payment_alipay_description');
      $this->_method_title = $osC_Language->get('payment_alipay_method_title');
      $this->_status = (defined('MODULE_PAYMENT_ALIPAY_STATUS') && (MODULE_PAYMENT_ALIPAY_STATUS == '1') ? true : false);
      $this->_sort_order = (defined('MODULE_PAYMENT_ALIPAY_SORT_ORDER') ? MODULE_PAYMENT_ALIPAY_SORT_ORDER : null);
    }

/**
 * Checks to see if the module has been installed
 *
 * @access public
 * @return boolean
 */

    function isInstalled() {
      return (bool)defined('MODULE_PAYMENT_ALIPAY_STATUS');
    }

/**
 * Installs the module
 *
 * @access public
 * @see osC_Payment_Admin::install()
 */

    function install() {
      global $osC_Database;

      parent::install();

      $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('启用支付宝支付模块', 'MODULE_PAYMENT_ALIPAY_STATUS', '-1', '您是否要启用支付宝即时到账支付模块？', '6', '0', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))', now())");
      $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('支付宝接口类型', 'MODULE_PAYMENT_ALIPAY_TYPE', '0', '0 = 纯担保接口；1 = 即时到账接口；2 = 标准双接口。', '6', '0', now())");
      $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('邮件地址', 'MODULE_PAYMENT_ALIPAY_EMAIL', '', '您的签约支付宝账号或卖家支付宝帐户。', '6', '0', now())");
      $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('合作者身份ID', 'MODULE_PAYMENT_ALIPAY_API_PARTNER', '', '您支付宝账户的合作者身份ID。', '6', '0', now())");
      $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('安全检验码', 'MODULE_PAYMENT_ALIPAY_API_SECURITY_CODE', '', '您账户的交易安全校验码，注意保密!', '6', '0', now())");
      $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('收款方名称', 'MODULE_PAYMENT_ALIPAY_MAIN_NAME', '', '收款方名称，如：公司名称、网站名称、收款人姓名等。', '6', '0', now())");
      $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('排序', 'MODULE_PAYMENT_ALIPAY_SORT_ORDER', '0', '支付方式排列顺序，数字越小位置越靠前。', '6', '0', now())");
      $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('支付区域', 'MODULE_PAYMENT_ALIPAY_ZONE', '0', '如果选择了区域，那么该支付方式只能在此区域中有效。', '6', '0', 'osc_cfg_use_get_zone_class_title', 'osc_cfg_set_zone_classes_pull_down_menu', now())");
      $osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, use_function, date_added) values ('设置订单状态', 'MODULE_PAYMENT_ALIPAY_ORDER_STATUS_ID', '" . ORDERS_STATUS_PAID . "', '设置客户付款完成后的订单状态。', '6', '0', 'osc_cfg_set_order_statuses_pull_down_menu', 'osc_cfg_use_get_order_status_title', now())");
    }

/**
 * Return the configuration parameter keys in an array
 *
 * @access public
 * @return array
 */

    function getKeys() {
      if (!isset($this->_keys)) {
        $this->_keys = array('MODULE_PAYMENT_ALIPAY_STATUS',
                             'MODULE_PAYMENT_ALIPAY_TYPE',
                             'MODULE_PAYMENT_ALIPAY_EMAIL',
                             'MODULE_PAYMENT_ALIPAY_API_PARTNER',
                             'MODULE_PAYMENT_ALIPAY_API_SECURITY_CODE',
                             'MODULE_PAYMENT_ALIPAY_MAIN_NAME',
                             'MODULE_PAYMENT_ALIPAY_SORT_ORDER',
                             'MODULE_PAYMENT_ALIPAY_ZONE',
                             'MODULE_PAYMENT_ALIPAY_ORDER_STATUS_ID');
      }

      return $this->_keys;
    }
  }
?>
