<?php
/*
  $Id: notice.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2011 Wuxi Elootec Technology Co., Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/
  require('includes/classes/notice.php');
  require('includes/classes/image.php');
  
  class toC_Json_Notice {
    
    function listNotice() {
      global $toC_Json, $osC_Language, $osC_Database;
      
      $start = empty($_REQUEST['start']) ? 0 : $_REQUEST['start']; 
      $limit = empty($_REQUEST['limit']) ? MAX_DISPLAY_SEARCH_RESULTS : $_REQUEST['limit']; 

      $Qnotice = $osC_Database->query('select n.notice_id, n.notice_status, n.notice_order, nd.notice_name from :table_notice n, :table_notice_description nd where nd.language_id = :language_id and n.notice_id = nd.notice_id');
    
      if (!empty($_REQUEST['search'])) {
        $Qnotice->appendQuery('and nd.notice_name like :notice_name');
        $Qnotice->bindValue(':notice_name', '%' . $_REQUEST['search'] . '%');
      }
    
      $Qnotice->appendQuery('order by n.notice_id ');
      $Qnotice->bindTable(':table_notice', TABLE_NOTICE);
      $Qnotice->bindTable(':table_notice_description', TABLE_NOTICE_DESCRIPTION);
      $Qnotice->bindInt(':language_id', $osC_Language->getID());
      $Qnotice->setExtBatchLimit($start, $limit);
      $Qnotice->execute();
      
      $records = array();
      while ($Qnotice->next()) {
        $records[] = array('notice_id' => $Qnotice->ValueInt('notice_id'),
                           'notice_status' => $Qnotice->ValueInt('notice_status'),
                           'notice_order' => $Qnotice->Value('notice_order'),
                           'notice_name' => $Qnotice->Value('notice_name'));
      }
      
      $response = array(EXT_JSON_READER_TOTAL => $Qnotice->getBatchSize(),
                        EXT_JSON_READER_ROOT => $records);
                        
      echo $toC_Json->encode($response);
    }
    
    function loadNotice() {
      global $osC_Database, $toC_Json;
      
      $data = toC_Notice_Admin::getData($_REQUEST['notice_id']);
      
      $Qnd = $osC_Database->query('select notice_name, notice_url, notice_description, notice_page_title, notice_meta_keywords, notice_meta_description, language_id from :table_notice_description where notice_id = :notice_id');
      $Qnd->bindTable(':table_notice_description', TABLE_NOTICE_DESCRIPTION);
      $Qnd->bindInt(':notice_id', $_REQUEST['notice_id']);
      $Qnd->execute();
      
      while ($Qnd->next()) {
        $data['notice_name[' . $Qnd->valueInt('language_id') . ']'] = $Qnd->value('notice_name');
        $data['notice_url[' . $Qnd->valueInt('language_id') . ']'] = $Qnd->value('notice_url');
        $data['notice_description[' . $Qnd->valueInt('language_id') . ']'] = $Qnd->value('notice_description');
        $data['page_title[' . $Qnd->ValueInt('language_id') . ']'] = $Qnd->Value('notice_page_title');
        $data['meta_keywords[' . $Qnd->ValueInt('language_id') . ']'] = $Qnd->Value('notice_meta_keywords');
        $data['meta_description[' . $Qnd->ValueInt('language_id') . ']'] = $Qnd->Value('notice_meta_description');
      }
      
      $response = array('success' => true, 'data' => $data);
      
      echo $toC_Json->encode($response);
    }
    
    function saveNotice() {
      global $toC_Json, $osC_Language, $osC_Image;
      
      $osC_Image = new osC_Image_Admin();
      
      //search engine friendly urls
      $formatted_urls = array();
      $urls = $_REQUEST['notice_url'];
      if (is_array($urls) && !empty($urls)) {
        foreach($urls as $languages_id => $url) {
          $url = toc_format_friendly_url($url);
          if (empty($url)) {
            $url = toc_format_friendly_url($_REQUEST['notice_name'][$languages_id]);
          }
          
          $formatted_urls[$languages_id] = $url;
        }
      }
      
      $data = array('notice_name' => $_REQUEST['notice_name'],
                    'notice_url' => $formatted_urls,
                    'notice_description' => $_REQUEST['notice_description'],
                    'notice_order' => $_REQUEST['notice_order'],
                    'notice_status' => $_REQUEST['notice_status'],
//                    'delimage' => (isset($_REQUEST['delimage']) && ($_REQUEST['delimage'] == 'on') ? '1' : '0'),
                    'page_title' => $_REQUEST['page_title'],
                    'meta_keywords' => $_REQUEST['meta_keywords'],
                    'meta_description' => $_REQUEST['meta_description']);
                    
      if ( toC_Notice_Admin::save((isset($_REQUEST['notice_id']) && ($_REQUEST['notice_id'] != -1) ? $_REQUEST['notice_id'] : null), $data) ) {
        $response = array('success' => true, 'feedback' => $osC_Language->get('ms_success_action_performed'));
      } else {
        $response = array('success' => false, 'feedback' => $osC_Language->get('ms_error_action_not_performed'));
      }
      
      header('Content-Type: text/html');
      echo $toC_Json->encode($response);
    }
    
    function deleteNotice() {
      global $toC_Json, $osC_Language, $osC_Image;
      
      $osC_Image = new osC_Image_Admin();
      
      if (toC_Notice_Admin::delete($_REQUEST['notice_id'])) {
        $response = array('success' => true, 'feedback' => $osC_Language->get('ms_success_action_performed'));
      } else {
        $response = array('success' => false, 'feedback' => $osC_Language->get('ms_error_action_not_performed'));
      }   
      
      echo $toC_Json->encode($response);
    }
    
    function deleteNotices() {
      global $toC_Json, $osC_Language, $osC_Database, $osC_Image;
      
      $osC_Image = new osC_Image_Admin();
      
      $error = false;
      
      $batch = explode(',', $_REQUEST['batch']);
      foreach($batch as $notice_id) {
        if (!toC_Notice_Admin::delete($notice_id)) {
          $error = true;
          break;
        }
      }
    
      if ($error === false) {      
        $response = array('success' => true, 'feedback' => $osC_Language->get('ms_success_action_performed'));
      } else {
        $response = array('success' => false, 'feedback' => $osC_Language->get('ms_error_action_not_performed'));
      }
      
      echo $toC_Json->encode($response);
    }
    
    function setStatus() {
      global $toC_Json, $osC_Language;
      
      if ( isset($_REQUEST['notice_id']) && toC_Notice_Admin::setStatus($_REQUEST['notice_id'], (isset($_REQUEST['flag']) ? $_REQUEST['flag'] : null)) ) {
        $response = array('success' => true, 'feedback' => $osC_Language->get('ms_success_action_performed'));
      } else {
        $response = array('success' => false, 'feedback' => $osC_Language->get('ms_error_action_not_performed'));
      }
      
      echo $toC_Json->encode($response);
    }
  }
?>