<?php
/*
  $Id: news.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2011 Wuxi Elootec Technology Co., Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/
  require('includes/classes/news.php');
  require('includes/classes/image.php');
  
  class toC_Json_News {
    
    function listNews() {
      global $toC_Json, $osC_Language, $osC_Database;
      
      $start = empty($_REQUEST['start']) ? 0 : $_REQUEST['start']; 
      $limit = empty($_REQUEST['limit']) ? MAX_DISPLAY_SEARCH_RESULTS : $_REQUEST['limit']; 

      $Qnews = $osC_Database->query('select n.news_id, n.news_status, n.news_order, nd.news_name from :table_news n, :table_news_description nd where nd.language_id = :language_id and n.news_id = nd.news_id');
    
      if (!empty($_REQUEST['search'])) {
        $Qnews->appendQuery('and nd.news_name like :news_name');
        $Qnews->bindValue(':news_name', '%' . $_REQUEST['search'] . '%');
      }
    
      $Qnews->appendQuery('order by n.news_id ');
      $Qnews->bindTable(':table_news', TABLE_NEWS);
      $Qnews->bindTable(':table_news_description', TABLE_NEWS_DESCRIPTION);
      $Qnews->bindInt(':language_id', $osC_Language->getID());
      $Qnews->setExtBatchLimit($start, $limit);
      $Qnews->execute();
      
      $records = array();
      while ($Qnews->next()) {
      	$records[] = array('news_id' => $Qnews->ValueInt('news_id'),
                           'news_status' => $Qnews->ValueInt('news_status'),
      	                   'news_order' => $Qnews->Value('news_order'),
      	                   'news_name' => $Qnews->Value('news_name'));
      }
      
      $response = array(EXT_JSON_READER_TOTAL => $Qnews->getBatchSize(),
                        EXT_JSON_READER_ROOT => $records);
                        
      echo $toC_Json->encode($response);
    }
    
    function loadNew() {
      global $osC_Database, $toC_Json;
      
      $data = toC_News_Admin::getData($_REQUEST['news_id']);
      
      $Qnd = $osC_Database->query('select news_name, news_url, news_description, news_page_title, news_meta_keywords, news_meta_description, language_id from :table_news_description where news_id = :news_id');
      $Qnd->bindTable(':table_news_description', TABLE_NEWS_DESCRIPTION);
      $Qnd->bindInt(':news_id', $_REQUEST['news_id']);
      $Qnd->execute();
      
      while ($Qnd->next()) {
        $data['news_name[' . $Qnd->valueInt('language_id') . ']'] = $Qnd->value('news_name');
        $data['news_url[' . $Qnd->valueInt('language_id') . ']'] = $Qnd->value('news_url');
        $data['news_description[' . $Qnd->valueInt('language_id') . ']'] = $Qnd->value('news_description');
        $data['page_title[' . $Qnd->ValueInt('language_id') . ']'] = $Qnd->Value('news_page_title');
        $data['meta_keywords[' . $Qnd->ValueInt('language_id') . ']'] = $Qnd->Value('news_meta_keywords');
        $data['meta_description[' . $Qnd->ValueInt('language_id') . ']'] = $Qnd->Value('news_meta_description');
      }
      
      $response = array('success' => true, 'data' => $data);
      
      echo $toC_Json->encode($response);
    }
    
    function saveNew() {
      global $toC_Json, $osC_Language, $osC_Image;
      
      $osC_Image = new osC_Image_Admin();
      
      //search engine friendly urls
      $formatted_urls = array();
      $urls = $_REQUEST['news_url'];
      if (is_array($urls) && !empty($urls)) {
        foreach($urls as $languages_id => $url) {
          $url = toc_format_friendly_url($url);
          if (empty($url)) {
            $url = toc_format_friendly_url($_REQUEST['news_name'][$languages_id]);
          }
          
          $formatted_urls[$languages_id] = $url;
        }
      }
      
      $data = array('news_name' => $_REQUEST['news_name'],
                    'news_url' => $formatted_urls,
                    'news_description' => $_REQUEST['news_description'],
                    'news_order' => $_REQUEST['news_order'],
                    'news_status' => $_REQUEST['news_status'],
                    'delimage' => (isset($_REQUEST['delimage']) && ($_REQUEST['delimage'] == 'on') ? '1' : '0'),
                    'page_title' => $_REQUEST['page_title'],
                    'meta_keywords' => $_REQUEST['meta_keywords'],
                    'meta_description' => $_REQUEST['meta_description']);
                    
      if ( toC_News_Admin::save((isset($_REQUEST['news_id']) && ($_REQUEST['news_id'] != -1) ? $_REQUEST['news_id'] : null), $data) ) {
        $response = array('success' => true, 'feedback' => $osC_Language->get('ms_success_action_performed'));
      } else {
        $response = array('success' => false, 'feedback' => $osC_Language->get('ms_error_action_not_performed'));
      }
      
      header('Content-Type: text/html');
      echo $toC_Json->encode($response);
    }
    
    function deleteNew() {
      global $toC_Json, $osC_Language, $osC_Image;
      
      $osC_Image = new osC_Image_Admin();
      
      if (toC_News_Admin::delete($_REQUEST['news_id'])) {
        $response = array('success' => true, 'feedback' => $osC_Language->get('ms_success_action_performed'));
      } else {
        $response = array('success' => false, 'feedback' => $osC_Language->get('ms_error_action_not_performed'));
      }   
      
      echo $toC_Json->encode($response);
    }
    
    function deleteNews() {
      global $toC_Json, $osC_Language, $osC_Database, $osC_Image;
      
      $osC_Image = new osC_Image_Admin();
      
      $error = false;
      
      $batch = explode(',', $_REQUEST['batch']);
      foreach($batch as $news_id) {
        if (!toC_News_Admin::delete($news_id)) {
          $error = true;
          break;
        }
      }
    
      if ($error === false) {      
        $response = array('success' => true, 'feedback' => $osC_Language->get('ms_success_action_performed'));
      } else {
        $response = array('success' => false, 'feedback' => $osC_Language->get('ms_error_action_not_performed'));
      }
      
      echo $toC_Json->encode($response);
    }
    
    function setStatus() {
      global $toC_Json, $osC_Language;
      
      if ( isset($_REQUEST['news_id']) && toC_News_Admin::setStatus($_REQUEST['news_id'], (isset($_REQUEST['flag']) ? $_REQUEST['flag'] : null)) ) {
        $response = array('success' => true, 'feedback' => $osC_Language->get('ms_success_action_performed'));
      } else {
        $response = array('success' => false, 'feedback' => $osC_Language->get('ms_error_action_not_performed'));
      }
      
      echo $toC_Json->encode($response);
    }
  }
?>