<?php
/*
  $Id: friend_link.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2011 Wuxi Elootec Technology Co., Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/
  require('includes/classes/friend_link.php');
  
  class toC_Json_Friend_link {
        
    function listFriendLinks() {
      global $toC_Json, $osC_Database, $osC_Language;
      
      $start = empty($_REQUEST['start']) ? 0 : $_REQUEST['start']; 
      $limit = empty($_REQUEST['limit']) ? MAX_DISPLAY_SEARCH_RESULTS : $_REQUEST['limit']; 
      
      $Qlinks = $osC_Database->query('select fl.friend_link_id, fl.friend_link_status, fl.friend_link_image, fld.friend_link_name from :table_friend_link fl, :table_friend_link_description fld where fl.friend_link_id = fld.friend_link_id and fld.language_id = :language_id');
      $Qlinks->bindTable(':table_friend_link', TABLE_FRIEND_LINK);
      $Qlinks->bindTable(':table_friend_link_description', TABLE_FRIEND_LINK_DESCRIPTION);
      $Qlinks->bindInt(':language_id', $osC_Language->getID());
      $Qlinks->appendQuery('order by fld.friend_link_name');
      $Qlinks->setExtBatchLimit($start, $limit);
      $Qlinks->execute();

      $records = array();     
      while ( $Qlinks->next() ) {           
        $records[] = array(
          'friend_link_id' => $Qlinks->valueInt('friend_link_id'),
          'friend_link_name' => $Qlinks->value('friend_link_name'),
          'friend_link_status' => $Qlinks->valueInt('friend_link_status'),
          'friend_link_image' => $Qlinks->value('friend_link_image')
        );           
      }
      $Qlinks->freeResult();
      
      $response = array(EXT_JSON_READER_TOTAL => $Qlinks->getBatchSize(),
                        EXT_JSON_READER_ROOT => $records);
     
      echo $toC_Json->encode($response);
    }
    
    function saveFriendLink() {
      global $toC_Json, $osC_Language;
      
      $data = array('friend_link_name' => $_REQUEST['friend_link_name'],
                    'friend_link_status' => $_REQUEST['friend_link_status'],
                    'friend_link_order' => $_REQUEST['friend_link_order'],
                    'friend_link_url' => $_REQUEST['friend_link_url']);
      
      if ( toC_Friend_Link_Admin::save( ( isset($_REQUEST['friend_link_id'] ) && is_numeric( $_REQUEST['friend_link_id'] ) ? $_REQUEST['friend_link_id'] : null ), $data) ) {
        $response = array('success' => true, 'feedback' => $osC_Language->get('ms_success_action_performed'));
      } else {
        $response = array('success' => false, 'feedback' => $osC_Language->get('ms_error_action_not_performed'));
      }
      
      echo $toC_Json->encode($response);
    }
    
    function loadFriendLink() {
      global $toC_Json, $osC_Database;
      
      $data = toC_Friend_Link_Admin::getData($_REQUEST['friend_link_id']);
      
      $data['date_added'] = osC_DateTime::getDate($data['date_added']);
      
      $Qdescription = $osC_Database->query('select friend_link_name, language_id from :table_friend_link_description where friend_link_id = :friend_link_id');
      $Qdescription->bindTable(':table_friend_link_description', TABLE_FRIEND_LINK_DESCRIPTION);
      $Qdescription->bindInt(':friend_link_id', $_REQUEST['friend_link_id']);
      $Qdescription->execute();
      
      while ($Qdescription->next()) {
        $data['friend_link_name[' . $Qdescription->valueInt('language_id') .']'] = $Qdescription->value('friend_link_name');
      }
      $Qdescription->freeResult();
        
      $response = array('success' => true, 'data' => $data);
     
      echo $toC_Json->encode($response);   
    }
   
    function deleteFriendLink() {
      global $toC_Json, $osC_Language;
      
      if (toC_Friend_Link_Admin::delete($_REQUEST['friend_link_id'])) {
        $response = array('success' => true, 'feedback' => $osC_Language->get('ms_success_action_performed'));
      } else {
        $response = array('success' => false, 'feedback' => $osC_Language->get('ms_error_action_not_performed'));
      }
     
      echo $toC_Json->encode($response);                            
    }
    
    function deleteFriendLinks() {
      global $toC_Json, $osC_Language;
     
      $error = false;
      
      $batch = explode(',', $_REQUEST['batch']);
      foreach ($batch as $id) {
        if ( !toC_Friend_Link_Admin::delete($id) ) {
          $error = true;
          break;
        }
      }
       
      if ($error === false) {      
        $response = array('success' => true, 'feedback' => $osC_Language->get('ms_success_action_performed'));
      } else {
        $response = array('success' => false, 'feedback' => $osC_Language->get('ms_error_action_not_performed'));
      }
       
      echo $toC_Json->encode($response);               
    } 
    
    function setStatus(){
      global $toC_Json, $osC_Language; 
    
      $flag = $_REQUEST['flag'];
      $friend_link_id = $_REQUEST['friend_link_id'];
      
      if (toC_Friend_Link_Admin::setStatus($friend_link_id, $flag)) {
        $response = array('success' => true, 'feedback' => $osC_Language->get('ms_success_action_performed'));
      } else {
        $response = array('success' => false, 'feedback' => $osC_Language->get('ms_error_action_not_performed'));
      }
      
      echo $toC_Json->encode($response);
    }
  }
?>
