<?php
/*
  $Id: custom_navigation_bar.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2010 Wuxi Elootec Technology Co., Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/
  
  require('includes/classes/custom_navigation_bar.php');
  require('includes/classes/category_tree.php');
  
  class toC_Json_Custom_Navigation_Bar {
  
    function listNavigations() {
      global $toC_Json, $osC_Language, $osC_Database;
      
      $start = empty($_REQUEST['start']) ? 0 : $_REQUEST['start']; 
      $limit = empty($_REQUEST['limit']) ? MAX_DISPLAY_SEARCH_RESULTS : $_REQUEST['limit']; 
      
      $Qselect = $osC_Database->query('select n.nav_id, nd.name, n.ifshow, n.vieworder, n.opennew, n.position_type from :table_nav n, :table_nav_description nd where n.nav_id = nd.nav_id and nd.languages_id = :languages_id order by nav_id');
      $Qselect->bindTable(':table_nav', TABLE_NAV);
      $Qselect->bindTable(':table_nav_description', TABLE_NAV_DESCRIPTION);
      $Qselect->bindInt(':languages_id', $osC_Language->getID());
      $Qselect->setExtBatchLimit($start, $limit);
      $Qselect->execute();
      
      $record = array();
      while ( $Qselect->next() ) {
        $record[] = array('nav_id' => $Qselect->valueInt('nav_id'),
                          'name' => $Qselect->value('name'),
                          'ifshow' => $Qselect->valueInt('ifshow'),
                          'opennew' => $Qselect->valueInt('opennew'),
                          'vieworder'  => $Qselect->valueInt('vieworder'),
                          'position_type' => $osC_Language->get('option_' . $Qselect->value('position_type')));
      }
      
      $response = array(EXT_JSON_READER_TOTAL => $Qselect->getBatchSize(),
                        EXT_JSON_READER_ROOT => $record); 
                        
      echo $toC_Json->encode($response);
      
    }
    
    function loadNavigation() {
      global $toC_Json, $osC_Language, $osC_Database;
      
      $data = osC_Custom_Navigation_Bar_Admin::getData($_REQUEST['nav_id']);
      
      $Qnd = $osC_Database->query('select languages_id, name from :table_nav_description where nav_id= :nav_id');
      $Qnd->bindTable(':table_nav_description', TABLE_NAV_DESCRIPTION);
      $Qnd->bindInt(':nav_id', $_REQUEST['nav_id']);
      $Qnd->execute();
      
      while ( $Qnd->next() ) {
        $data['name[' . $Qnd->ValueInt('languages_id') . ']'] =  $Qnd->value('name');
      }
      $Qnd->freeResult();
      
      $response = array('success' => true, 'data' => $data); 
      
      echo $toC_Json->encode($response);  
    }
    
    function getSystems() {
      global $toC_Json, $osC_Language, $osC_Database, $osC_CategoryTree;
      
      $osC_Language->load('general');
      $osC_Language->load('account');
      
      $categories_array = array(array('text' => $osC_Language->get('home'), 'url' => osc_href_link(FILENAME_DEFAULT, 'index')),
                                array('text' => $osC_Language->get('new_products'), 'url' => osc_href_link(FILENAME_PRODUCTS, 'new')),
                                array('text' => $osC_Language->get('my_account'), 'url' => osc_href_link(FILENAME_ACCOUNT, 'null', 'SSL')),
                                array('text' => $osC_Language->get('checkout'), 'url' => osc_href_link(FILENAME_CHECKOUT, 'cn_checkout', 'SSL')),
                                array('text' => $osC_Language->get('contact_us'), 'url' => osc_href_link(FILENAME_INFO, 'contact')),
                                array('text' => $osC_Language->get('my_orders_view'), 'url' => osc_href_link(FILENAME_ACCOUNT, 'orders', 'SSL')),
                                array('text' => $osC_Language->get('specials'), 'url' => osc_href_link(FILENAME_PRODUCTS, 'specials')),
                                array('text' => $osC_Language->get('my_wishlist'), 'url' => osc_href_link(FILENAME_ACCOUNT, 'wishlist', 'SSL')),
                                array('text' => $osC_Language->get('guest_book'), 'url' => osc_href_link(FILENAME_INFO, 'guestbook')));
      
      $osC_CategoryTree = new osC_CategoryTree_Admin();
      foreach ($osC_CategoryTree->getTree() as $category) {
        $categories_array[] = array('id' => $category['id'],
                                    'text' => $category['title'],
                                    'url' => osc_href_link(FILENAME_DEFAULT, 'cPath=' . $category['id']));
      }
      
      $response = array(EXT_JSON_READER_ROOT => $categories_array);
      
      echo $toC_Json->encode($response);  
    }
    
    function getPositions() {
      global $toC_Json, $osC_Language, $osC_Database;
      
      $positions_array = array(array('id' => 'top', 'text' => $osC_Language->get('option_top')),
                               array('id' => 'center', 'text' => $osC_Language->get('option_center')));
//      array('id' => 'bottom', 'text' => $osC_Language->get('option_bottom'))
      
      $response = array(EXT_JSON_READER_ROOT => $positions_array);
      
      echo $toC_Json->encode($response);  
    }
    
    function saveNavigation() {
      global $toC_Json, $osC_Language, $osC_Database;
      
      $data = array('name' => $_REQUEST['name'],
                    'url' => $_REQUEST['url'],
                    'vieworder' => $_REQUEST['vieworder'],
                    'ifshow' => $_REQUEST['ifshow'],
                    'opennew' => $_REQUEST['opennew'],
                    'position_type' => $_REQUEST['position_type']);
      
      if ( osC_Custom_Navigation_Bar_Admin::save($_REQUEST['nav_id'] > 0 ? $_REQUEST['nav_id'] : null, $data )) {
        $response = array('success' => true ,'feedback' => $osC_Language->get('ms_success_action_performed'));
      } else {
        $response = array('success' => false, 'feedback' => $osC_Language->get('ms_error_action_not_performed'));    
      }
      
      echo $toC_Json->encode($response);
    }
  
    function deleteNavigation() {
      global $toC_Json, $osC_Database, $osC_Language;
      
      if (osC_Custom_Navigation_Bar_Admin::delete( $_REQUEST['nav_id'])) {
        $response = array('success' => true ,'feedback' => $osC_Language->get('ms_success_action_performed'));
      } else {
        $response = array('success' => false, 'feedback' => $osC_Language->get('ms_error_action_not_performed'));    
      }
      
      echo $toC_Json->encode($response);
    }
    
    function deleteNavigations() {
      global $toC_Json, $osC_Database, $osC_Language;
    
      $error = false;
      
      $batch = explode(',', $_REQUEST['batch']);
      foreach ($batch as $id) {
        if (!osC_Custom_Navigation_Bar_Admin::delete($id)) {
          $error = true;
          break;
        }
      }
     
      if ($error === false) {
        $response = array('success' => true ,'feedback' => $osC_Language->get('ms_success_action_performed'));
      } else {
        $response = array('success' => false, 'feedback' => $osC_Language->get('ms_error_action_not_performed'));    
      }
      
      echo $toC_Json->encode($response);
    }
    
    function setIfshow() {
      global $toC_Json, $osC_Language;
      
      if ( isset($_REQUEST['nav_id']) && osC_Custom_Navigation_Bar_Admin::setIfshow($_REQUEST['nav_id'], (isset($_REQUEST['flag']) ? $_REQUEST['flag'] : 1)) ) {
        $response = array('success' => true, 'feedback' => $osC_Language->get('ms_success_action_performed'));
      } else {
        $response = array('success' => false, 'feedback' => $osC_Language->get('ms_error_action_not_performed'));
      }
  
      echo $toC_Json->encode($response);
    }
    
    function setOpennew() {
      global $toC_Json, $osC_Language;
      
      if ( isset($_REQUEST['nav_id']) && osC_Custom_Navigation_Bar_Admin::setOpennew($_REQUEST['nav_id'], (isset($_REQUEST['flag']) ? $_REQUEST['flag'] : 1)) ) {
        $response = array('success' => true, 'feedback' => $osC_Language->get('ms_success_action_performed'));
      } else {
        $response = array('success' => false, 'feedback' => $osC_Language->get('ms_error_action_not_performed'));
      }
  
      echo $toC_Json->encode($response);
    }
  }
?>
