<?php
/*
  $Id: main.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2011 Wuxi Elootec Technology Co., Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/

  echo 'Ext.namespace("Toc.notice");';
  
  include('notice_dialog.php');
  include('notice_grid.php');
  include('notice_general_panel.php');
  include('notice_meta_info_panel.php');
?>

Ext.override(TocDesktop.NoticeWindow, {

  createWindow: function() {
    var desktop = this.app.getDesktop();
    var win = desktop.getWindow('notice-win');
     
    if (!win) {
      grd = new Toc.notice.NoticeGrid({owner: this});
      
      win = desktop.createWindow({
        id: 'notice-win',
        title: '<?php echo $osC_Language->get('heading_notice_title'); ?>',
        width: 800,
        height: 400,
        iconCls: 'icon-notice-win',
        layout: 'fit',
        items: grd
      });
    }
    
    win.show();
  },
  
  createNoticeDialog: function() {
    var desktop = this.app.getDesktop();
    var dlg = desktop.getWindow('notice-dialog-win');
    
    if (!dlg) {
      dlg = desktop.createWindow({}, Toc.notice.NoticeDialog);
      
      dlg.on('saveSuccess', function(feedback) {
        this.app.showNotification({title: TocLanguage.msgSuccessTitle, html: feedback});
      }, this);
    }

    return dlg;
  }
});