<?php
/*
  $Id: china_shipping_areas_main_panel.php.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2009 Wuxi Elootec Technology Co., Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/

?>

Toc.modules_shipping.ChinaShippingAreasMainPanel = function(config) {
  config = config || {};
   
  config.layout = 'border';
  config.pnlChinaShippingAreaConfig = new Toc.modules_shipping.ChinaShippingAreaConfigPanel({owner: config.owner, code: config.code, parent: this});
  config.grdChinaShippingAreas = new Toc.modules_shipping.ChinaShippingAreasGrid({owner: config.owner, pnlChinaShippingAreaConfig: config.pnlChinaShippingAreaConfig, code: config.code}); 
  
  config.grdChinaShippingAreas.on('selectchange', this.onGrdShippingAreasChange, this);
  config.grdChinaShippingAreas.getStore().on('load', function() {this.onGrdShippingAreasLoad(config.code);}, this);
  
  config.items = [config.grdChinaShippingAreas, config.pnlChinaShippingAreaConfig];

  Toc.modules_shipping.ChinaShippingAreasMainPanel.superclass.constructor.call(this, config);
};

Ext.extend(Toc.modules_shipping.ChinaShippingAreasMainPanel, Ext.Panel, {
  onGrdShippingAreasLoad: function(code) {
    if (this.grdChinaShippingAreas.getStore().getCount() > 0) {
      this.grdChinaShippingAreas.getSelectionModel().selectFirstRow();
      record = this.grdChinaShippingAreas.getStore().getAt(0);
      
      this.onGrdShippingAreasChange(record, code);
    } else {
      this.pnlChinaShippingAreaConfig.reset(code);
    }
  },
  
  onGrdShippingAreasChange: function(record) {
    this.pnlChinaShippingAreaConfig.iniDetail(record);
  }
});