<?php
/*
  $Id: main.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2011 Wuxi Elootec Technology Co., Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/

  echo 'Ext.namespace("Toc.friend_link");';
  
  include('friend_link_dialog.php');
  include('friend_link_grid.php');
?>

Ext.override(TocDesktop.FriendLinkWindow, {

  createWindow : function() {
    var desktop = this.app.getDesktop();
    var win = desktop.getWindow('friend_link-win');
     
    if (!win) {
      grd = new Toc.friend_link.FriendLinkGrid({owner: this});
      
      win = desktop.createWindow({
        id: 'friend_link-win',
        title: '<?php echo $osC_Language->get('heading_title'); ?>',
        width: 800,
        height: 400,
        iconCls: 'icon-friend_link-win',
        layout: 'fit',
        items: grd
      });
    }
    
    win.show();
  },
  
  createFriendLinkDialog: function() {
    var desktop = this.app.getDesktop();
    var dlg = desktop.getWindow('friend_link_dialog-win');
    
    if (!dlg) {
      dlg = desktop.createWindow({}, Toc.friend_link.FriendLinkDialog);
      
      dlg.on('saveSuccess', function(feedback) {
        this.app.showNotification({title: TocLanguage.msgSuccessTitle, html: feedback});
      }, this);
    }
    
    return dlg;
  }
});
