<?php
/*
  $Id: friend_link_dialog.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2009 Wuxi Elootec Technology Co., Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/

?>

Toc.friend_link.FriendLinkDialog = function(config) {

  config = config || {};
  
  config.id = 'friend_link_dialog-win';
  config.title = '<?php echo $osC_Language->get('action_heading_new_friend_link'); ?>';
  config.width = 500;
  config.height = 380;
  config.modal = true;
  config.layout = 'fit';
  config.iconCls = 'icon-friend_link-win';
  config.items = this.buildForm();  
  
  config.buttons = [
    {
      text: TocLanguage.btnSave,
      handler: function() {
        this.submitForm();
      },
      scope: this
    },
    {
      text: TocLanguage.btnClose,
      handler: function() { 
        this.close();
      },
      scope: this
    }
  ];

  this.addEvents({'saveSuccess' : true});  
  
  Toc.friend_link.FriendLinkDialog.superclass.constructor.call(this, config);
}

Ext.extend(Toc.friend_link.FriendLinkDialog, Ext.Window, {
  
  show: function (id) {
    var friendLinkId = id || null;
    
    this.frmFriendLink.form.reset();
    this.frmFriendLink.baseParams['friend_link_id'] = friendLinkId;
    
    if (friendLinkId > 0) {
      this.frmFriendLink.load({
        url: Toc.CONF.CONN_URL,
        params: {
          module: 'friend_link',
          action: 'load_friend_link'
        },
        success: function(form, action) {
          var img = action.result.data.friend_link_image;
          
          if (img) {
            var html = '<img src ="../images/friendlink/' + img + '"  style = "margin-left: 110px; width: 80px; height: 80px" /><br/><span style = "padding-left: 110px;">/images/friendlink/' + img + '</span>';
            this.frmFriendLink.findById('friend_link_image_panel').body.update(html);
          }          
          
          Toc.friend_link.FriendLinkDialog.superclass.show.call(this);
        },
        failure: function() {
          Ext.Msg.alert(TocLanguage.msgErrTitle, TocLanguage.msgErrLoadData);
        },
        scope: this       
      });
    } else {   
      Toc.friend_link.FriendLinkDialog.superclass.show.call(this);
    }
  },
      
  buildForm: function() {
    this.frmFriendLink = new Ext.form.FormPanel({ 
      url: Toc.CONF.CONN_URL,
      baseParams: {  
        module: 'friend_link',
        action: 'save_friend_link'
      }, 
      defaults: {
        anchor: '98%'
      },
      style: 'padding: 8px',
      fileUpload: true,
      border: false,
      layoutConfig: {
        labelSeparator: ''
      },
      labelWidth: 120,
      items: [
        <?php
        $i = 1;
          foreach ( $osC_Language->getAll() as $l ) {
            echo "{";
              echo "xtype: 'textfield',"; 
              if($i == 1)
                echo "fieldLabel: '" . $osC_Language->get('field_friend_link_name') . "',"; 
              else
                echo 'fieldLabel: "&nbsp;",';  
              echo 'name: "friend_link_name[' . $l['id'] . ']",';
              echo "labelStyle: 'background: url(../images/worldflags/" . $l['country_iso'] . ".png) no-repeat right center !important;', "; 
              echo "allowBlank: false";
            echo "},";
            $i++;
          }
        ?>
        
        {xtype: 'textfield', fieldLabel: '<?php echo $osC_Language->get('field_friend_link_url'); ?>', name: 'friend_link_url', allowBlank: false, value: 'http://'},
        {xtype:'numberfield', fieldLabel: '<?php echo $osC_Language->get('field_friend_link_order'); ?>', name: 'friend_link_order', id: 'friend_link_order'},
        {
          layout: 'column',
          border: false,
          items: [
            { 
              width: 220,
              layout: 'form',
              labelSeparator: ' ',
              border: false,
              items:[
                {fieldLabel: '<?php echo $osC_Language->get('field_friend_link_status'); ?>', boxLabel: '<?php echo $osC_Language->get('friend_link_status_enabled'); ?>' , name: 'friend_link_status', xtype:'radio', inputValue: '1', checked: true}
              ]
            },
            { 
              layout: 'form',
              border: false,
              items:[
                { hideLabel: true, boxLabel: '<?php echo $osC_Language->get('polls_friend_link_disabled'); ?>' , name: 'friend_link_status', xtype:'radio', inputValue: '0'}
              ]
            }
          ]  
        },
        {xtype: 'panel', name: 'friend_link_image_panel', id: 'friend_link_image_panel', border: false, html: ''},
        {xtype: 'fileuploadfield', fieldLabel: '<?php echo $osC_Language->get('field_friend_link_image'); ?>', name: 'friend_link_image'}
      ]
    });
    
    return this.frmFriendLink;
  },

  submitForm : function() {
    this.frmFriendLink.form.submit({
      waitMsg: TocLanguage.formSubmitWaitMsg,
      success: function(form, action) {
         this.fireEvent('saveSuccess', action.result.feedback);
         this.close();  
      },    
      failure: function(form, action) {
        if (action.failureType != 'client') {
          Ext.MessageBox.alert(TocLanguage.msgErrTitle, action.result.feedback);
        }
      },  
      scope: this
    });   
  }
});