<?php
/*
  $Id: main.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2010 Wuxi Elootec Technology Co., Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/
  echo 'Ext.namespace("Toc.custom_navigation_bar");';
  
  include('custom_navigation_bar_grid.php');
  include('custom_navigation_bar_dialog.php');
?>

Ext.override(TocDesktop.CustomNavigationBarWindow, {

  createWindow: function(){
    var desktop = this.app.getDesktop();
    var win = desktop.getWindow('custom_navigation_bar-win');
     
    if(!win){
      grd = new Toc.custom_navigation_bar.CustomNavigationBarGrid({owner: this});
      win = desktop.createWindow({
        id: 'custom_navigation_bar-win',
        title: '<?php echo $osC_Language->get('heading_title'); ?>',
        width: 800,
        height: 400,
        iconCls: 'icon-custom_navigation_bar-win',
        layout: 'fit',
        items: grd
      });
    }
    win.show();
  },
    
  createCustomNavigationBarDialog: function() {
    var desktop = this.app.getDesktop();
    var dlg = desktop.getWindow('custom_navigation_bar-dialog-win');
    
    if(!dlg){
      dlg = desktop.createWindow({}, Toc.custom_navigation_bar.CustomNavigationBarDialog);
      
      dlg.on('saveSuccess', function (feedback) {
        this.app.showNotification({
          title: TocLanguage.msgSuccessTitle,
          html: feedback
        });
      }, this);
    }
    
    return dlg;
  }
});