<?php
/*
  $Id: custom_navigation_bar_dialog.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2010 Wuxi Elootec Technology Co., Ltd;

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/

?>
Toc.custom_navigation_bar.CustomNavigationBarDialog = function (config) {

  config = config || {};
  
	config.id = 'custom_navigation_bar-dialog-win';
	config.title = '<?php echo $osC_Language->get("action_heading_new_navigation"); ?>';
	config.layout = 'fit';
	config.width = 480;
	config.height = 360;
	config.modal = true;
	config.iconCls = 'icon-custom_navigation_bar-win';
  config.items = this.buildForm();
  
	config.buttons = [
    {
	    text: TocLanguage.btnSave,
	    handler: function () {
		    this.submitForm();
	    },
	    scope: this
    }, 
    {
	    text: TocLanguage.btnClose,
	    handler: function () {
		    this.close();
	    },
	    scope: this
    }
  ];
  
	this.addEvents({ 'saveSuccess': true });
  
	Toc.custom_navigation_bar.CustomNavigationBarDialog.superclass.constructor.call(this, config);
}
Ext.extend(Toc.custom_navigation_bar.CustomNavigationBarDialog, Ext.Window, {

	show: function (id) {
    var navId = id || null;
    
		this.frmCustomNavigationBar.form.reset();
    this.frmCustomNavigationBar.form.baseParams['nav_id'] = navId;
    
    if (navId > 0) {
  		this.frmCustomNavigationBar.load({
  			url: Toc.CONF.CONN_URL,
  			params: {
  				action: 'load_navigation',
          nav_id: navId
  			},
  			success: function (form, action) {
  				Toc.custom_navigation_bar.CustomNavigationBarDialog.superclass.show.call(this);
  			},
  			failure: function (form, action) {
  				Ext.MessageBox.alert(TocLanguage.msgErrTitle, action.result.feedback);
  			},
  			scope: this
  		});
    } else {
      Toc.custom_navigation_bar.CustomNavigationBarDialog.superclass.show.call(this);
    }
	},
	
  onSystemChange: function(combo, record, index) {
    <?php echo 'this.lang' . $osC_Language->getID(); ?>.setValue(record.get('text'));
    
	  this.txtUrl.setValue(record.get('url'));
	},
	
	buildForm: function () {
		this.frmCustomNavigationBar = new Ext.form.FormPanel({
			url: Toc.CONF.CONN_URL,
			baseParams: {
				module: 'custom_navigation_bar',
        action: 'save_navigation'				
			},
      autoScroll: true,
      defaults: {
        anchor: '95%'
      },
			layoutConfig: {
			  labelSeparator: '' 
			}
	  });
	  
	  dsSystem = new Ext.data.Store({
      url:Toc.CONF.CONN_URL,
      baseParams: {
        module: 'custom_navigation_bar',
        action: 'get_systems'
      },
      reader: new Ext.data.JsonReader({
        fields: ['id', 'text', 'url'],
        root: Toc.CONF.JSON_READER_ROOT
      }),
      autoLoad: true
    });
    
    this.cboSystem = new Toc.CategoriesComboBox({
      fieldLabel: '<?php echo $osC_Language->get('field_system'); ?>',
      xtype:'combo',
      store: dsSystem,
      name: 'system',
      hiddenName: 'system_id', 
      displayField: 'text',
      valueField: 'id',
      triggerAction: 'all',
      editable: false,
      forceSelection: true,
      listeners: {
        select: this.onSystemChange,
        scope: this
      }
    });
    
    this.frmCustomNavigationBar.add(this.cboSystem);
    
    <?php
      $i = 1; 

      foreach ( $osC_Language->getAll() as $l ) {
        echo 'this.lang' . $l['id'] . ' = new Ext.form.TextField({name: "name[' . $l['id'] . ']",';       
        if ($i != 1 ) 
          echo ' fieldLabel:"&nbsp;", ';
        else
          echo ' fieldLabel:"' . $osC_Language->get('field_name') . '", ';
        echo "labelStyle: 'background: url(../images/worldflags/" . $l['country_iso'] . ".png) no-repeat right center !important;',";
        echo 'allowBlank: false});';
        echo 'this.frmCustomNavigationBar.add(this.lang' . $l['id'] . ');';
        $i++;
      }     
    ?>
    
    this.txtUrl = new Ext.form.TextField({
      xtype:'textfield',
      name: 'url',
      fieldLabel: '<?php echo $osC_Language->get("field_url"); ?>',
      value: '',
      border: false
    });
    
    this.frmCustomNavigationBar.add(this.txtUrl);
    
    this.frmCustomNavigationBar.add({
      xtype: 'textfield',
      border: false,
      name: 'vieworder',
      fieldLabel: '<?php echo $osC_Language->get("field_vieworder"); ?>',
      value: ''
    });
    
    this.frmCustomNavigationBar.add(
      {
        layout: 'column',
        border: false,
        items:[
          {
            width: 210,
            layout: 'form',
            labelSeparator: ' ',
            border: false,
            items:[
              {fieldLabel: '<?php echo $osC_Language->get('field_ifshow'); ?>', xtype:'radio', name: 'ifshow', boxLabel: '<?php echo $osC_Language->get('option_yes'); ?>', xtype:'radio', inputValue: '1', checked: true}
            ]
          },
          {
            width: 80,
            layout: 'form',
            border: false,
            items: [
              {boxLabel: '<?php echo $osC_Language->get('option_no'); ?>', xtype:'radio', name: 'ifshow', hideLabel: true, inputValue: '0'}
            ]
          }
        ]
      }
    );
    
    this.frmCustomNavigationBar.add(
      {
        layout: 'column',
        border: false,
        items:[
          {
            width: 210,
            layout: 'form',
            labelSeparator: ' ',
            border: false,
            items:[
              {fieldLabel: '<?php echo $osC_Language->get('field_opennew'); ?>', xtype:'radio', name: 'opennew', boxLabel: '<?php echo $osC_Language->get('option_yes'); ?>', inputValue: '1'}
            ]
          },
          {
            width: 80,
            layout: 'form',
            border: false,
            items: [
              {boxLabel: '<?php echo $osC_Language->get('option_no'); ?>', xtype:'radio', name: 'opennew', hideLabel: true, inputValue: '0', checked: true}
            ]
          }
        ]
      }
    );
    
    dsPosition = new Ext.data.Store({
      url:Toc.CONF.CONN_URL,
      baseParams: {
        module: 'custom_navigation_bar',
        action: 'get_positions'
      },
      reader: new Ext.data.JsonReader({
        fields: ['id', 'text'],
        root: Toc.CONF.JSON_READER_ROOT
      }),
      autoLoad: true,
      listeners: {
        load: function() {this.cboPosition.setValue('top');},
        scope: this
      }
    });
    
    this.cboPosition = new Ext.form.ComboBox({
      fieldLabel: '<?php echo $osC_Language->get('field_position'); ?>', 
      xtype:'combo', 
      store: dsPosition, 
      name: 'position', 
      hiddenName: 'position_type', 
      displayField: 'text', 
      valueField: 'id', 
      triggerAction: 'all', 
      editable: false,
      forceSelection: true      
    });
    
    this.frmCustomNavigationBar.add(this.cboPosition);
    
    return this.frmCustomNavigationBar;
	},
  
	submitForm: function () {
		this.frmCustomNavigationBar.form.submit({
			waitMsg: TocLanguage.formSubmitWaitMsg,
			success: function (form, action) {
				this.fireEvent('saveSuccess', action.result.feedback);
				this.close();
			},
			failure: function (form, action) {
				if (action.failureType != 'client') {
					Ext.MessageBox.alert(TocLanguage.msgErrTitle, action.result.feedback);
				}
			},
			scope: this
		});
	}
});