<?php
/*
  $Id: notice.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2009 Wuxi Elootec Technology Co., Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/

  class toC_Notice_Admin {

    function getData($id) {
      global $osC_Database, $osC_Language;

      $Qnotice = $osC_Database->query('select n.*, nd.* from :table_notice n, :table_notice_description nd where n.notice_id = :notice_id and n.notice_id = nd.notice_id and nd.language_id = :language_id');
      $Qnotice->bindTable(':table_notice', TABLE_NOTICE);
      $Qnotice->bindTable(':table_notice_description', TABLE_NOTICE_DESCRIPTION);
      $Qnotice->bindInt(':notice_id', $id);
      $Qnotice->bindInt(':language_id', $osC_Language->getID());
      $Qnotice->execute();

      $data = $Qnotice->toArray();

      $Qnotice->freeResult();

      return $data;
    }

    function setStatus($id, $flag){
      global $osC_Database;
      
      $Qstatus = $osC_Database->query('update :table_notice set notice_status= :notice_status, notice_last_modified = now() where notice_id = :notice_id');
      $Qstatus->bindTable(':table_notice', TABLE_NOTICE);
      $Qstatus->bindInt(':notice_status', $flag);
      $Qstatus->bindInt(':notice_id', $id);
      $Qstatus->setLogging($_SESSION['module'], $id);
      $Qstatus->execute();
      
      return true;
    }

    function save($id = null, $data) {
      global $osC_Database, $osC_Language, $osC_Image;

      $error = false;

      $osC_Database->startTransaction();

      if ( is_numeric($id) ) {
        $Qnew = $osC_Database->query('update :table_notice set notice_status = :notice_status, notice_order = :notice_order, notice_last_modified = now() where notice_id = :notice_id');
        $Qnew->bindInt(':notice_id', $id);
      } else {
        $Qnew = $osC_Database->query('insert into :table_notice (notice_status, notice_order, notice_date_added) values (:notice_status, :notice_order, :notice_date_added)');
        $Qnew->bindRaw(':notice_date_added', 'now()');
      }

      $Qnew->bindTable(':table_notice', TABLE_NOTICE);
      $Qnew->bindValue(':notice_status', $data['notice_status']);
      $Qnew->bindValue(':notice_order', $data['notice_order']);
      $Qnew->setLogging($_SESSION['module'], $id);
      $Qnew->execute();

      if ( $osC_Database->isError() ) {
        $error = true;
      } else {
        if ( is_numeric($id) ) {
          $notice_id = $id;
        } else {
          $notice_id = $osC_Database->nextID();
        }
      }

  //notice images
      if($data['delimage'] == 1){
//        $osC_Image->deleteArticlesImage($notice_id);

        $Qdelete = $osC_Database->query('update :table_notice set notice_image = NULL where notice_id = :notice_id');
        $Qdelete->bindTable(':table_notice', TABLE_NOTICE);
        $Qdelete->bindInt(':notice_id', $id);
        $Qdelete->setLogging($_SESSION['module'], $id);
        $Qdelete->execute();

        if ( $osC_Database->isError() ) {
          $error = true;
        }
      }

      if ($error === false) {
        $notice_image = new upload('notice_image', realpath('../' . DIR_WS_IMAGES . '/notice/originals'));
        if ( $notice_image->exists() && $notice_image->parse() && $notice_image->save() ) {
          $Qnew = $osC_Database->query('update :table_notice set notice_image = :notice_image where notice_id = :notice_id');
          $Qnew->bindTable(':table_notice', TABLE_NOTICE);
          $Qnew->bindValue(':notice_image', $notice_image->filename);
          $Qnew->bindInt(':notice_id', $notice_id);
          $Qnew->setLogging($_SESSION['module'], $notice_id);
          $Qnew->execute();

          if ($osC_Database->isError()) {
            $error = true;
          }else{
            foreach ($osC_Image->getGroups() as $group) {
              if ($group['id'] != '1') {
                $osC_Image->resize($notice_image->filename, $group['id'], 'notice');
              }
            }
          }

        }
      }

      //Process Languages
      //
      if ( $error === false ) {
        foreach ($osC_Language->getAll() as $l) {
          if ( is_numeric($id) ) {
            $Qnd = $osC_Database->query('update :table_notice_description set notice_name = :notice_name, notice_url = :notice_url, notice_description = :notice_description, notice_page_title = :notice_page_title, notice_meta_keywords = :notice_meta_keywords, notice_meta_description = :notice_meta_description where notice_id = :notice_id and language_id = :language_id');
          } else {
            $Qnd = $osC_Database->query('insert into :table_notice_description (notice_id, language_id, notice_name, notice_url, notice_description, notice_page_title, notice_meta_keywords, notice_meta_description) values (:notice_id, :language_id, :notice_name, :notice_url, :notice_description, :notice_page_title, :notice_meta_keywords, :notice_meta_description)');
          }

          $Qnd->bindTable(':table_notice_description', TABLE_NOTICE_DESCRIPTION);
          $Qnd->bindInt(':notice_id', $notice_id);
          $Qnd->bindInt(':language_id', $l['id']);
          $Qnd->bindValue(':notice_name', $data['notice_name'][$l['id']]);
          $Qnd->bindValue(':notice_url', ($data['notice_url'][$l['id']] == '') ? $data['notice_name'][$l['id']] : $data['notice_url'][$l['id']]);
          $Qnd->bindValue(':notice_description', $data['notice_description'][$l['id']]);
          $Qnd->bindValue(':notice_page_title', $data['page_title'][$l['id']]);
          $Qnd->bindValue(':notice_meta_keywords', $data['meta_keywords'][$l['id']]);
          $Qnd->bindValue(':notice_meta_description', $data['meta_description'][$l['id']]);
          $Qnd->setLogging($_SESSION['module'], $notice_id);
          $Qnd->execute();

          if ( $osC_Database->isError() ) {
            $error = true;
            break;
          }
        }
      }

      if ( $error === false ) {
        $osC_Database->commitTransaction();

        osC_Cache::clear('box_notice');
        osC_Cache::clear('sefu-notice');
        return true;
      }
      $osC_Database->rollbackTransaction();

      return false;
    }


    function delete($id) {
      global $osC_Database, $osC_Image;
      $error = false;

      $osC_Database->startTransaction();
      
      $osC_Image->deleteArticlesImage($id);

      $Qnd = $osC_Database->query('delete from :table_notice_description where notice_id = :notice_id');
      $Qnd->bindTable(':table_notice_description', TABLE_NOTICE_DESCRIPTION);
      $Qnd->bindInt(':notice_id', $id);
      $Qnd->setLogging($_SESSION['module'], $id);
      $Qnd->execute();

      if ( $osC_Database->isError() ) {
        $error = true;
      }

      if ( $error === false ) {
        $Qnotice = $osC_Database->query('delete from :table_notice where notice_id = :notice_id');
        $Qnotice->bindTable(':table_notice', TABLE_NOTICE);
        $Qnotice->bindInt(':notice_id', $id);
        $Qnotice->setLogging($_SESSION['module'], $id);
        $Qnotice->execute();

        if ( $osC_Database->isError() ) {
          $error = true;
        }

        if ( $error === false ) {
          $osC_Database->commitTransaction();

          osC_Cache::clear('sefu-notice');
          return true;
        }
      }
      $osC_Database->rollbackTransaction();
      return false;
    }
  }
?>
