<?php
/*
  $Id: news.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2009 Wuxi Elootec Technology Co., Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/

  class toC_News_Admin {

    function getData($id) {
      global $osC_Database, $osC_Language;

      $Qnews = $osC_Database->query('select n.*, nd.* from :table_news n, :table_news_description nd where n.news_id = :news_id and n.news_id = nd.news_id and nd.language_id = :language_id');
      $Qnews->bindTable(':table_news', TABLE_NEWS);
      $Qnews->bindTable(':table_news_description', TABLE_NEWS_DESCRIPTION);
      $Qnews->bindInt(':news_id', $id);
      $Qnews->bindInt(':language_id', $osC_Language->getID());
      $Qnews->execute();

      $data = $Qnews->toArray();

      $Qnews->freeResult();

      return $data;
    }

    function setStatus($id, $flag){
      global $osC_Database;
      
      $Qstatus = $osC_Database->query('update :table_news set news_status= :news_status, news_last_modified = now() where news_id = :news_id');
      $Qstatus->bindTable(':table_news', TABLE_NEWS);
      $Qstatus->bindInt(':news_status', $flag);
      $Qstatus->bindInt(':news_id', $id);
      $Qstatus->setLogging($_SESSION['module'], $id);
      $Qstatus->execute();
      
      return true;
    }

    function save($id = null, $data) {
      global $osC_Database, $osC_Language, $osC_Image;

      $error = false;

      $osC_Database->startTransaction();

      if ( is_numeric($id) ) {
        $Qnew = $osC_Database->query('update :table_news set news_status = :news_status, news_order = :news_order, news_last_modified = now() where news_id = :news_id');
        $Qnew->bindInt(':news_id', $id);
      } else {
        $Qnew = $osC_Database->query('insert into :table_news (news_status, news_order, news_date_added) values (:news_status, :news_order, :news_date_added)');
        $Qnew->bindRaw(':news_date_added', 'now()');
      }

      $Qnew->bindTable(':table_news', TABLE_NEWS);
      $Qnew->bindValue(':news_status', $data['news_status']);
      $Qnew->bindValue(':news_order', $data['news_order']);
      $Qnew->setLogging($_SESSION['module'], $id);
      $Qnew->execute();

      if ( $osC_Database->isError() ) {
        $error = true;
      } else {
        if ( is_numeric($id) ) {
          $news_id = $id;
        } else {
          $news_id = $osC_Database->nextID();
        }
      }

  //news images
      if($data['delimage'] == 1){
//        $osC_Image->deleteArticlesImage($news_id);

        $Qdelete = $osC_Database->query('update :table_news set news_image = NULL where news_id = :news_id');
        $Qdelete->bindTable(':table_news', TABLE_NEWS);
        $Qdelete->bindInt(':news_id', $id);
        $Qdelete->setLogging($_SESSION['module'], $id);
        $Qdelete->execute();

        if ( $osC_Database->isError() ) {
          $error = true;
        }
      }

      if ($error === false) {
        $news_image = new upload('news_image', realpath('../' . DIR_WS_IMAGES . '/news/originals'));
        if ( $news_image->exists() && $news_image->parse() && $news_image->save() ) {
          $Qnew = $osC_Database->query('update :table_news set news_image = :news_image where news_id = :news_id');
          $Qnew->bindTable(':table_news', TABLE_NEWS);
          $Qnew->bindValue(':news_image', $news_image->filename);
          $Qnew->bindInt(':news_id', $news_id);
          $Qnew->setLogging($_SESSION['module'], $news_id);
          $Qnew->execute();

          if ($osC_Database->isError()) {
            $error = true;
          }else{
            foreach ($osC_Image->getGroups() as $group) {
              if ($group['id'] != '1') {
                $osC_Image->resize($news_image->filename, $group['id'], 'news');
              }
            }
          }

        }
      }

      //Process Languages
      //
      if ( $error === false ) {
        foreach ($osC_Language->getAll() as $l) {
          if ( is_numeric($id) ) {
            $Qnd = $osC_Database->query('update :table_news_description set news_name = :news_name, news_url = :news_url, news_description = :news_description, news_page_title = :news_page_title, news_meta_keywords = :news_meta_keywords, news_meta_description = :news_meta_description where news_id = :news_id and language_id = :language_id');
          } else {
            $Qnd = $osC_Database->query('insert into :table_news_description (news_id, language_id, news_name, news_url, news_description, news_page_title, news_meta_keywords, news_meta_description) values (:news_id, :language_id, :news_name, :news_url, :news_description, :news_page_title, :news_meta_keywords, :news_meta_description)');
          }

          $Qnd->bindTable(':table_news_description', TABLE_NEWS_DESCRIPTION);
          $Qnd->bindInt(':news_id', $news_id);
          $Qnd->bindInt(':language_id', $l['id']);
          $Qnd->bindValue(':news_name', $data['news_name'][$l['id']]);
          $Qnd->bindValue(':news_url', ($data['news_url'][$l['id']] == '') ? $data['news_name'][$l['id']] : $data['news_url'][$l['id']]);
          $Qnd->bindValue(':news_description', $data['news_description'][$l['id']]);
          $Qnd->bindValue(':news_page_title', $data['page_title'][$l['id']]);
          $Qnd->bindValue(':news_meta_keywords', $data['meta_keywords'][$l['id']]);
          $Qnd->bindValue(':news_meta_description', $data['meta_description'][$l['id']]);
          $Qnd->setLogging($_SESSION['module'], $news_id);
          $Qnd->execute();

          if ( $osC_Database->isError() ) {
            $error = true;
            break;
          }
        }
      }

      if ( $error === false ) {
        $osC_Database->commitTransaction();
        
        osC_Cache::clear('box_news');
        osC_Cache::clear('sefu-news');
        return true;
      }
      $osC_Database->rollbackTransaction();

      return false;
    }


    function delete($id) {
      global $osC_Database, $osC_Image;
      $error = false;

      $osC_Database->startTransaction();
      
      $osC_Image->deleteArticlesImage($id);

      $Qnd = $osC_Database->query('delete from :table_news_description where news_id = :news_id');
      $Qnd->bindTable(':table_news_description', TABLE_NEWS_DESCRIPTION);
      $Qnd->bindInt(':news_id', $id);
      $Qnd->setLogging($_SESSION['module'], $id);
      $Qnd->execute();

      if ( $osC_Database->isError() ) {
        $error = true;
      }

      if ( $error === false ) {
        $Qnews = $osC_Database->query('delete from :table_news where news_id = :news_id');
        $Qnews->bindTable(':table_news', TABLE_NEWS);
        $Qnews->bindInt(':news_id', $id);
        $Qnews->setLogging($_SESSION['module'], $id);
        $Qnews->execute();

        if ( $osC_Database->isError() ) {
          $error = true;
        }

        if ( $error === false ) {
          $osC_Database->commitTransaction();

          osC_Cache::clear('sefu-news');
          return true;
        }
      }
      $osC_Database->rollbackTransaction();
      return false;
    }
  }
?>
