<?php
/*
  $Id: friend_link.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2011 Wuxi Elootec Technology Co., Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/

  class toC_Friend_Link_Admin {
    function getData($id) {
      global $osC_Database, $osC_Language;

      $QfriendLink = $osC_Database->query('select * from :table_friend_link where friend_link_id = :friend_link_id');
      $QfriendLink->bindTable(':table_friend_link', TABLE_FRIEND_LINK);
      $QfriendLink->bindInt(':friend_link_id', $id);
      $QfriendLink->execute();

      $data = $QfriendLink->toArray();

      $QfriendLink->freeResult();

      return $data;
    }

    function save($id = null, $data) {
      global $osC_Database, $osC_Language;

      $error = false;

      $osC_Database->startTransaction();

      if ( is_numeric($id) ) {
        $QfriendLink = $osC_Database->query('update :table_friend_link set friend_link_url = :friend_link_url, friend_link_order = :friend_link_order, friend_link_status = :friend_link_status, friend_link_last_modified = now() where friend_link_id = :friend_link_id');
        $QfriendLink->bindInt(':friend_link_id', $id);
      } else {
        $QfriendLink = $osC_Database->query('insert into :table_friend_link (friend_link_url, friend_link_order, friend_link_status, friend_link_date_added) values (:friend_link_url, :friend_link_order, :friend_link_status, now())');
      }

      $QfriendLink->bindTable(':table_friend_link', TABLE_FRIEND_LINK);
      $QfriendLink->bindValue(':friend_link_url', $data['friend_link_url']);
      $QfriendLink->bindValue(':friend_link_order', $data['friend_link_order']);
      $QfriendLink->bindValue(':friend_link_status', $data['friend_link_status']);
      $QfriendLink->setLogging($_SESSION['module'], $id);
      $QfriendLink->execute();

      if ( !$osC_Database->isError() ) {
        if ( is_numeric($id) ) {
          $friend_link_id = $id;
        } else {
          $friend_link_id = $osC_Database->nextID();
        }

        $image = new upload('friend_link_image', realpath('../' . DIR_WS_IMAGES . 'friendlink'));

        if ( $image->exists() ) {
          if ( $image->parse() && $image->save() ) {
            $Qimage = $osC_Database->query('update :table_friend_link set friend_link_image = :friend_link_image where friend_link_id = :friend_link_id');
            $Qimage->bindTable(':table_friend_link', TABLE_FRIEND_LINK);
            $Qimage->bindValue(':friend_link_image', $image->filename);
            $Qimage->bindInt(':friend_link_id', $friend_link_id);
            $Qimage->setLogging($_SESSION['module'], $friend_link_id);
            $Qimage->execute();

            if ( $osC_Database->isError() ) {
              $error = true;
            }
          }
        }
      } else {
        $error = true;
      }

      if ( $error === false ) {
        foreach ( $osC_Language->getAll() as $l ) {
          if ( is_numeric($id) ) {
            $Qurl = $osC_Database->query('update :table_friend_link_description set friend_link_name = :friend_link_name where friend_link_id = :friend_link_id and language_id = :language_id');
          } else {
            $Qurl = $osC_Database->query('insert into :table_friend_link_description (friend_link_id, language_id, friend_link_name) values (:friend_link_id, :language_id, :friend_link_name)');
          }

          $Qurl->bindTable(':table_friend_link_description', TABLE_FRIEND_LINK_DESCRIPTION);
          $Qurl->bindInt(':friend_link_id', $friend_link_id);
          $Qurl->bindInt(':language_id', $l['id']);
          $Qurl->bindValue(':friend_link_name', $data['friend_link_name'][$l['id']]);
          $Qurl->setLogging($_SESSION['module'], $friend_link_id);
          $Qurl->execute();

          if ( $osC_Database->isError() ) {
            $error = true;
            break;
          }
        }
      }

      if ( $error === false ) {
        $osC_Database->commitTransaction();

        osC_Cache::clear('friend_link');
        return true;
      }

      $osC_Database->rollbackTransaction();

      return false;
    }

    function delete($id) {
      global $osC_Database;

      $error = false;

      $osC_Database->startTransaction();

      if ( $error === false ) {
        $Qfld = $osC_Database->query('delete from :table_friend_link_description where friend_link_id = :friend_link_id');
        $Qfld->bindTable(':table_friend_link_description', TABLE_FRIEND_LINK_DESCRIPTION);
        $Qfld->bindInt(':friend_link_id', $id);
        $Qfld->setLogging($_SESSION['module'], $id);
        $Qfld->execute();

        if ( $osC_Database->isError() ) {
          $error = true;
        }
      }
      
      if ( $error === false ) {
        $Qimage = $osC_Database->query('select friend_link_image from :table_friend_link where friend_link_id = :friend_link_id');
        $Qimage->bindTable(':table_friend_link', TABLE_FRIEND_LINK);
        $Qimage->bindInt(':friend_link_id', $id);
        $Qimage->execute();
        
        if ( $Qimage->numberOfRows() && !osc_empty($Qimage->value('friend_link_image')) ) {
          if ( file_exists(realpath('../' . DIR_WS_IMAGES . 'friendlink/' . $Qimage->value('friend_link_image'))) ) {
            @unlink(realpath('../' . DIR_WS_IMAGES . 'friendlink/' . $Qimage->value('friend_link_image')));
          }
        }
        
        $Qfl = $osC_Database->query('delete from :table_friend_link where friend_link_id = :friend_link_id');
        $Qfl->bindTable(':table_friend_link', TABLE_FRIEND_LINK);
        $Qfl->bindInt(':friend_link_id', $id);
        $Qfl->setLogging($_SESSION['module'], $id);
        $Qfl->execute();

        if ( $osC_Database->isError() ) {
          $error = true;
        }
      }
      
      if ( $error === false ) {
        $osC_Database->commitTransaction();

        return true;
      }

      $osC_Database->rollbackTransaction();

      return false;
    }
    
    function setStatus($friend_link_id, $status) {
      global $osC_Database;
      
      $Qstatus = $osC_Database->query('update :table_friend_link set friend_link_status = :friend_link_status where friend_link_id = :friend_link_id');
      $Qstatus->bindTable(':table_friend_link', TABLE_FRIEND_LINK);
      $Qstatus->bindInt(':friend_link_id', $friend_link_id);
      $Qstatus->bindInt(':friend_link_status', $status);
      $Qstatus->setLogging($_SESSION['module'], $friend_link_id);
      $Qstatus->execute();
  
      if ( !$osC_Database->isError() ) {
        return true;
      }
                  
      return false;
    }
  }
?>