<?php
/*
  $Id: custom_navigation_bar.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2010 Wuxi Elootec Technology Co., Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/

  class osC_Custom_Navigation_Bar_Admin {
    function getData($id) {
      global $osC_Database, $osC_Language;

      $Qnav = $osC_Database->query('select n.*, nd.* from :table_nav n left join :table_nav_description nd on n.nav_id = nd.nav_id where n.nav_id = :nav_id and nd.languages_id = :languages_id ');
      $Qnav->bindTable(':table_nav', TABLE_NAV);
      $Qnav->bindTable(':table_nav_description', TABLE_NAV_DESCRIPTION);
      $Qnav->bindInt(':nav_id', $id);
      $Qnav->bindInt(':languages_id', $osC_Language->getID());
      $Qnav->execute();

      $data = $Qnav->toArray();

      $Qnav->freeResult();

      return $data;
    }

    function save($id = null, $data) {
      global $osC_Database, $osC_Language;

      $error = false;

      $osC_Database->startTransaction();

      if ( is_numeric($id) ) {
        $Qnav = $osC_Database->query('update :table_nav set url = :url, ifshow = :ifshow, vieworder = :vieworder, opennew = :opennew, position_type = :position_type where nav_id = :nav_id');
        $Qnav->bindInt(':nav_id', $id);
      } else {
        $Qnav = $osC_Database->query('insert into :table_nav (url, ifshow, vieworder, opennew, position_type) values (:url, :ifshow, :vieworder, :opennew, :position_type)');
      }
      
      $Qnav->bindTable(':table_nav', TABLE_NAV);
      $Qnav->bindValue(':url', $data['url']);
      $Qnav->bindInt(':ifshow', $data['ifshow']);
      $Qnav->bindInt(':vieworder', $data['vieworder']);
      $Qnav->bindInt(':opennew', $data['opennew']);
      $Qnav->bindValue(':position_type', $data['position_type']);
      $Qnav->execute();
      
      if ( !$osC_Database->isError() ) {
        $nav_id = (is_numeric($id)) ? $id : $osC_Database->nextID();
        
        foreach ($osC_Language->getAll() as $l) {
          if ( is_numeric($id) ) {
            $Qnd = $osC_Database->query('update :table_nav_description set name = :name where nav_id = :nav_id and languages_id = :languages_id');
          } else {
            $Qnd = $osC_Database->query('insert into :table_nav_description (nav_id, languages_id, name) values (:nav_id, :languages_id, :name)');
          }

          $Qnd->bindTable(':table_nav_description', TABLE_NAV_DESCRIPTION);
          $Qnd->bindInt(':nav_id', $nav_id);
          $Qnd->bindInt(':languages_id', $l['id']);
          $Qnd->bindValue(':name', $data['name'][$l['id']]);
          $Qnd->execute();

          if ( $osC_Database->isError() ) {
            $error = true;
            break;
          }
        }
      }

      if ( $error === false ) {
        $osC_Database->commitTransaction();

        if ( $default === true ) {
          osC_Cache::clear('configuration');
        }

        return true;
      }

      $osC_Database->rollbackTransaction();

      return false;
    }

    function delete($id) {
      global $osC_Database;

      $error = false;

      $osC_Database->startTransaction();

      $Qnd = $osC_Database->query('delete from :table_nav_description where nav_id = :nav_id');
      $Qnd->bindTable(':table_nav_description', TABLE_NAV_DESCRIPTION);
      $Qnd->bindInt(':nav_id', $id);
      $Qnd->setLogging($_SESSION['module'], $id);
      $Qnd->execute();

      if ( $osC_Database->isError() ) {
        $error = true;
      }

      if ( $error === false ) {
        $Qn = $osC_Database->query('delete from :table_nav where nav_id = :nav_id');
        $Qn->bindTable(':table_nav', TABLE_NAV);
        $Qn->bindInt(':nav_id', $id);
        $Qn->setLogging($_SESSION['module'], $id);
        $Qn->execute();

        if ( $osC_Database->isError() ) {
          $error = true;
        }
      }

      if ( $error === false ) {
        $osC_Database->commitTransaction();

        return true;
      }

      $osC_Database->rollbackTransaction();

      return false;
    }
    
    function setIfshow($id, $flag) {
      global $osC_Database;
    
      $Qnav = $osC_Database->query('update :table_nav set ifshow = :ifshow where nav_id = :nav_id');
      $Qnav->bindTable(':table_nav', TABLE_NAV);
      $Qnav->bindInt(':nav_id', $id);
      $Qnav->bindValue(':ifshow', $flag);
      $Qnav->execute();
      
      if(!$osC_Database->isError()) {
        return true;
      }
      
      return false;
    }
    
    function setOpennew($id, $flag) {
      global $osC_Database;
    
      $Qnav = $osC_Database->query('update :table_nav set opennew = :opennew where nav_id = :nav_id');
      $Qnav->bindTable(':table_nav', TABLE_NAV);
      $Qnav->bindInt(':nav_id', $id);
      $Qnav->bindValue(':opennew', $flag);
      $Qnav->execute();
      
      if(!$osC_Database->isError()) {
        return true;
      }
      
      return false;
    }
  }
?>
