<?php
/*
  $Id: china_shipping.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2010 Wuxi Elootec Technology Co., Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/

  class toC_China_Shipping_Admin extends osC_Shipping_Admin {
    function remove() {
      global $osC_Database;
      
      parent::remove();
    
      $areas = $osC_Database->query('select china_shipping_area_id from :table_china_shipping_area where china_shipping_code = :china_shipping_code');
      $areas->bindTable(':table_china_shipping_area', TABLE_CHINA_SHIPPING_AREA);
      $areas->bindValue(':china_shipping_code', $this->_code);
      $areas->execute();
      
      while ($areas->next()) {
        self::deleteShippingArea($areas->valueInt('china_shipping_area_id'));
      }
    }
    
    function getShippingAreas($id) {
      global $osC_Database;
      
      $Qareas = $osC_Database->query('select china_shipping_area_name, china_shipping_code, configure from :table_china_shipping_area where china_shipping_area_id = :china_shipping_area_id');
      $Qareas->bindTable(':table_china_shipping_area', TABLE_CHINA_SHIPPING_AREA);
      $Qareas->bindInt(':china_shipping_area_id', $id);
      $Qareas->execute();
      
      $data = array();
      if ($Qareas->numberOfRows() > 0) {
        $data = array('shipping_area_name' => $Qareas->value('china_shipping_area_name'),
                      'china_shipping_code' => $Qareas->value('china_shipping_code'),
                      'configure' => unserialize($Qareas->value('configure')));
      }
      
      return $data;
    }
    
    function saveShippingArea($id, $data) {
      global $osC_Database;
      
      $error = false;
      
      if (is_numeric($id)) {
        $Qarea = $osC_Database->query('update :table_china_shipping_area set china_shipping_area_name = :china_shipping_area_name, configure = :configure where china_shipping_area_id = :china_shipping_area_id');
        $Qarea->bindInt(':china_shipping_area_id', $id);
      } else {
        $Qarea = $osC_Database->query('insert into :table_china_shipping_area (china_shipping_area_name, china_shipping_code, configure) values(:china_shipping_area_name, :china_shipping_code, :configure)');
        $Qarea->bindValue(':china_shipping_code', $data['shipping_code']);
      }
      
      $Qarea->bindTable(':table_china_shipping_area', TABLE_CHINA_SHIPPING_AREA);
      $Qarea->bindValue(':china_shipping_area_name', $data['shipping_area_name']);
      $Qarea->bindValue(':configure', serialize($data['configure']));
      $Qarea->execute();
      
      if ($osC_Database->isError()) {
        $error = true;
      } else {
        if (is_numeric($id)) {
          $china_shipping_area_id = $id;
        } else {
          $china_shipping_area_id = $osC_Database->nextID();
        }
        
        $Qdelete = $osC_Database->query('delete from :table_china_area_to_region where china_shipping_area_id = :china_shipping_area_id');
        $Qdelete->bindTable(':table_china_area_to_region', TABLE_CHINA_AREA_TO_REGION);
        $Qdelete->bindInt(':china_shipping_area_id', $id);
        $Qdelete->execute();
      
        if ($osC_Database->isError()) {
          $error = true;
        } else {
          if ( isset($data['region_ids']) && !empty($data['region_ids']) ) {
            foreach($data['region_ids'] as $region_ids) {
              $Qregions = $osC_Database->query('insert into :table_china_area_to_region (china_shipping_area_id, china_region_id, region_type) values(:china_shipping_area_id, :china_region_id, :region_type)');
              $Qregions->bindTable(':table_china_area_to_region', TABLE_CHINA_AREA_TO_REGION);
              $Qregions->bindInt(':china_shipping_area_id', $china_shipping_area_id);
              $Qregions->bindInt(':china_region_id', $region_ids['id']);
              $Qregions->bindInt(':region_type', $region_ids['type']);
              $Qregions->execute();
              
              if ( $osC_Database->isError() ) {
                $error = true;
                break;
              }
            }
          }        
        }
      }
      
      if ($error === false) {
        $osC_Database->commitTransaction();

        return true;
      }

      $osC_Database->rollbackTransaction();

      return false;
    }
    
    function deleteShippingArea($id) {
      global $osC_Database;
      
      $Qdelete = $osC_Database->query('delete from :table_china_shipping_area_to_region where china_shipping_area_id = :china_shipping_area_id');
      $Qdelete->bindTable(':table_china_shipping_area_to_region', TABLE_CHINA_AREA_TO_REGION);
      $Qdelete->bindInt(':china_shipping_area_id', $id);
      $Qdelete->execute();
      
      if ( !$osC_Database->isError() ) {
        $Qdelete = $osC_Database->query('delete from :table_china_shipping_area where china_shipping_area_id = :china_shipping_area_id');
        $Qdelete->bindTable(':table_china_shipping_area', TABLE_CHINA_SHIPPING_AREA);
        $Qdelete->bindInt(':china_shipping_area_id', $id);
        $Qdelete->execute();
      }
      
      if ( $osC_Database->isError() ) {
        return false;
      }
      
      return true;
    }
  }
?>
