/*
 * Decompiled with CFR 0.152.
 */
package apkdownloader.model;

import apkdownloader.APKDownloaderApp;
import apkdownloader.dao.ScanFolderDAO;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public class ScanFolderModel
extends AbstractTableModel {
    private String[] columnNames = new String[]{"Filename", "File Size", "Package", "Name", "Price", "Local Version", "Latest Version", " "};
    private ArrayList data = ScanFolderDAO.scanFolder();

    public int getRowCount() {
        return this.data.size();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.data.isEmpty() ? "Null" : ((ArrayList)this.data.get(rowIndex)).get(columnIndex);
    }

    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Class getColumnClass(int c) {
        if (this.getValueAt(0, c) == null) {
            return String.class;
        }
        return this.getValueAt(0, c).getClass();
    }

    public boolean isCellEditable(int row, int col) {
        return col == 0;
    }

    public void setValueAt(Object value, int row, int col) {
        File newFile;
        if (!value.toString().toLowerCase().endsWith(".apk")) {
            JOptionPane.showMessageDialog(null, "Filename must have .apk extension", "Error Message", 0);
            return;
        }
        String prefix = APKDownloaderApp.so.folder + "\\";
        String old = this.getValueAt(row, col).toString();
        if (old.equals(value.toString())) {
            return;
        }
        File oldFile = new File(prefix + old);
        if (!oldFile.renameTo(newFile = new File(prefix + value.toString()))) {
            JOptionPane.showMessageDialog(null, "Rename " + old + " failed due to wrong filename format or filename was exist", "Error Message", 0);
            return;
        }
        ((ArrayList)this.data.get(row)).set(col, value);
        this.fireTableCellUpdated(row, col);
    }

    public void removeRow(int row) {
        this.data.remove(row);
        this.fireTableDataChanged();
    }
}

