/*
 * Decompiled with CFR 0.152.
 */
package apkdownloader.dao;

import apkdownloader.APKDownloaderApp;
import apkdownloader.ScanOption;
import apkdownloader.entities.Config;
import com.gc.android.market.api.MarketSession;
import com.gc.android.market.api.model.Market;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class ScanFolderDAO {
    private static DecimalFormat df = new DecimalFormat("#,###,###,##0.00");

    public static ArrayList scanFolder() {
        final ArrayList list = new ArrayList();
        Runtime rt = Runtime.getRuntime();
        MarketSession session = new MarketSession(Boolean.valueOf(false));
        Config cf = APKDownloaderApp.config;
        ScanOption so = APKDownloaderApp.so;
        session.login(cf.getEmail(), cf.getPassword(), cf.getDeviceId());
        try {
            File folder = new File("".equals(so.folder) ? File.separator : so.folder);
            File[] listOfFiles = folder.listFiles();
            for (int i = 0; i < listOfFiles.length; ++i) {
                String temp;
                String line = "";
                if (!listOfFiles[i].isFile()) continue;
                String files = listOfFiles[i].getAbsolutePath();
                final String filename = listOfFiles[i].getName();
                final double filesize = (double)listOfFiles[i].length() / 1048576.0;
                if (!files.toLowerCase().endsWith(".apk")) continue;
                Process p = rt.exec("lib" + File.separator + "aapt d badging \"" + files + "\"", null, new File("lib"));
                InputStream is = p.getInputStream();
                InputStreamReader isr = new InputStreamReader(is);
                BufferedReader br = new BufferedReader(isr);
                while ((temp = br.readLine()) != null) {
                    line = line + temp;
                }
                br.close();
                isr.close();
                is.close();
                final String packageName = line.replaceAll("^package: name='|'.*$", "");
                if ("".equals(packageName)) {
                    ArrayList<String> tempAl = new ArrayList<String>();
                    tempAl.add(filename);
                    tempAl.add(df.format(filesize) + " MB");
                    tempAl.add(" ");
                    tempAl.add(" ");
                    tempAl.add(" ");
                    tempAl.add(" ");
                    tempAl.add(" ");
                    tempAl.add("unknown");
                    list.add(tempAl);
                    continue;
                }
                final String localVersion = line.replaceAll("^.*versionName='|'.*$", "");
                final String localName = line.replaceAll("^.*application-label:'|'.*$", "");
                Market.AppsRequest appsRequest = Market.AppsRequest.newBuilder().setQuery("pname:" + packageName).setStartIndex(0L).setEntriesCount(1).setWithExtendedInfo(false).build();
                MarketSession.Callback<Market.AppsResponse> callback = new MarketSession.Callback<Market.AppsResponse>(){

                    public void onResult(Market.ResponseContext context, Market.AppsResponse response) {
                        if (response.getAppCount() != 0) {
                            Market.App app = response.getApp(0);
                            ArrayList<String> tempAl = new ArrayList<String>();
                            tempAl.add(filename);
                            tempAl.add(df.format(filesize) + " MB");
                            tempAl.add(packageName);
                            tempAl.add(localName);
                            tempAl.add(app.getPrice().equals("") || app.getPrice() == null ? "Free" : app.getPrice());
                            tempAl.add(localVersion);
                            tempAl.add(app.getVersion());
                            String stat = app.getVersion().equals(localVersion) ? "good" : "bad";
                            tempAl.add(app.getId() + "#" + stat);
                            list.add(tempAl);
                        } else {
                            ArrayList<String> tempAl = new ArrayList<String>();
                            tempAl.add(filename);
                            tempAl.add(df.format(filesize) + " MB");
                            tempAl.add(packageName);
                            tempAl.add(localName);
                            tempAl.add(" ");
                            tempAl.add(localVersion);
                            tempAl.add(" ");
                            tempAl.add("unknown");
                            list.add(tempAl);
                        }
                    }
                };
                session.append(appsRequest, (MarketSession.Callback)callback);
                if (i % 19 != 0 || i == 0) continue;
                session.flush();
            }
            session.flush();
            if (list.isEmpty()) {
                JOptionPane.showMessageDialog(null, "No such .apk file in your folder!", "Error Message", 0);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error occured while scanning your folder", "Error Message", 0);
        }
        return list;
    }

    public static boolean deleteFile(String name) {
        String prefix = APKDownloaderApp.so.folder + File.separator;
        File file = new File(prefix + name);
        return file.delete();
    }
}

