/*
 * Decompiled with CFR 0.152.
 */
package apkdownloader.dao;

import java.util.regex.Pattern;
import javax.swing.RowFilter;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.swingx.JXTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyTableFilter
extends AbstractBean {
    private RowFilter<Object, Object> searchFilter;
    private String filterString;
    private JXTable table;

    public MyTableFilter(JXTable table) {
        this.table = table;
    }

    public boolean isFilteringByString() {
        return !this.isEmpty(this.getFilterString());
    }

    private boolean isEmpty(String filterString) {
        return filterString == null || filterString.length() == 0;
    }

    public void setFilterString(String filterString) {
        String oldValue = this.getFilterString();
        this.filterString = filterString;
        this.updateSearchFilter();
        this.firePropertyChange("filterString", oldValue, this.getFilterString());
    }

    public String getFilterString() {
        return this.filterString;
    }

    private void updateSearchFilter() {
        this.searchFilter = this.filterString != null && this.filterString.length() > 0 ? this.createSearchFilter(this.filterString + ".*") : null;
        this.updateFilters();
    }

    private void updateFilters() {
        this.table.setRowFilter(this.searchFilter);
    }

    private RowFilter<Object, Object> createSearchFilter(final String filterString) {
        return new RowFilter<Object, Object>(){

            @Override
            public boolean include(RowFilter.Entry<? extends Object, ? extends Object> entry) {
                Pattern p = Pattern.compile(".*" + filterString + ".*", 2);
                String value1 = "";
                value1 = MyTableFilter.this.table.getModel().getColumnCount() == 7 ? entry.getValue(1).toString() : entry.getValue(0).toString();
                String value2 = entry.getValue(3).toString();
                boolean matches1 = false;
                boolean matches2 = false;
                matches1 = p.matcher(value1).matches();
                matches2 = p.matcher(value2).matches();
                return matches1 || matches2;
            }
        };
    }
}

