/*
 * Decompiled with CFR 0.152.
 */
package apkdownloader.dao;

import apkdownloader.APKDownloaderApp;
import apkdownloader.APKDownloaderView;
import apkdownloader.DownloadBox;
import apkdownloader.dao.ConvertURL;
import apkdownloader.entities.Config;
import com.gc.android.market.api.LoginException;
import com.gc.android.market.api.MarketSession;
import com.gc.android.market.api.model.Market;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;

public class ListAppsDAO {
    public static List<Market.App> responseApps = new ArrayList<Market.App>();
    private int percent = 0;
    private static DecimalFormat df = new DecimalFormat("#,###,###,##0.00");

    private static void loadApps() {
        String strSearch = APKDownloaderView.searchString;
        if (!strSearch.isEmpty()) {
            MarketSession session = new MarketSession(Boolean.valueOf(false));
            APKDownloaderView.load.firePropertyChange("message", "", "Trying logging in..");
            Config cf = APKDownloaderApp.config;
            session.login(cf.getEmail(), cf.getPassword(), cf.getDeviceId());
            APKDownloaderView.load.firePropertyChange("message", "", "Logged in successfully!");
            session.getContext().setUserLanguage(cf.getLocale().getLanguageCode());
            session.getContext().setUserCountry(cf.getLocale().getCountryCode());
            String sim = cf.getSimNumberic();
            if (sim != null) {
                session.getContext().setOperatorNumeric(sim);
                session.getContext().setSimOperatorNumeric(sim);
            }
            responseApps.clear();
            for (int i = 0; i < cf.getRecordShow(); i += 10) {
                Market.AppsRequest appsRequest = Market.AppsRequest.newBuilder().setQuery(strSearch).setStartIndex((long)i).setEntriesCount(10).setWithExtendedInfo(true).build();
                MarketSession.Callback<Market.AppsResponse> callback = new MarketSession.Callback<Market.AppsResponse>(){

                    public void onResult(Market.ResponseContext context, Market.AppsResponse response) {
                        List list = response.getAppList();
                        for (Market.App app : list) {
                            responseApps.add(app);
                        }
                        APKDownloaderView.load.firePropertyChange("message", "", "Getting apps list...");
                        if (responseApps.isEmpty()) {
                            JOptionPane.showMessageDialog(null, "Cannot find any apps with given search string!", "No match found", 0);
                            return;
                        }
                    }
                };
                session.append(appsRequest, (MarketSession.Callback)callback);
            }
            session.flush();
        }
    }

    public static ArrayList loadFullApps() {
        ListAppsDAO.loadApps();
        final ArrayList list = new ArrayList();
        if (responseApps != null && !responseApps.isEmpty()) {
            MarketSession session = new MarketSession(Boolean.valueOf(false));
            Config cf = APKDownloaderApp.config;
            session.login(cf.getEmail(), cf.getPassword(), cf.getDeviceId());
            int i = 0;
            for (final Market.App app : responseApps) {
                Market.GetImageRequest imgReq = Market.GetImageRequest.newBuilder().setAppId(app.getId()).setImageUsage(Market.GetImageRequest.AppImageUsage.ICON).setImageId("1").build();
                MarketSession.Callback<Market.GetImageResponse> callback = new MarketSession.Callback<Market.GetImageResponse>(){

                    public void onResult(Market.ResponseContext context, Market.GetImageResponse response) {
                        Image img = Toolkit.getDefaultToolkit().createImage(response.getImageData().toByteArray());
                        ArrayList<Object> temp = new ArrayList<Object>();
                        temp.add(img);
                        temp.add(app.getTitle());
                        temp.add(app.getPackageName());
                        temp.add(app.getCreator());
                        temp.add(app.getVersion());
                        double dd = (double)app.getExtendedInfo().getInstallSize() / 1048576.0;
                        temp.add(df.format(dd) + " MB");
                        temp.add(app.getPrice().equals("") || app.getPrice() == null ? "Free" : app.getPrice());
                        list.add(temp);
                    }
                };
                session.append(imgReq, (MarketSession.Callback)callback);
                if (++i != 19) continue;
                session.flush();
            }
            session.flush();
        }
        return list;
    }

    public static void downloadIcon(String assetId, String title) {
        try {
            MarketSession session = new MarketSession(Boolean.valueOf(false));
            Config cf = APKDownloaderApp.config;
            session.login(cf.getEmail(), cf.getPassword(), cf.getDeviceId());
            Market.GetImageRequest imgReq = Market.GetImageRequest.newBuilder().setAppId(assetId).setImageUsage(Market.GetImageRequest.AppImageUsage.ICON).setImageId("1").build();
            final String fileToSave = cf.getFolderToSave() + (cf.getFolderToSave().equals("") ? "" : File.separator) + ConvertURL.toUrlFriendly(title).replaceAll(":", " -").replaceAll("/", " - ") + "_icon.png";
            session.append(imgReq, (MarketSession.Callback)new MarketSession.Callback<Market.GetImageResponse>(){

                public void onResult(Market.ResponseContext context, Market.GetImageResponse response) {
                    try {
                        FileOutputStream fos = new FileOutputStream(fileToSave);
                        fos.write(response.getImageData().toByteArray());
                        fos.close();
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(null, "Download icon failed!", "Error Message", 0);
                    }
                }
            });
            session.flush();
        }
        catch (LoginException le) {
            JOptionPane.showMessageDialog(null, "Login failed! Please check your email or password in Option.", "Error Message", 0);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Download failed due to bad device ID or internet connection.", "Error Message", 0);
        }
    }

    public void appDownload(String assetId, String title, int index) {
        try {
            MarketSession session = new MarketSession(Boolean.valueOf(true));
            Config cf = APKDownloaderApp.config;
            session.login(cf.getEmail(), cf.getPassword(), cf.getDeviceId());
            Market.GetAssetResponse.InstallAsset ia = session.queryGetAssetRequest(assetId).getInstallAsset(0);
            String cookieName = ia.getDownloadAuthCookieName();
            String cookieValue = ia.getDownloadAuthCookieValue();
            URL url = new URL(ia.getBlobUrl());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("User-Agent", "Android-Market/2 (sapphire PLAT-RC33); gzip");
            conn.setRequestProperty("Cookie", cookieName + "=" + cookieValue);
            if (conn.getResponseCode() == 302) {
                String location = conn.getHeaderField("Location");
                url = new URL(location);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setRequestProperty("User-Agent", "Android-Market/2 (sapphire PLAT-RC33); gzip");
                conn.setRequestProperty("Cookie", cookieName + "=" + cookieValue);
            }
            int appLength = conn.getContentLength();
            InputStream inputstream = conn.getInputStream();
            String fileToSave = cf.getFolderToSave() + (cf.getFolderToSave().equals("") ? "" : File.separator) + title;
            BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(fileToSave));
            byte[] buf = new byte[1024];
            int k = 0;
            int readed = 0;
            while ((k = inputstream.read(buf)) > 0) {
                stream.write(buf, 0, k);
                this.percent = (readed += k) * 100 / appLength;
                buf = appLength - readed > 1024 ? new byte[1024] : new byte[appLength - readed];
                DownloadBox.downloads.get(index).firePropertyChange("progress", 0, this.percent);
                if (!DownloadBox.downloads.get(index).isCancelled()) continue;
            }
            inputstream.close();
            inputstream = null;
            stream.flush();
            stream.close();
            stream = null;
            System.gc();
            if (DownloadBox.downloads.get(index).isCancelled()) {
                File f = new File(fileToSave);
                f.delete();
            }
        }
        catch (LoginException le) {
            JOptionPane.showMessageDialog(null, "Login failed! Please check your email or password in Option.", "Error Message", 0);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "<html>Download failed due to: <br/>1. Bad device ID <br/>2. Internet connection <br/>3. You didn't purchase this app</html>", "Error Message", 0);
        }
    }
}

