/*
 * Decompiled with CFR 0.152.
 */
package apkdownloader;

import apkdownloader.APKDownloaderApp;
import apkdownloader.entities.Config;
import apkdownloader.entities.CustomLocale;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.JXComboBox;
import org.jdesktop.swingx.JXEditorPane;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXTextField;

public class Option
extends JDialog {
    ArrayList<CustomLocale> localeList;
    private JXButton btnBrowse;
    private JXButton btnCancel;
    private JXButton btnSave;
    private JXButton btnScanBrowse;
    private ButtonGroup buttonGroup1;
    private JXComboBox cboLocale;
    private JXComboBox cboRecord;
    private JRadioButton format1;
    private JRadioButton format2;
    private JRadioButton format3;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JXLabel jXLabel1;
    private JXEditorPane jepAttention;
    private JTextField txtDeviceId;
    private JXTextField txtEmail;
    private JXTextField txtFolder;
    private JPasswordField txtPass;
    private JXTextField txtScanFolder;
    private JXTextField txtSim;

    public Option(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        Image icon = this.getToolkit().getImage(this.getClass().getResource("/images/gear_32.png"));
        this.setIconImage(icon);
        this.loadLocale();
        this.getInfo();
        this.getRootPane().setDefaultButton((JButton)this.btnSave);
    }

    private void getInfo() {
        Config config = APKDownloaderApp.config;
        if (config != null) {
            CustomLocale locale;
            this.txtEmail.setText(config.getEmail());
            this.txtPass.setText(config.getPassword());
            this.txtDeviceId.setText(config.getDeviceId());
            this.txtFolder.setText(config.getFolderToSave());
            this.cboRecord.setSelectedIndex(config.getRecordShow() / 10 - 1);
            this.txtScanFolder.setText(config.getDefaultScanFolder());
            int formatFileType = config.getFormatFileType();
            if (formatFileType == 1) {
                this.format1.setSelected(true);
            }
            if (formatFileType == 2) {
                this.format2.setSelected(true);
            }
            if (formatFileType == 3) {
                this.format3.setSelected(true);
            }
            if ((locale = config.getLocale()) != null) {
                int index = -1;
                for (CustomLocale customLocale : this.localeList) {
                    ++index;
                    if (!locale.getDisplayName().equals(customLocale.getDisplayName())) continue;
                    this.cboLocale.setSelectedIndex(index);
                    break;
                }
            } else {
                this.cboLocale.setSelectedIndex(40);
            }
            String sim = config.getSimNumberic();
            if (sim != null) {
                this.txtSim.setText(sim);
            }
        }
    }

    private void loadLocale() {
        Locale[] arr = Locale.getAvailableLocales();
        this.localeList = new ArrayList();
        for (Locale locale : arr) {
            if (locale.getCountry().equals("")) continue;
            CustomLocale l = new CustomLocale(locale.getDisplayName(), locale.getCountry(), locale.getLanguage());
            this.localeList.add(l);
        }
        Collections.sort(this.localeList, new Compa());
        for (CustomLocale customLocale : this.localeList) {
            this.cboLocale.addItem((Object)customLocale);
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jPanel2 = new JPanel();
        this.txtEmail = new JXTextField();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.txtPass = new JPasswordField();
        this.txtDeviceId = new JTextField();
        this.jLabel4 = new JLabel();
        this.txtFolder = new JXTextField();
        this.btnBrowse = new JXButton();
        this.jPanel3 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jepAttention = new JXEditorPane();
        this.jXLabel1 = new JXLabel();
        this.cboRecord = new JXComboBox();
        this.btnSave = new JXButton();
        this.btnCancel = new JXButton();
        this.txtScanFolder = new JXTextField();
        this.jLabel6 = new JLabel();
        this.btnScanBrowse = new JXButton();
        this.jLabel7 = new JLabel();
        this.format1 = new JRadioButton();
        this.format2 = new JRadioButton();
        this.jLabel8 = new JLabel();
        this.cboLocale = new JXComboBox();
        this.jLabel9 = new JLabel();
        this.txtSim = new JXTextField();
        this.format3 = new JRadioButton();
        this.jLabel10 = new JLabel();
        ResourceMap resourceMap = Application.getInstance(APKDownloaderApp.class).getContext().getResourceMap(Option.class);
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.setDefaultCloseOperation(2);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.setResizable(false);
        this.jPanel1.setBackground(resourceMap.getColor("jPanel1.background"));
        this.jPanel1.setName("jPanel1");
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        this.jPanel2.setBackground(resourceMap.getColor("jPanel2.background"));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel2.border.title", new Object[0])));
        this.jPanel2.setName("jPanel2");
        this.txtEmail.setText(resourceMap.getString("txtEmail.text", new Object[0]));
        this.txtEmail.setName("txtEmail");
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.txtPass.setText(resourceMap.getString("txtPass.text", new Object[0]));
        this.txtPass.setName("txtPass");
        this.txtDeviceId.setText(resourceMap.getString("txtDeviceId.text", new Object[0]));
        this.txtDeviceId.setName("txtDeviceId");
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.txtDeviceId)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.txtEmail, -1, 209, Short.MAX_VALUE).addComponent(this.txtPass, -1, 194, Short.MAX_VALUE)))).addContainerGap(40, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.txtEmail, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.txtPass, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.txtDeviceId, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.txtFolder.setText(resourceMap.getString("txtFolder.text", new Object[0]));
        this.txtFolder.setName("txtFolder");
        this.btnBrowse.setText(resourceMap.getString("btnBrowse.text", new Object[0]));
        this.btnBrowse.setMargin(new Insets(2, 7, 2, 7));
        this.btnBrowse.setName("btnBrowse");
        this.btnBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Option.this.btnBrowseActionPerformed(evt);
            }
        });
        this.jPanel3.setBackground(resourceMap.getColor("jPanel3.background"));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, resourceMap.getString("jPanel3.border.title", new Object[0]), 0, 0, new Font("Tahoma", 0, 11), resourceMap.getColor("jPanel3.border.titleColor")));
        this.jPanel3.setName("jPanel3");
        this.jScrollPane1.setName("jScrollPane1");
        this.jepAttention.setContentType(resourceMap.getString("jepAttention.contentType", new Object[0]));
        this.jepAttention.setEditable(false);
        this.jepAttention.setText(resourceMap.getString("jepAttention.text", new Object[0]));
        this.jepAttention.setName("jepAttention");
        this.jepAttention.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                Option.this.jepAttentionHyperlinkUpdate(evt);
            }
        });
        this.jScrollPane1.setViewportView((Component)this.jepAttention);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 380, Short.MAX_VALUE).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 138, Short.MAX_VALUE).addContainerGap()));
        this.jXLabel1.setText(resourceMap.getString("jXLabel1.text", new Object[0]));
        this.jXLabel1.setName("jXLabel1");
        this.cboRecord.setModel(new DefaultComboBoxModel<String>(new String[]{"10", "20", "30"}));
        this.cboRecord.setName("cboRecord");
        this.btnSave.setText(resourceMap.getString("btnSave.text", new Object[0]));
        this.btnSave.setName("btnSave");
        this.btnSave.setPreferredSize(new Dimension(65, 23));
        this.btnSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Option.this.btnSaveActionPerformed(evt);
            }
        });
        this.btnCancel.setText(resourceMap.getString("btnCancel.text", new Object[0]));
        this.btnCancel.setName("btnCancel");
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Option.this.btnCancelActionPerformed(evt);
            }
        });
        this.txtScanFolder.setName("txtScanFolder");
        this.jLabel6.setText(resourceMap.getString("jLabel6.text", new Object[0]));
        this.jLabel6.setName("jLabel6");
        this.btnScanBrowse.setText(resourceMap.getString("btnScanBrowse.text", new Object[0]));
        this.btnScanBrowse.setMargin(new Insets(2, 7, 2, 7));
        this.btnScanBrowse.setName("btnScanBrowse");
        this.btnScanBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Option.this.btnScanBrowseActionPerformed(evt);
            }
        });
        this.jLabel7.setText(resourceMap.getString("jLabel7.text", new Object[0]));
        this.jLabel7.setName("jLabel7");
        this.format1.setBackground(resourceMap.getColor("jPanel3.background"));
        this.buttonGroup1.add(this.format1);
        this.format1.setText(resourceMap.getString("format1.text", new Object[0]));
        this.format1.setName("format1");
        this.format2.setBackground(resourceMap.getColor("jPanel3.background"));
        this.buttonGroup1.add(this.format2);
        this.format2.setText(resourceMap.getString("format2.text", new Object[0]));
        this.format2.setName("format2");
        this.jLabel8.setText(resourceMap.getString("jLabel8.text", new Object[0]));
        this.jLabel8.setName("jLabel8");
        this.cboLocale.setName("cboLocale");
        this.jLabel9.setText(resourceMap.getString("jLabel9.text", new Object[0]));
        this.jLabel9.setName("jLabel9");
        this.txtSim.setText(resourceMap.getString("txtSim.text", new Object[0]));
        this.txtSim.setName("txtSim");
        this.format3.setBackground(resourceMap.getColor("format3.background"));
        this.buttonGroup1.add(this.format3);
        this.format3.setSelected(true);
        this.format3.setText(resourceMap.getString("format3.text", new Object[0]));
        this.format3.setName("format3");
        this.jLabel10.setFont(resourceMap.getFont("jLabel10.font"));
        this.jLabel10.setForeground(resourceMap.getColor("jLabel10.foreground"));
        this.jLabel10.setText(resourceMap.getString("jLabel10.text", new Object[0]));
        this.jLabel10.setName("jLabel10");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel6).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.format1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.format2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.format3)).addComponent(this.jLabel7).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent((Component)this.txtScanFolder, -2, 208, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.btnScanBrowse, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent((Component)this.txtFolder, -2, 208, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.btnBrowse, -2, 73, -2))).addComponent(this.jPanel2, -2, -1, -2).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addGroup(jPanel1Layout.createSequentialGroup().addComponent((Component)this.jXLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.cboRecord, -2, -1, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent((Component)this.txtSim, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10)).addComponent((Component)this.cboLocale, -2, 144, -2))).addComponent(this.jLabel9)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 114, Short.MAX_VALUE))).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent((Component)this.btnSave, -2, -1, -2).addGap(26, 26, 26).addComponent((Component)this.btnCancel, -2, -1, -2).addGap(150, 150, 150)))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.jXLabel1, -2, -1, -2).addComponent((Component)this.cboRecord, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent((Component)this.cboLocale, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent((Component)this.txtSim, -2, -1, -2).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.txtFolder, -2, -1, -2).addComponent((Component)this.btnBrowse, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.txtScanFolder, -2, -1, -2).addComponent((Component)this.btnScanBrowse, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.format1).addComponent(this.format2).addComponent(this.format3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.btnSave, -2, -1, -2).addComponent((Component)this.btnCancel, -2, -1, -2)).addGap(20, 20, 20)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jepAttentionHyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                Desktop.getDesktop().browse(evt.getURL().toURI());
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(Option.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException io) {
                Logger.getLogger(Option.class.getName()).log(Level.SEVERE, null, io);
            }
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void btnSaveActionPerformed(ActionEvent evt) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(Config.configFile));
            Config config = new Config();
            config.setEmail(this.txtEmail.getText().trim());
            config.setPassword(new String(this.txtPass.getPassword()));
            config.setDeviceId(this.txtDeviceId.getText().trim());
            config.setFolderToSave(this.txtFolder.getText());
            config.setDefaultScanFolder(this.txtScanFolder.getText());
            config.setRecordShow(new Integer(this.cboRecord.getSelectedItem().toString()));
            if (this.format1.isSelected()) {
                config.setFormatFileType(1);
            }
            if (this.format2.isSelected()) {
                config.setFormatFileType(2);
            }
            if (this.format3.isSelected()) {
                config.setFormatFileType(3);
            }
            CustomLocale locale = (CustomLocale)this.cboLocale.getSelectedItem();
            config.setLocale(locale);
            String sim = this.txtSim.getText().trim();
            if (sim.matches("\\d+")) {
                config.setSimNumberic(sim);
            }
            oos.writeObject(config);
            APKDownloaderApp.config = config;
            oos.close();
            this.dispose();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error while writing config file.", "Error Message", 0);
            System.exit(0);
        }
    }

    private void btnBrowseActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        if (0 == chooser.showOpenDialog(this)) {
            File file = chooser.getSelectedFile();
            this.txtFolder.setText(file.getAbsolutePath());
        }
    }

    private void btnScanBrowseActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        if (0 == chooser.showOpenDialog(this)) {
            File file = chooser.getSelectedFile();
            this.txtScanFolder.setText(file.getAbsolutePath());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Compa
    implements Comparator<CustomLocale> {
        @Override
        public int compare(CustomLocale o1, CustomLocale o2) {
            return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
        }
    }
}

