/*
 * Decompiled with CFR 0.152.
 */
package apkdownloader;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.text.NumberFormat;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.jdesktop.swingx.JXLabel;

public class MyTableRenderer {

    public static class ColorRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setForeground(Color.BLUE);
            super.getTableCellRendererComponent(table, " " + value.toString(), isSelected, hasFocus, row, column);
            return this;
        }
    }

    public static class RewardRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JPanel pn = new JPanel(new BorderLayout());
            JXLabel lb = new JXLabel();
            pn.add((Component)lb, "Center");
            lb.setHorizontalAlignment(0);
            lb.setText(value.toString());
            lb.setForeground(new Color(0, 0, 102));
            if (value.toString().equals("Highest Earn")) {
                pn.setBackground(new Color(204, 0, 0));
            } else {
                pn.setBackground(new Color(102, 204, 0));
            }
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return pn;
        }
    }

    public static class StatusRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Image img = null;
            String stat = value.toString().replaceAll("^.*#", "");
            img = stat.equals("good") ? this.getToolkit().getImage(this.getClass().getResource("/images/ok.png")) : (stat.equals("bad") ? this.getToolkit().getImage(this.getClass().getResource("/images/not-ok.png")) : this.getToolkit().getImage(this.getClass().getResource("/images/unknown.png")));
            JXLabel lb = new JXLabel();
            lb.setSize(30, 24);
            lb.setHorizontalAlignment(0);
            lb.setIcon((Icon)new ImageIcon(img));
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return lb;
        }
    }

    public static class PriceRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value.toString().equals("Free")) {
                Image img = this.getToolkit().getImage(this.getClass().getResource("/images/free.png"));
                JXLabel lb = new JXLabel();
                lb.setSize(60, 48);
                lb.setHorizontalAlignment(0);
                lb.setIcon((Icon)new ImageIcon(img));
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                return lb;
            }
            Image img = this.getToolkit().getImage(this.getClass().getResource("/images/currency_dollar_blue.png"));
            JXLabel lb = new JXLabel(value.toString());
            lb.setSize(60, 48);
            lb.setForeground(new Color(221, 5, 5));
            lb.setFont(new Font("Tahoma", 1, 11));
            lb.setHorizontalAlignment(0);
            lb.setHorizontalTextPosition(0);
            lb.setIcon((Icon)new ImageIcon(img));
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return lb;
        }
    }

    public static class IconRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Image img = (Image)value;
            JXLabel lb = new JXLabel();
            lb.setSize(48, 48);
            lb.setIcon((Icon)new ImageIcon(img));
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return lb;
        }
    }

    public static class ColRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, " " + value.toString(), isSelected, hasFocus, row, column);
            return this;
        }
    }

    public static class ExtraRenderer
    extends DefaultTableCellRenderer {
        public ExtraRenderer() {
            this.setHorizontalAlignment(0);
        }
    }

    public static class CurrencyRenderer
    extends DefaultTableCellRenderer {
        public CurrencyRenderer() {
            this.setHorizontalAlignment(4);
        }

        public void setValue(Object value) {
            if (value != null && value instanceof Number) {
                Number numberValue = (Number)value;
                NumberFormat formater = NumberFormat.getCurrencyInstance();
                value = formater.format(numberValue.doubleValue());
            }
            super.setValue(value);
        }
    }

    public static class IDRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setHorizontalAlignment(0);
            this.setForeground(new Color(153, 0, 0));
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return this;
        }
    }
}

