/*
 * Decompiled with CFR 0.152.
 */
package apkdownloader;

import apkdownloader.APKDownloaderApp;
import apkdownloader.dao.ConvertURL;
import apkdownloader.dao.ListAppsDAO;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXButton;

public class DownloadBox
extends JFrame {
    private String appId;
    private String title;
    private String version;
    public static ArrayList<Task> downloads = new ArrayList();
    ListAppsDAO appDao;
    private int index;
    private Task download;
    private JXButton btnCancel;
    private JXButton btnHide;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JLabel lbFilename;
    private JProgressBar pbDownload;
    private JLabel txtPercent;

    public DownloadBox(String appId, String title, String version) {
        this.initComponents();
        Image icon = this.getToolkit().getImage(this.getClass().getResource("/images/download.png"));
        this.setIconImage(icon);
        this.appId = appId;
        title = ConvertURL.toUrlFriendly(title).replaceAll(":", " -").replaceAll("/", " - ");
        this.version = version;
        int type = APKDownloaderApp.config.getFormatFileType();
        this.title = type == 1 || type == 3 ? title + ".apk" : title + " v" + this.version + ".apk";
        this.lbFilename.setText(this.title);
        this.startDownload();
    }

    private void startDownload() {
        this.appDao = new ListAppsDAO();
        this.download = new Task();
        downloads.add(this.download);
        this.index = downloads.lastIndexOf(this.download);
        this.download.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("progress".equals(evt.getPropertyName())) {
                    int progress;
                    if (DownloadBox.this.download.isCancelled()) {
                        DownloadBox.this.btnCancel.setEnabled(false);
                        DownloadBox.this.setTitle("Download canceled");
                    }
                    if ((progress = ((Integer)evt.getNewValue()).intValue()) == 100) {
                        DownloadBox.this.setTitle("Downloaded successfully!");
                    }
                    DownloadBox.this.pbDownload.setValue(progress);
                    DownloadBox.this.txtPercent.setText(progress + "%");
                }
            }
        });
        this.download.execute();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.pbDownload = new JProgressBar();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.lbFilename = new JLabel();
        this.btnHide = new JXButton();
        this.btnCancel = new JXButton();
        this.txtPercent = new JLabel();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance(APKDownloaderApp.class).getContext().getResourceMap(DownloadBox.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.setResizable(false);
        this.jPanel1.setBackground(resourceMap.getColor("jPanel1.background"));
        this.jPanel1.setName("jPanel1");
        this.pbDownload.setName("pbDownload");
        this.jLabel1.setIcon(resourceMap.getIcon("jLabel1.icon"));
        this.jLabel1.setName("jLabel1");
        this.jLabel2.setForeground(resourceMap.getColor("jLabel2.foreground"));
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.lbFilename.setForeground(resourceMap.getColor("lbFilename.foreground"));
        this.lbFilename.setText(resourceMap.getString("lbFilename.text", new Object[0]));
        this.lbFilename.setName("lbFilename");
        this.btnHide.setText(resourceMap.getString("btnHide.text", new Object[0]));
        this.btnHide.setName("btnHide");
        this.btnHide.setPreferredSize(new Dimension(65, 23));
        this.btnHide.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DownloadBox.this.btnHideActionPerformed(evt);
            }
        });
        this.btnCancel.setText(resourceMap.getString("btnCancel.text", new Object[0]));
        this.btnCancel.setName("btnCancel");
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DownloadBox.this.btnCancelActionPerformed(evt);
            }
        });
        this.txtPercent.setForeground(resourceMap.getColor("txtPercent.foreground"));
        this.txtPercent.setHorizontalAlignment(0);
        this.txtPercent.setText(resourceMap.getString("txtPercent.text", new Object[0]));
        this.txtPercent.setName("txtPercent");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1, -2, 125, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent((Component)this.btnCancel, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 53, Short.MAX_VALUE).addComponent((Component)this.btnHide, -2, 65, -2)).addComponent(this.pbDownload, -1, 183, Short.MAX_VALUE).addComponent(this.txtPercent, -1, 183, Short.MAX_VALUE).addComponent(this.lbFilename, -1, 183, Short.MAX_VALUE).addComponent(this.jLabel2, -1, 183, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(14, Short.MAX_VALUE).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbFilename).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtPercent).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pbDownload, -2, -1, -2).addGap(11, 11, 11).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.btnCancel, -2, -1, -2).addComponent((Component)this.btnHide, -2, -1, -2)).addContainerGap()).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2));
        this.pack();
    }

    private void btnHideActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.download.cancel(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Task
    extends SwingWorker<Void, Void> {
        @Override
        public Void doInBackground() {
            this.setProgress(0);
            DownloadBox.this.appDao.appDownload(DownloadBox.this.appId, DownloadBox.this.title, DownloadBox.this.index);
            return null;
        }

        @Override
        public void done() {
            if (!this.isCancelled()) {
                Toolkit.getDefaultToolkit().beep();
                DownloadBox.this.btnCancel.setEnabled(false);
            }
        }
    }
}

