/*
 * Decompiled with CFR 0.152.
 */
package apkdownloader;

import apkdownloader.APKDownloaderAboutBox;
import apkdownloader.APKDownloaderApp;
import apkdownloader.DownloadBox;
import apkdownloader.MyTableRenderer;
import apkdownloader.Option;
import apkdownloader.PutAName;
import apkdownloader.RenameOption;
import apkdownloader.ScanOption;
import apkdownloader.UpdateSoftware;
import apkdownloader.dao.ConvertURL;
import apkdownloader.dao.ListAppsDAO;
import apkdownloader.dao.MyTableFilter;
import apkdownloader.dao.ScanFolderDAO;
import apkdownloader.model.ListAppsModel;
import apkdownloader.model.ScanFolderModel;
import com.gc.android.market.api.LoginException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskMonitor;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXSearchField;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTableHeader;
import org.jdesktop.swingx.JXTitledSeparator;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class APKDownloaderView
extends FrameView {
    ListAppsModel model = new ListAppsModel();
    ScanFolderModel scan = null;
    public static String searchString = "";
    private Highlighter simpleStripHL = HighlighterFactory.createSimpleStriping();
    JMenuItem download = new JMenuItem("Download this app");
    JMenuItem downloadIcon = new JMenuItem("Download app icon");
    JMenuItem browseToWeb = new JMenuItem("View on Google Play");
    JMenuItem scanFolder = new JMenuItem("Scan Existing Folder");
    JMenuItem copyLink = new JMenuItem("Copy link location");
    JMenuItem searchRelate = new JMenuItem("Search relate apps");
    JMenuItem deleteFile = new JMenuItem("Delete this app");
    public static LoadTask load = null;
    MyTableFilter filterController = null;
    public boolean isFirstCheck = true;
    private ButtonGroup buttonGroup1;
    private JMenu jMenu1;
    private JScrollPane jScrollPane1;
    private JPopupMenu.Separator jSeparator1;
    private JXLabel jXLabel1;
    private JXLabel jXLabel2;
    private JXLabel jXLabel3;
    private JXLabel jXLabel4;
    private JXLabel jXLabel5;
    private JXTitledSeparator jXTitledSeparator1;
    private JXTable jxTable;
    private JXLabel lbCount;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JMenuItem mnCheckUpdate;
    private JMenuItem mnOption;
    private JMenuItem mnRenameAll;
    private JPopupMenu popupMenu;
    private JProgressBar progressBar;
    private JRadioButton rbCustomSearch;
    private JRadioButton rbPackageSearch;
    private JRadioButton rbVendorSearch;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private JXSearchField txtFilter;
    private JXSearchField txtSearch;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;

    public APKDownloaderView(SingleFrameApplication app) {
        super(app);
        this.initComponents();
        this.download.addActionListener(new ActionListener(){

            @Action
            public void actionPerformed(ActionEvent e) {
                ShowDownloadBox downloadbox = new ShowDownloadBox(APKDownloaderApp.getApplication());
                APKDownloaderView.this.getApplication().getContext().getTaskService().execute(downloadbox);
            }
        });
        this.download.setIcon(new ImageIcon(this.getClass().getResource("/images/download_16.png")));
        this.downloadIcon.addActionListener(new ActionListener(){

            @Action
            public void actionPerformed(ActionEvent e) {
                DownloadIcon di = new DownloadIcon(APKDownloaderApp.getApplication());
                APKDownloaderView.this.getApplication().getContext().getTaskService().execute(di);
            }
        });
        this.downloadIcon.setIcon(new ImageIcon(this.getClass().getResource("/images/download_icon.png")));
        this.copyLink.addActionListener(new ActionListener(){

            @Action
            public void actionPerformed(ActionEvent e) {
                int realRow = APKDownloaderView.this.jxTable.convertRowIndexToModel(APKDownloaderView.this.jxTable.getSelectedRow());
                String packageId = APKDownloaderView.this.jxTable.getModel().getValueAt(realRow, 2).toString();
                StringSelection stringSelection = new StringSelection("https://play.google.com/store/apps/details?id=" + packageId);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, null);
            }
        });
        this.copyLink.setIcon(new ImageIcon(this.getClass().getResource("/images/copy.png")));
        this.browseToWeb.addActionListener(new ActionListener(){

            @Action
            public void actionPerformed(ActionEvent e) {
                int realRow = APKDownloaderView.this.jxTable.convertRowIndexToModel(APKDownloaderView.this.jxTable.getSelectedRow());
                String packageId = APKDownloaderView.this.jxTable.getModel().getValueAt(realRow, 2).toString();
                try {
                    Desktop.getDesktop().browse(new URI("https://play.google.com/store/apps/details?id=" + packageId));
                }
                catch (URISyntaxException ex) {
                    Logger.getLogger(APKDownloaderView.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException io) {
                    Logger.getLogger(APKDownloaderView.class.getName()).log(Level.SEVERE, null, io);
                }
            }
        });
        this.browseToWeb.setIcon(new ImageIcon(this.getClass().getResource("/images/googleplay.png")));
        this.scanFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFrame mainFrame = APKDownloaderApp.getApplication().getMainFrame();
                APKDownloaderApp.so = new ScanOption((Frame)mainFrame, true);
                APKDownloaderApp.so.setLocationRelativeTo(mainFrame);
                APKDownloaderApp.getApplication().show(APKDownloaderApp.so);
                if (APKDownloaderApp.so.isSet) {
                    ScanTask scan = new ScanTask(APKDownloaderApp.getApplication());
                    APKDownloaderView.this.getApplication().getContext().getTaskService().execute(scan);
                }
            }
        });
        this.scanFolder.setIcon(new ImageIcon(this.getClass().getResource("/images/radar.png")));
        this.searchRelate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                APKDownloaderView.this.searchRelateApps();
            }
        });
        this.searchRelate.setIcon(new ImageIcon(this.getClass().getResource("/images/find.png")));
        this.deleteFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int realRow = APKDownloaderView.this.jxTable.convertRowIndexToModel(APKDownloaderView.this.jxTable.getSelectedRow());
                String filename = APKDownloaderView.this.jxTable.getModel().getValueAt(realRow, 0).toString();
                if (!ScanFolderDAO.deleteFile(filename)) {
                    JOptionPane.showMessageDialog(null, "Deletion failed!", "Error Message", 0);
                    return;
                }
                ((ScanFolderModel)APKDownloaderView.this.jxTable.getModel()).removeRow(realRow);
                APKDownloaderView.this.jxTable.repaint();
                APKDownloaderView.this.lbCount.setText("" + APKDownloaderView.this.jxTable.getRowCount());
            }
        });
        this.deleteFile.setIcon(new ImageIcon(this.getClass().getResource("/images/delete.png")));
        this.popupMenu.add(this.download);
        this.popupMenu.add(this.downloadIcon);
        this.popupMenu.add(this.scanFolder);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.deleteFile);
        this.popupMenu.add(this.copyLink);
        this.popupMenu.add(this.searchRelate);
        this.popupMenu.add(this.browseToWeb);
        this.browseToWeb.setEnabled(false);
        this.downloadIcon.setEnabled(false);
        this.copyLink.setEnabled(false);
        this.searchRelate.setEnabled(false);
        this.deleteFile.setEnabled(false);
        this.customizeTable();
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                APKDownloaderView.this.statusMessageLabel.setText("Done");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                APKDownloaderView.this.busyIconIndex = (APKDownloaderView.this.busyIconIndex + 1) % APKDownloaderView.this.busyIcons.length;
                APKDownloaderView.this.statusAnimationLabel.setIcon(APKDownloaderView.this.busyIcons[APKDownloaderView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!APKDownloaderView.this.busyIconTimer.isRunning()) {
                        APKDownloaderView.this.statusAnimationLabel.setIcon(APKDownloaderView.this.busyIcons[0]);
                        APKDownloaderView.this.busyIconIndex = 0;
                        APKDownloaderView.this.busyIconTimer.start();
                    }
                    APKDownloaderView.this.progressBar.setVisible(true);
                    APKDownloaderView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    APKDownloaderView.this.busyIconTimer.stop();
                    APKDownloaderView.this.statusAnimationLabel.setIcon(APKDownloaderView.this.idleIcon);
                    APKDownloaderView.this.progressBar.setVisible(false);
                    APKDownloaderView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    APKDownloaderView.this.statusMessageLabel.setText(text == null ? "" : text);
                    APKDownloaderView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    APKDownloaderView.this.progressBar.setVisible(true);
                    APKDownloaderView.this.progressBar.setIndeterminate(false);
                    APKDownloaderView.this.progressBar.setValue(value);
                }
            }
        });
    }

    private void customizeTable() {
        this.jxTable.setSelectionMode(0);
        this.jxTable.addHighlighter((Highlighter)new ColorHighlighter(HighlightPredicate.ROLLOVER_ROW, null, new Color(255, 102, 0)));
        this.filterController = new MyTableFilter(this.jxTable);
        BindingGroup filterGroup = new BindingGroup();
        filterGroup.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.txtFilter, (Property)BeanProperty.create((String)"text"), (Object)((Object)this.filterController), (Property)BeanProperty.create((String)"filterString")));
        filterGroup.bind();
        TableColumnModel columnModel = this.jxTable.getColumnModel();
        this.jxTable.setTableHeader((JTableHeader)new JXTableHeader(columnModel){

            public void updateUI() {
                super.updateUI();
                if (this.getDefaultRenderer() instanceof JLabel) {
                    ((JLabel)((Object)this.getDefaultRenderer())).setHorizontalAlignment(0);
                }
            }
        });
        this.jxTable.setDefaultRenderer("".getClass(), (TableCellRenderer)new MyTableRenderer.ColRenderer());
        this.rebuildSearchTableUI();
        this.jxTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    APKDownloaderView.this.download.setEnabled(APKDownloaderView.this.jxTable.getSelectedRowCount() != 0);
                    APKDownloaderView.this.browseToWeb.setEnabled(APKDownloaderView.this.jxTable.getSelectedRowCount() != 0);
                    APKDownloaderView.this.downloadIcon.setEnabled(APKDownloaderView.this.jxTable.getSelectedRowCount() != 0);
                    APKDownloaderView.this.copyLink.setEnabled(APKDownloaderView.this.jxTable.getSelectedRowCount() != 0);
                    APKDownloaderView.this.searchRelate.setEnabled(APKDownloaderView.this.jxTable.getSelectedRowCount() != 0);
                    APKDownloaderView.this.deleteFile.setEnabled(APKDownloaderView.this.jxTable.getSelectedRowCount() != 0);
                    if (APKDownloaderView.this.jxTable.getSelectedRowCount() > 0) {
                        int realRow = APKDownloaderView.this.jxTable.convertRowIndexToModel(APKDownloaderView.this.jxTable.getSelectedRow());
                        if (APKDownloaderView.this.jxTable.getModel().getColumnCount() == 7) {
                            APKDownloaderView.this.deleteFile.setEnabled(false);
                            if (!"Free".equals(APKDownloaderView.this.jxTable.getModel().getValueAt(realRow, 6).toString())) {
                                // empty if block
                            }
                        } else {
                            APKDownloaderView.this.deleteFile.setEnabled(true);
                            if (!"Free".equals(APKDownloaderView.this.jxTable.getModel().getValueAt(realRow, 4).toString())) {
                                // empty if block
                            }
                        }
                        if (" ".equals(APKDownloaderView.this.jxTable.getModel().getValueAt(realRow, 6))) {
                            APKDownloaderView.this.browseToWeb.setEnabled(false);
                            APKDownloaderView.this.downloadIcon.setEnabled(false);
                            APKDownloaderView.this.copyLink.setEnabled(false);
                        }
                    }
                }
            }
        });
        this.jxTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.checkForTriggerEvent(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.checkForTriggerEvent(e);
            }

            private void checkForTriggerEvent(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    APKDownloaderView.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = APKDownloaderApp.getApplication().getMainFrame();
            this.aboutBox = new APKDownloaderAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        APKDownloaderApp.getApplication().show(this.aboutBox);
    }

    @Action
    public void showDownloadBox(String appId, String title, String version) {
        JFrame mainFrame = APKDownloaderApp.getApplication().getMainFrame();
        DownloadBox downloadBox = new DownloadBox(appId, title, version);
        downloadBox.setLocationRelativeTo(mainFrame);
        APKDownloaderApp.getApplication().show(downloadBox);
    }

    @Action
    public void showOption() {
        JFrame mainFrame = APKDownloaderApp.getApplication().getMainFrame();
        Option option = new Option((Frame)mainFrame, true);
        option.setLocationRelativeTo(mainFrame);
        APKDownloaderApp.getApplication().show(option);
    }

    public void getSearchString() {
        String txtMarketSearch;
        String searchType = "";
        if (this.rbVendorSearch.isSelected()) {
            searchType = "pub:";
        }
        if (this.rbPackageSearch.isSelected()) {
            searchType = "pname:";
        }
        searchString = (txtMarketSearch = this.txtSearch.getText().trim()).isEmpty() ? "" : searchType + txtMarketSearch;
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jXLabel1 = new JXLabel();
        this.txtFilter = new JXSearchField();
        this.jScrollPane1 = new JScrollPane();
        this.jxTable = new JXTable();
        this.jXLabel2 = new JXLabel();
        this.txtSearch = new JXSearchField();
        this.rbCustomSearch = new JRadioButton();
        this.rbVendorSearch = new JRadioButton();
        this.rbPackageSearch = new JRadioButton();
        this.jXTitledSeparator1 = new JXTitledSeparator();
        this.jXLabel3 = new JXLabel();
        this.lbCount = new JXLabel();
        this.jXLabel5 = new JXLabel();
        this.jXLabel4 = new JXLabel();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem exitMenuItem = new JMenuItem();
        this.jMenu1 = new JMenu();
        this.mnRenameAll = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.mnOption = new JMenuItem();
        JMenu helpMenu = new JMenu();
        this.mnCheckUpdate = new JMenuItem();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.buttonGroup1 = new ButtonGroup();
        this.popupMenu = new JPopupMenu();
        ResourceMap resourceMap = Application.getInstance(APKDownloaderApp.class).getContext().getResourceMap(APKDownloaderView.class);
        this.mainPanel.setBackground(resourceMap.getColor("mainPanel.background"));
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.mainPanel.setName("mainPanel");
        this.jXLabel1.setHorizontalAlignment(2);
        this.jXLabel1.setIcon(resourceMap.getIcon("jXLabel1.icon"));
        this.jXLabel1.setText(resourceMap.getString("jXLabel1.text", new Object[0]));
        this.jXLabel1.setName("jXLabel1");
        this.txtFilter.setText(resourceMap.getString("txtFilter.text", new Object[0]));
        this.txtFilter.setName("txtFilter");
        this.txtFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                APKDownloaderView.this.txtFilterActionPerformed(evt);
            }
        });
        this.jScrollPane1.setName("jScrollPane1");
        this.jxTable.setModel((TableModel)this.model);
        this.jxTable.setToolTipText(resourceMap.getString("jxTable.toolTipText", new Object[0]));
        this.jxTable.setColumnControlVisible(true);
        this.jxTable.setGridColor(resourceMap.getColor("jxTable.gridColor"));
        this.jxTable.setHighlighters(new Highlighter[]{this.simpleStripHL});
        this.jxTable.setName("jxTable");
        this.jxTable.setRowHeight(48);
        this.jxTable.setShowGrid(true);
        this.jScrollPane1.setViewportView((Component)this.jxTable);
        this.jXLabel2.setForeground(resourceMap.getColor("jXLabel2.foreground"));
        this.jXLabel2.setText(resourceMap.getString("jXLabel2.text", new Object[0]));
        this.jXLabel2.setName("jXLabel2");
        this.txtSearch.setText(resourceMap.getString("txtSearch.text", new Object[0]));
        this.txtSearch.setName("txtSearch");
        this.txtSearch.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                APKDownloaderView.this.txtSearchKeyPressed(evt);
            }
        });
        this.rbCustomSearch.setBackground(resourceMap.getColor("rbCustomSearch.background"));
        this.buttonGroup1.add(this.rbCustomSearch);
        this.rbCustomSearch.setSelected(true);
        this.rbCustomSearch.setText(resourceMap.getString("rbCustomSearch.text", new Object[0]));
        this.rbCustomSearch.setFocusable(false);
        this.rbCustomSearch.setName("rbCustomSearch");
        this.rbVendorSearch.setBackground(resourceMap.getColor("rbVendorSearch.background"));
        this.buttonGroup1.add(this.rbVendorSearch);
        this.rbVendorSearch.setText(resourceMap.getString("rbVendorSearch.text", new Object[0]));
        this.rbVendorSearch.setFocusable(false);
        this.rbVendorSearch.setName("rbVendorSearch");
        this.rbPackageSearch.setBackground(resourceMap.getColor("rbPackageSearch.background"));
        this.buttonGroup1.add(this.rbPackageSearch);
        this.rbPackageSearch.setForeground(resourceMap.getColor("rbPackageSearch.foreground"));
        this.rbPackageSearch.setText(resourceMap.getString("rbPackageSearch.text", new Object[0]));
        this.rbPackageSearch.setFocusable(false);
        this.rbPackageSearch.setName("rbPackageSearch");
        this.jXTitledSeparator1.setForeground(resourceMap.getColor("jXTitledSeparator1.foreground"));
        this.jXTitledSeparator1.setFont(resourceMap.getFont("jXTitledSeparator1.font"));
        this.jXTitledSeparator1.setHorizontalAlignment(0);
        this.jXTitledSeparator1.setName("jXTitledSeparator1");
        this.jXTitledSeparator1.setTitle(resourceMap.getString("jXTitledSeparator1.title", new Object[0]));
        this.jXLabel3.setForeground(resourceMap.getColor("jXLabel3.foreground"));
        this.jXLabel3.setText(resourceMap.getString("jXLabel3.text", new Object[0]));
        this.jXLabel3.setName("jXLabel3");
        this.lbCount.setForeground(resourceMap.getColor("lbCount.foreground"));
        this.lbCount.setText(resourceMap.getString("lbCount.text", new Object[0]));
        this.lbCount.setName("lbCount");
        this.jXLabel5.setText(resourceMap.getString("jXLabel5.text", new Object[0]));
        this.jXLabel5.setName("jXLabel5");
        this.jXLabel4.setHorizontalAlignment(4);
        this.jXLabel4.setIcon(resourceMap.getIcon("jXLabel4.icon"));
        this.jXLabel4.setText(resourceMap.getString("jXLabel4.text", new Object[0]));
        this.jXLabel4.setName("jXLabel4");
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 797, Short.MAX_VALUE).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent((Component)this.txtFilter, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.jXLabel2, GroupLayout.Alignment.LEADING, -2, -1, -2))).addComponent((Component)this.jXLabel1, -2, -1, -2)).addGap(18, 18, 18).addComponent((Component)this.jXLabel4, -2, 186, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 58, Short.MAX_VALUE).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addComponent((Component)this.jXLabel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.lbCount, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jXLabel3, -2, -1, -2)).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent((Component)this.jXTitledSeparator1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addComponent(this.rbVendorSearch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbPackageSearch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbCustomSearch)).addComponent((Component)this.txtSearch, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGap(22, 22, 22).addComponent((Component)this.jXTitledSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rbCustomSearch).addComponent(this.rbPackageSearch).addComponent(this.rbVendorSearch)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.txtSearch, -2, 22, -2).addGap(27, 27, 27)).addGroup(mainPanelLayout.createSequentialGroup().addComponent((Component)this.jXLabel1, -1, 107, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(mainPanelLayout.createSequentialGroup().addComponent((Component)this.jXLabel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.txtFilter, -2, -1, -2)).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.jXLabel3, -2, -1, -2).addComponent((Component)this.lbCount, -2, -1, -2).addComponent((Component)this.jXLabel5, -2, -1, -2)))).addComponent((Component)this.jXLabel4, -1, 155, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -2, 406, -2)));
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        ApplicationActionMap actionMap = Application.getInstance(APKDownloaderApp.class).getContext().getActionMap(APKDownloaderView.class, this);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setIcon(resourceMap.getIcon("exitMenuItem.icon"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        this.jMenu1.setText(resourceMap.getString("jMenu1.text", new Object[0]));
        this.jMenu1.setName("jMenu1");
        this.mnRenameAll.setText(resourceMap.getString("mnRenameAll.text", new Object[0]));
        this.mnRenameAll.setName("mnRenameAll");
        this.mnRenameAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                APKDownloaderView.this.mnRenameAllActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.mnRenameAll);
        this.jSeparator1.setName("jSeparator1");
        this.jMenu1.add(this.jSeparator1);
        this.mnOption.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.mnOption.setIcon(new ImageIcon(this.getClass().getResource("/images/gear.png")));
        this.mnOption.setText(resourceMap.getString("mnOption.text", new Object[0]));
        this.mnOption.setName("mnOption");
        this.mnOption.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                APKDownloaderView.this.mnOptionActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.mnOption);
        this.menuBar.add(this.jMenu1);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        this.mnCheckUpdate.setIcon(resourceMap.getIcon("mnCheckUpdate.icon"));
        this.mnCheckUpdate.setText(resourceMap.getString("mnCheckUpdate.text", new Object[0]));
        this.mnCheckUpdate.setName("mnCheckUpdate");
        this.mnCheckUpdate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                APKDownloaderView.this.mnCheckUpdateActionPerformed(evt);
            }
        });
        helpMenu.add(this.mnCheckUpdate);
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setBackground(resourceMap.getColor("statusPanel.background"));
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(statusPanelSeparator, -1, 799, Short.MAX_VALUE).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 629, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(statusPanelSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel).addComponent(this.progressBar, -2, -1, -2)).addGap(3, 3, 3)));
        this.popupMenu.setName("popupMenu");
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    @Action
    private void txtSearchKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            if (APKDownloaderApp.config == null) {
                JOptionPane.showMessageDialog(APKDownloaderApp.getApplication().getMainFrame(), "You must setup info in Option first.", "Error Message", 0);
                this.showOption();
                return;
            }
            load = new LoadTask(APKDownloaderApp.getApplication());
            this.getApplication().getContext().getTaskService().execute(load);
            this.jxTable.clearSelection();
            this.jxTable.repaint();
        }
    }

    private void mnOptionActionPerformed(ActionEvent evt) {
        this.showOption();
    }

    private void txtFilterActionPerformed(ActionEvent evt) {
        this.jxTable.repaint();
    }

    private void mnRenameAllActionPerformed(ActionEvent evt) {
        this.renameAll();
    }

    private void mnCheckUpdateActionPerformed(ActionEvent evt) {
        this.isFirstCheck = false;
        CheckForUpdate check = new CheckForUpdate(APKDownloaderApp.getApplication());
        this.getApplication().getContext().getTaskService().execute(check);
    }

    private void searchRelateApps() {
        int realRow = this.jxTable.convertRowIndexToModel(this.jxTable.getSelectedRow());
        String appName = this.jxTable.getModel().getValueAt(realRow, 3).toString();
        this.txtSearch.setText(appName);
        load = new LoadTask(APKDownloaderApp.getApplication());
        this.getApplication().getContext().getTaskService().execute(load);
        this.jxTable.repaint();
    }

    private void renameAll() {
        JFrame mainFrame = APKDownloaderApp.getApplication().getMainFrame();
        APKDownloaderApp.ro = new RenameOption((Frame)mainFrame, true);
        APKDownloaderApp.ro.setLocationRelativeTo(mainFrame);
        APKDownloaderApp.getApplication().show(APKDownloaderApp.ro);
        if (!APKDownloaderApp.ro.isSet) {
            return;
        }
        TableModel tmd = this.jxTable.getModel();
        for (int i = 0; i < tmd.getRowCount(); ++i) {
            String name = tmd.getValueAt(i, 3).toString();
            String version = APKDownloaderApp.ro.renameType == 1 ? "" : " v" + tmd.getValueAt(i, 5).toString();
            tmd.setValueAt(ConvertURL.toUrlFriendly(name).replaceAll(":", " -") + version + ".apk", i, 0);
        }
    }

    public void rebuildSearchTableUI() {
        this.jxTable.getColumn(0).setCellRenderer(new MyTableRenderer.IconRenderer());
        this.jxTable.getColumn(1).setCellRenderer(new MyTableRenderer.ColorRenderer());
        this.jxTable.getColumn(5).setCellRenderer(new MyTableRenderer.ExtraRenderer());
        this.jxTable.getColumn(6).setCellRenderer(new MyTableRenderer.PriceRenderer());
        this.jxTable.getColumn(0).setMaxWidth(48);
        this.jxTable.getColumn(0).setMinWidth(48);
        this.jxTable.getColumn(4).setMaxWidth(80);
        this.jxTable.getColumn(6).setMaxWidth(60);
        this.jxTable.getColumn(5).setMaxWidth(100);
        this.lbCount.setText("" + this.jxTable.getRowCount());
        this.jxTable.setRowHeight(48);
        this.jxTable.setShowGrid(true);
    }

    public void rebuildScanTableUI() {
        this.jxTable.setRowHeight(24);
        this.jxTable.setShowGrid(false);
        this.jxTable.getColumn(0).setCellRenderer(new MyTableRenderer.ColorRenderer());
        this.jxTable.getColumn(1).setCellRenderer(new MyTableRenderer.ExtraRenderer());
        this.jxTable.getColumn(3).setCellRenderer(new MyTableRenderer.ColorRenderer());
        this.jxTable.getColumn(4).setCellRenderer(new MyTableRenderer.ExtraRenderer());
        this.jxTable.getColumn(7).setCellRenderer(new MyTableRenderer.StatusRenderer());
        this.jxTable.getColumn(0).setMinWidth(140);
        this.jxTable.getColumn(0).setMaxWidth(180);
        this.jxTable.getColumn(1).setMaxWidth(80);
        this.jxTable.getColumn(4).setMaxWidth(60);
        this.jxTable.getColumn(3).setMaxWidth(150);
        this.jxTable.getColumn(3).setMinWidth(120);
        this.jxTable.getColumn(5).setMaxWidth(80);
        this.jxTable.getColumn(6).setMaxWidth(80);
        this.jxTable.getColumn(7).setMaxWidth(30);
        this.jxTable.getColumn(7).setMinWidth(30);
        this.lbCount.setText("" + this.jxTable.getRowCount());
    }

    class DownloadIcon
    extends Task {
        public DownloadIcon(Application app) {
            super(app);
        }

        protected Void doInBackground() {
            int realIndex = APKDownloaderView.this.jxTable.convertRowIndexToModel(APKDownloaderView.this.jxTable.getSelectedRow());
            String appId = "";
            String title = "";
            if (APKDownloaderView.this.jxTable.getModel().getColumnCount() == 7) {
                appId = ListAppsDAO.responseApps.get(realIndex).getId();
                title = ListAppsDAO.responseApps.get(realIndex).getTitle();
            } else {
                appId = APKDownloaderView.this.jxTable.getModel().getValueAt(realIndex, 7).toString().replaceAll("#.*$", "");
                title = APKDownloaderView.this.jxTable.getModel().getValueAt(realIndex, 3).toString();
            }
            this.firePropertyChange("message", "", "Downloading icon...");
            ListAppsDAO.downloadIcon(appId, title);
            return null;
        }
    }

    class CheckForUpdate
    extends Task {
        public CheckForUpdate(Application app) {
            super(app);
        }

        protected Void doInBackground() {
            try {
                this.firePropertyChange("message", "", "Check for update...");
                URL url = new URL("http://codeimba.com/version.html");
                URLConnection con = url.openConnection();
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                String inputLine = in.readLine().replaceAll("^.*version:", "");
                if (!APKDownloaderApp.version.equals(inputLine)) {
                    JFrame mainFrame = APKDownloaderApp.getApplication().getMainFrame();
                    UpdateSoftware update = new UpdateSoftware((Frame)mainFrame, true, inputLine);
                    update.setLocationRelativeTo(mainFrame);
                    APKDownloaderApp.getApplication().show(update);
                }
                if (!APKDownloaderView.this.isFirstCheck && APKDownloaderApp.version.equals(inputLine)) {
                    JOptionPane.showMessageDialog(null, "Your software is already up-to-date", "Check for update", 1);
                }
                in.close();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Error while connecting to server.", "Error Message", 0);
            }
            return null;
        }
    }

    class ShowDownloadBox
    extends Task {
        public ShowDownloadBox(Application app) {
            super(app);
        }

        protected Void doInBackground() {
            try {
                int realIndex = APKDownloaderView.this.jxTable.convertRowIndexToModel(APKDownloaderView.this.jxTable.getSelectedRow());
                String appId = "";
                String title = "";
                String version = "";
                if (APKDownloaderView.this.jxTable.getModel().getColumnCount() == 7) {
                    appId = ListAppsDAO.responseApps.get(realIndex).getId();
                    title = ListAppsDAO.responseApps.get(realIndex).getTitle();
                    version = ListAppsDAO.responseApps.get(realIndex).getVersion();
                } else {
                    appId = APKDownloaderView.this.jxTable.getModel().getValueAt(realIndex, 7).toString().replaceAll("#.*$", "");
                    title = APKDownloaderView.this.jxTable.getModel().getValueAt(realIndex, 3).toString();
                    version = APKDownloaderView.this.jxTable.getModel().getValueAt(realIndex, 6).toString();
                }
                if (APKDownloaderApp.config.getFormatFileType() == 3) {
                    JFrame mainFrame = APKDownloaderApp.getApplication().getMainFrame();
                    PutAName putName = new PutAName((Frame)mainFrame, true, title);
                    putName.setLocationRelativeTo(mainFrame);
                    putName.setVisible(true);
                    if (!putName.status) {
                        return null;
                    }
                    title = putName.appTitle;
                }
                APKDownloaderView.this.showDownloadBox(appId, title, version);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Some error occured! Close and try again!", "Error Message", 0);
            }
            return null;
        }
    }

    public class ScanTask
    extends Task {
        public ScanTask(Application app) {
            super(app);
        }

        protected Void doInBackground() {
            try {
                this.firePropertyChange("message", "", "Scanning... Be patient!");
                APKDownloaderView.this.scan = new ScanFolderModel();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ScanTask.this.firePropertyChange("message", "", "Loading data to table...");
                        APKDownloaderView.this.jxTable.setModel((TableModel)APKDownloaderView.this.scan);
                        APKDownloaderView.this.rebuildScanTableUI();
                    }
                });
            }
            catch (LoginException le) {
                JOptionPane.showMessageDialog(APKDownloaderApp.getApplication().getMainFrame(), "Login failed! Please check your email or password in Settings.", "Error Message", 0);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Cannot load the list of apps. Please check your internet connection.", "Error Message", 0);
            }
            return null;
        }
    }

    public class LoadTask
    extends Task {
        public LoadTask(Application app) {
            super(app);
        }

        protected Void doInBackground() {
            try {
                APKDownloaderView.this.getSearchString();
                APKDownloaderView.this.model = new ListAppsModel();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        APKDownloaderView.this.jxTable.setModel((TableModel)APKDownloaderView.this.model);
                        APKDownloaderView.this.rebuildSearchTableUI();
                    }
                });
            }
            catch (LoginException le) {
                JOptionPane.showMessageDialog(APKDownloaderApp.getApplication().getMainFrame(), "Login failed! Please check your email or password in Settings.", "Error Message", 0);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Cannot load the list of apps." + e.getMessage(), "Error Message", 0);
            }
            return null;
        }
    }
}

