/*
 * Decompiled with CFR 0.152.
 */
package apkdownloader;

import apkdownloader.APKDownloaderView;
import apkdownloader.Option;
import apkdownloader.RenameOption;
import apkdownloader.ScanOption;
import apkdownloader.entities.Config;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.jdesktop.application.Application;
import org.jdesktop.application.SingleFrameApplication;

public class APKDownloaderApp
extends SingleFrameApplication {
    public static Config config = null;
    public static ScanOption so = null;
    public static RenameOption ro = null;
    public static String version = "1.3.6";

    protected void startup() {
        File f;
        if (!System.getProperty("os.name").startsWith("Windows")) {
            try {
                UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!(f = new File(Config.configFile)).exists()) {
            this.showOption();
        } else {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(Config.configFile));
                config = (Config)ois.readObject();
                ois.close();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Error while reading config file.", "Error Message", 0);
                this.showOption();
            }
        }
        APKDownloaderView view = new APKDownloaderView(this);
        view.getFrame().setResizable(false);
        view.getFrame().setTitle("Real APK Leecher v1.3.6 by CodeBlue");
        Image icon = view.getFrame().getToolkit().getImage(this.getClass().getResource("/images/app_icon.png"));
        view.getFrame().setIconImage(icon);
        this.show(view);
    }

    private void showOption() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Option o = new Option(null, true);
        int x = (d.width - o.getWidth()) / 2;
        int y = (d.height - o.getHeight()) / 2;
        o.setLocation(x, y);
        o.setVisible(true);
    }

    protected void configureWindow(Window root) {
    }

    public static APKDownloaderApp getApplication() {
        return Application.getInstance(APKDownloaderApp.class);
    }

    public static void main(String[] args) {
        APKDownloaderApp.launch(APKDownloaderApp.class, args);
    }
}

