/*
 * Decompiled with CFR 0.152.
 */
package com.gc.android.market.api;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;

public class Tools {
    public static String postUrl(String url, Map<String, String> params) throws IOException {
        String data = "";
        for (String key : params.keySet()) {
            data = String.valueOf(data) + "&" + URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(params.get(key), "UTF-8");
        }
        data = data.substring(1);
        URL aURL = new URL(url);
        HttpURLConnection aConnection = (HttpURLConnection)aURL.openConnection();
        try {
            String string;
            aConnection.setDoOutput(true);
            aConnection.setDoInput(true);
            aConnection.setRequestMethod("POST");
            OutputStreamWriter streamToAuthorize = new OutputStreamWriter(aConnection.getOutputStream());
            streamToAuthorize.write(data);
            streamToAuthorize.flush();
            streamToAuthorize.close();
            int errorCode = aConnection.getResponseCode();
            if (errorCode >= 400) {
                InputStream errorStream = aConnection.getErrorStream();
                try {
                    String errorData = Tools.streamToString(errorStream);
                    throw new HttpException(errorCode, errorData);
                }
                catch (Throwable throwable) {
                    errorStream.close();
                    throw throwable;
                }
            }
            InputStream resultStream = aConnection.getInputStream();
            try {
                String responseData;
                string = responseData = Tools.streamToString(resultStream);
            }
            catch (Throwable throwable) {
                resultStream.close();
                throw throwable;
            }
            resultStream.close();
            return string;
        }
        finally {
            aConnection.disconnect();
        }
    }

    private static String streamToString(InputStream resultStream) throws IOException {
        BufferedReader aReader = new BufferedReader(new InputStreamReader(resultStream));
        StringBuffer aResponse = new StringBuffer();
        String aLine = aReader.readLine();
        while (aLine != null) {
            aResponse.append(String.valueOf(aLine) + "\n");
            aLine = aReader.readLine();
        }
        return aResponse.toString();
    }

    public static class HttpException
    extends RuntimeException {
        private int errorCode;
        private String errorData;

        public HttpException(int errorCode, String errorData) {
            super("HTTP Code " + errorCode + " : " + errorData);
            this.errorCode = errorCode;
            this.errorData = errorData;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public String getErrorData() {
            return this.errorData;
        }
    }
}

