-- 
-- DO NOT EDIT THIS FILE. IT WILL BE OVERWRITTEN WHEN YOU UPGRADE RAINLENDAR!
-- 

--
-- Changes the date that Rainlendar shows.
--
-- Parameters: 
--    newMonth - A relative month offset or absolute month.
--               Use + or - prefix to define a relative value.
--               Value 0 changes to the current month.
-- Return:
--    Nothing
--
function Global_ShowMonth(newMonth)
	-- Get the currently displayed date from Rainlendar
	local day, month, year = Rainlendar_GetDisplayDate()

  if string.sub(newMonth, 1, 1) == "+" or string.sub(newMonth, 1, 1) == "-" then
		-- Relative value -> adjust the month
		month = month + newMonth

		-- Make sure that the date is correct
		while month < 0 do
			month = month + 12
			year = year - 1
		end
		while month >= 12 do
			month = month - 12
			year = year + 1
		end
  elseif newMonth == "0" then
		-- Set to current date
  	month = os.date("%m") - 1
  	year = os.date("%Y")
  else
    -- Set to selected month
  	month = newMonth - 1
  	year = os.date("%Y")
  end

	-- Set the date to Rainlendar
	Rainlendar_SetDisplayDate(day, month, year)
	
	-- Redraw so that the change can be seen
	Rainlendar_Redraw(0)
end

--
-- Changes the date that the schedule window shows.
--
-- Parameters: 
--    newDay - The increase (+) or decrease (-) of days. 
--             Value 0 changes to the current day.
--    window - The schedule window.
-- Return:
--    Nothing
--
function Global_ChangeScheduleDay(newDay, window)

  if tonumber(newDay) == 0 then
  	Rainlendar_ResetScheduleDate(window)
  else
  	Rainlendar_ChangeScheduleDate(tonumber(newDay), window)
  end
	
	-- Redraw so that the change can be seen
	Rainlendar_Redraw(0, window)
end

