const { classes: Cc, interfaces: Ci, utils: Cu } = Components;
Cu.import('resource://gre/modules/Services.jsm');

var startupData;

function loadIntoWindow(window) {
    var require = window.require;
    var log = require("ko/logging").getLogger("commando-scope-docs-bootstrap")
    
    try {
        require.setRequirePath("scope-docs/", "chrome://scope-docs/content/sdk/");
        var commando = require("commando/commando");
        commando.registerScope("scope-docs", {
            name: "Documentation",
            description: "Easy access to api documentation",
            icon: "koicon://ko-svg/chrome/icomoon/skin/book2.svg",
            handler: "scope-docs/docs"
        });
    } catch (e) {
        log.exception(e, "Commando: Exception while registering scope 'Docs'");
    }

    try {
        var component = startupData.installPath.clone();
        component.append("components");
        component.append("component.manifest");

        var registrar = Components.manager.QueryInterface(Ci.nsIComponentRegistrar);
        registrar.autoRegister(component);
    } catch (e) {
        log.exception(e, "Commando: Exception while registering component for 'Docs' scope");
    }
    
    try {
        require("scope-docs/docs").init();
    } catch (e) {
        log.exception(e, "Commando: Exception while initialising the 'Docs' scope");
    }
    
    var btn = require("ko/button");
    btn.register({
        id: "openDocs",
        label: "Open Documentation for Current Language",
        toolbar: true,
        command: "cmd_doc_open_current",
        classList: "docs-icon",
        context: [
            {
                select: "#toolsToolbarGroup",
                where: "append"
            }
        ]
    });
}

function unloadFromWindow(window) {
    if (!window) return;
    var commando = require("commando/commando");
    commando.unregisterScope("project-docs");
}

var windowListener = {
    onOpenWindow: function(aWindow) {
        // Wait for the window to finish loading
        let domWindow = aWindow.QueryInterface(Ci.nsIInterfaceRequestor).getInterface(Ci.nsIDOMWindowInternal || Ci.nsIDOMWindow);
        domWindow.addEventListener("komodo-post-startup", function onLoad() {
            domWindow.removeEventListener("komodo-post-startup", onLoad, false);
            loadIntoWindow(domWindow);
        }, false);
    },

    onCloseWindow: function(aWindow) {},
    onWindowTitleChange: function(aWindow, aTitle) {}
};

function startup(data, reason) {
    startupData = data;

    // Load into any existing windows
    let windows = Services.wm.getEnumerator("Komodo");
    while (windows.hasMoreElements()) {
        let domWindow = windows.getNext().QueryInterface(Ci.nsIDOMWindow);
        loadIntoWindow(domWindow);
    }

    // Load into any new windows
    Services.wm.addListener(windowListener);
}

function shutdown(data, reason) {
    // When the application is shutting down we normally don't have to clean
    // up any UI changes made
    if (reason == APP_SHUTDOWN) return;

    // Stop listening for new windows
    Services.wm.removeListener(windowListener);

    // Unload from any existing windows
    let windows = Services.wm.getEnumerator("Komodo");
    while (windows.hasMoreElements()) {
        let domWindow = windows.getNext().QueryInterface(Ci.nsIDOMWindow);
        unloadFromWindow(domWindow);
    }
}

function install(data, reason) {}

function uninstall(data, reason) {}
