#!python
# Copyright (c) 2000-2011 ActiveState Software Inc.
# See the file LICENSE.txt for licensing information.

# Komodo Twig language service.
#
# Generated by 'luddite.py' on Fri Oct 20 08:49:16 2006.
# Then put into skel/ on Fri Jul  6 14:28:38 PDT 2007

import logging
import os, sys, re
from os.path import join, dirname, exists

from koXMLLanguageBase import KoDjangoTemplateFamilyBase

log = logging.getLogger("koTwigLanguage")
#log.setLevel(logging.DEBUG)

def registerLanguage(registry):
    log.debug("Registering language Twig")
    registry.registerLanguage(KoTwigLanguage())

class KoTwigLanguage(KoDjangoTemplateFamilyBase):
    name = "Twig"
    lexresLangName = "Twig"
    _reg_desc_ = "%s Language" % name
    _reg_contractid_ = "@activestate.com/koLanguage?language=%s;1" % name
    _reg_clsid_ = "{2ae17256-e73f-4318-bb11-aeb07e68f1d6}"
    _reg_categories_ = [("komodo-language", name)]

    primary = 1
    defaultExtension = '.twig'
    searchURL = "http://twig.sensiolabs.org/documentation"

    lang_from_udl_family = {'CSL': 'JavaScript', 'TPL': 'Twig', 'M': 'HTML', 'CSS': 'CSS'}
    
    _sliders = "else elseif".split()
    _startWords = "else elseif if autoescape block comment embed filter for macro raw sandbox spaceless with".split()

    sample = """{% if latest_poll_list %}
    <ul>
    {% for poll in latest_poll_list %}
        <li><a href="/polls/{{ poll.id }}/">{{ poll.question }}</a></li>
    {% endfor %}
    </ul>
{% else %}
    <p>No polls are available.</p>
{% endif %}
"""
