# Komodo MXML language service.
#
# Generated by 'luddite.py' on Thu Mar 15 16:06:49 2007.
#

import logging
from xpcom import components
from koXMLLanguageBase import koXMLLanguageBase, KoGenericXMLLinter


log = logging.getLogger("koMXMLLanguage")
#log.setLevel(logging.DEBUG)


def registerLanguage(registry):
    log.debug("Registering language MXML")
    registry.registerLanguage(KoMXMLLanguage())


class KoMXMLLanguage(koXMLLanguageBase):
    name = "MXML"
    lexresLangName = "MXML"
    _reg_desc_ = "%s Language" % name
    _reg_contractid_ = "@activestate.com/koLanguage?language=%s;1" % name
    _reg_clsid_ = "{8cdb154f-47e6-420e-a918-1548ab748499}"
    _reg_categories_ = [("komodo-language", name)]
    defaultExtension = '.mxml'

    lang_from_udl_family = {'CSL': 'ActionScript', 'M': 'XML'}

    systemIdList = ["http://www.adobe.com/2006/mxml",
                  "http://www.macromedia.com/2003/mxml"]
    namespaces = ["http://www.adobe.com/2006/mxml",
                  "http://www.macromedia.com/2003/mxml"]

    sample = """<mx:Application xmlns:mx="http://www.adobe.com/2006/mxml" 
                layout="absolute" backgroundGradientColors="[#000011, #333333]">
   <mx:Label text="Hello World!" verticalCenter="0" horizontalCenter="0" fontSize="48" letterSpacing="1">
      <mx:filters>
         <mx:GlowFilter color="#ffffdd"/>
      </mx:filters>
   </mx:Label>
</mx:Application>
"""

class KoMXMLCompileLinter(KoGenericXMLLinter):
    _reg_desc_ = "Komodo MXML Compile Linter"
    _reg_clsid_ = "{85d92de0-f7d6-4c33-8736-dcb8ea9b6a41}"
    _reg_contractid_ = "@activestate.com/koLinter?language=MXML;1"
    _reg_categories_ = [
         ("category-komodo-linter", 'MXML'),
         ]
