#include <iostream>
#include <fstream>
#include <cstdlib>
#include <math.h>
#include <time.h>
#include <time.h>

using namespace std;

#define MAIN
#include "ldraw.hpp"

void pause(void)
{
	cout << "Press <Enter> to quit" << endl;
	getchar();
}
void usage(void)
{
	cout << "Edger2 [options] Infile, Outfile" << endl;
	cout << "-p <val>: precision (default 0.001)" << endl;
	cout << "-af <val>: flat enough angle (default 1 degree)" << endl;
	cout << "-ac <val>: conditional limit angle (default 60 degrees)" << endl;
	cout << "-ae <val>: edge limit angle (default 60 degrees)" << endl;
	cout << "-dc: delete existing conditional lines" << endl;
	cout << "-de: delete existing edge lines" << endl;
	cout << "-u+: create only unmatched edges" << endl;
	cout << "-u-: don't create unmatched edges" << endl;
	cout << "-c: debug colors: new edges magenta and new conditional lines light blue" << endl;
	cout << "-w: write only newly created lines" << endl;
	cout << "-cx: create conditional lines only on convex surfaces (require BFC valid file)" << endl;
	cout << "-cv: create conditional lines only on concave surfaces (require BFC valid file)" << endl;
	cout << "-s: expand subfiles" << endl;
	cout << "-i+: expand subfiles and output inlined data with subfile comments" << endl;
	cout << "-i-: expand subfiles and output inlined data without subfile comments" << endl;
	cout << "-l \"path\": define ldraw search path" << endl;
	pause();
}

int main(int argc, char *argv[])
{
	printf("\nLdraw Edger2 v1.1 - by Philo");
	printf("\n----------------------------");
	printf("\nThanks to Lee Gaiteri for showing the path!\n\n");


	if(argc<3) 
	{
		usage();
		return 1;
	}

	LdPath* path=new LdPath();
	// Get input file path
	string curpath=argv[argc-2];
	size_t pathlen = curpath.find_last_of("\\");
	if(pathlen == string::npos) curpath = ".\\"; else curpath.resize(pathlen+1);
	path->addPath(curpath);
	string derivedpath=curpath;
	path->addPath(derivedpath.append("p\\"));
	derivedpath=curpath;
	path->addPath(derivedpath.append("s\\"));

	for(int i=1; i<argc-2; i++)
	{
		if(argv[i][0] != '-')
		{
			usage();
			return 1;
		}
		switch (argv[i][1])
		{
		case 'p':
			i++;
			sscanf(argv[i], "%lf",&LdPrecision);
			break;
		case 'w':
			WriteNewOnly=true;
			break;
		case 'c':
			switch (argv[i][2])
			{
			case 0:
				DebugColors=true;
				break;
			case 'x':
				CxCv=1;
				break;
			case 'v':
				CxCv=-1;
				break;
			default:
				usage();
				return 1;
			}
			break;
		case 'a':
			switch (argv[i][2])
			{
			case 'f':
				i++;
				sscanf(argv[i], "%lf",&LdFlat);
				break;
			case 'c':
				i++;
				sscanf(argv[i], "%lf",&LdMaxCond);
				if(LdMaxCond < LdFlat) LdFlat = LdMaxCond; 
				break;
			case 'e':
				i++;
				sscanf(argv[i], "%lf",&LdMinEdge);
				if(LdMinEdge < LdMaxCond) LdMaxCond = LdMinEdge;
				break;
			default:
				usage();
				return 1;
			}
			break;
		case 's':
			Expand=true;
			break;
		case 'i':
			switch (argv[i][2])
			{
			case '+':
				Expand=true;
				Inlined=true;
				SubComments=true;
				break;
			case '-':
				Expand=true;
				Inlined=true;
				SubComments=false;
				break;
			default:
				usage();
				return 1;
			}
			break;

		case 'u':
			switch (argv[i][2])
			{
			case '+':
				OnlyUnmatched=true;
				break;
			case '-':
				NoUnmatched=true;
				break;
			default:
				usage();
				return 1;
			}

			break;
		case 'l':
			i++;
			curpath = argv[i];
			if(curpath.at(curpath.size()-1) != '\\') 
			{
				curpath.append("\\");
			}
			derivedpath=curpath;
			path->addPath(derivedpath.append("p\\"));
			derivedpath=curpath;
			path->addPath(derivedpath.append("parts\\"));
			path->addPath(derivedpath.append("s\\"));
			curpath.append("Unofficial\\");
			derivedpath=curpath;
			path->addPath(derivedpath.append("p\\"));
			derivedpath=curpath;
			path->addPath(derivedpath.append("parts\\"));
			path->addPath(derivedpath.append("s\\"));

			break;
		case 'd':
			switch (argv[i][2])
			{
			case 'c':
				DelCond=true;
				cout << "Existing conditional lines deleted" << endl;
				break;
			case 'e':
				DelEdge=true;
				cout << "Existing edge lines deleted" << endl;
				break;
			default:
				usage();
				return 1;
			}
			break;
		default:
			usage();
			return 1;
		}
	}

	if (LdFlat < 0) LdFlat = 0;
	if (LdFlat > LdMaxCond) LdMaxCond = LdFlat;
	if (LdMinEdge < LdMaxCond) LdMinEdge = LdMaxCond;
	printf("Precision %g\n\n", LdPrecision);
	printf("%5.2f < angle < %5.2f: No Line \n", 0., LdFlat);
	printf("%5.2f < angle < %5.2f: Cond Line \n", LdFlat, LdMaxCond);
	printf("%5.2f < angle < %5.2f: Cond Line + Edge Line \n", LdMaxCond, LdMinEdge);
	printf("%5.2f < angle        : Edge Line \n", LdMinEdge);
	Fldraw in;
	if(!in.ldLoad (argv[argc-2]))
	{
		cout << argv[argc-2] << " not found" << endl;
		pause();
		return 2;
	}

	if (Expand)
	{
		cout << "\nExpanding subfiles\n";
		cout << "LDraw subfiles search locations:\n" << path->toString().c_str() << endl;
		in.ldExpand(path);
		cout << endl;
	}
	if (!NoUnmatched)
	{
		cout << "\nLooking for unmatched edges";
		in.findOrphan();
		cout << CompPoint << " Point comparisons done during this phase" << endl;
	}
	if (!OnlyUnmatched)
	{
		cout << "\nLooking for missing lines/condlines";
		in.findAdjacent();
	}
	if(!in.ldSave(argv[argc-1]))
	{
		cout <<" Can't create" << argv[argc-1] << endl;
		pause();
		return 2;
	}
	cout << CompPoint << " Point comparisons done" << endl;

	pause();
	return 0;
}

