/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LongAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.net.ns.BreakNetException;

class T4CLongAccessor
extends LongAccessor {
    T4CMAREngine mare;
    static final int t4MaxLength = Integer.MAX_VALUE;
    static final int t4PlsqlMaxLength = 32760;
    byte[][] data = null;
    int[] nbBytesRead = null;
    int[] bytesReadSoFar = null;
    final int[] escapeSequenceArr = new int[1];
    final boolean[] readHeaderArr = new boolean[1];
    final boolean[] readAsNonStreamArr = new boolean[1];
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_12:16:40_PDT_2010";
    public static final boolean TRACE = false;

    T4CLongAccessor(OracleStatement oracleStatement, int n2, int n3, short s2, int n4, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2, n3, s2, n4);
        this.mare = t4CMAREngine;
        if (oracleStatement.connection.useFetchSizeWithLongColumn) {
            this.data = new byte[oracleStatement.rowPrefetch][];
            for (int i2 = 0; i2 < oracleStatement.rowPrefetch; ++i2) {
                this.data[i2] = new byte[4080];
            }
            this.nbBytesRead = new int[oracleStatement.rowPrefetch];
            this.bytesReadSoFar = new int[oracleStatement.rowPrefetch];
        }
    }

    T4CLongAccessor(OracleStatement oracleStatement, int n2, int n3, boolean bl, int n4, int n5, int n6, int n7, int n8, short s2, int n9, int n10, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2, n3, bl, n4, n5, n6, n7, n8, s2);
        this.mare = t4CMAREngine;
        this.definedColumnType = n9;
        this.definedColumnSize = n10;
        if (oracleStatement.connection.useFetchSizeWithLongColumn) {
            this.data = new byte[oracleStatement.rowPrefetch][];
            for (int i2 = 0; i2 < oracleStatement.rowPrefetch; ++i2) {
                this.data[i2] = new byte[4080];
            }
            this.nbBytesRead = new int[oracleStatement.rowPrefetch];
            this.bytesReadSoFar = new int[oracleStatement.rowPrefetch];
        }
    }

    void processIndicator(int n2) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalUB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (this.statement.sqlKind != 32 && this.statement.sqlKind != 64) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind == 32 || this.statement.sqlKind == 64 || this.isDMLReturnedParam) {
            this.mare.processIndicator(n2 <= 0, n2);
        }
    }

    boolean unmarshalOneRow() throws SQLException, IOException {
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        boolean bl = false;
        int n2 = this.indicatorIndex + this.lastRowProcessed;
        this.escapeSequenceArr[0] = this.mare.unmarshalUB1();
        if (this.mare.escapeSequenceNull(this.escapeSequenceArr[0])) {
            this.rowSpaceIndicator[n2] = -1;
            this.mare.processIndicator(false, 0);
            int n3 = (int)this.mare.unmarshalUB4();
            bl = false;
            this.escapeSequenceArr[0] = 0;
            ++this.lastRowProcessed;
        } else {
            this.rowSpaceIndicator[n2] = 0;
            this.readHeaderArr[0] = true;
            this.readAsNonStreamArr[0] = false;
            if (this.statement.connection.useFetchSizeWithLongColumn) {
                int n4 = 0;
                while (n4 != -1) {
                    if (this.data[this.lastRowProcessed].length < this.nbBytesRead[this.lastRowProcessed] + 255) {
                        byte[] byArray = new byte[this.data[this.lastRowProcessed].length * 4];
                        System.arraycopy(this.data[this.lastRowProcessed], 0, byArray, 0, this.nbBytesRead[this.lastRowProcessed]);
                        this.data[this.lastRowProcessed] = byArray;
                    }
                    if ((n4 = T4CLongAccessor.readStreamFromWire(this.data[this.lastRowProcessed], this.nbBytesRead[this.lastRowProcessed], 255, this.escapeSequenceArr, this.readHeaderArr, this.readAsNonStreamArr, this.mare, ((T4CConnection)this.statement.connection).oer)) == -1) continue;
                    int n5 = this.lastRowProcessed;
                    this.nbBytesRead[n5] = this.nbBytesRead[n5] + n4;
                }
                ++this.lastRowProcessed;
            } else {
                bl = true;
            }
        }
        return bl;
    }

    void fetchNextColumns() throws SQLException {
        this.statement.continueReadRow(this.columnPosition);
    }

    int readStream(byte[] byArray, int n2) throws SQLException, IOException {
        int n3 = this.statement.currentRow;
        if (this.statement.connection.useFetchSizeWithLongColumn) {
            byte[] byArray2 = this.data[n3];
            int n4 = this.bytesReadSoFar[n3];
            int n5 = this.nbBytesRead[n3];
            if (n4 == n5) {
                return -1;
            }
            int n6 = 0;
            n6 = n2 <= n5 - n4 ? n2 : n5 - n4;
            System.arraycopy(byArray2, n4, byArray, 0, n6);
            int n7 = n3;
            this.bytesReadSoFar[n7] = this.bytesReadSoFar[n7] + n6;
            return n6;
        }
        int n8 = T4CLongAccessor.readStreamFromWire(byArray, 0, n2, this.escapeSequenceArr, this.readHeaderArr, this.readAsNonStreamArr, this.mare, ((T4CConnection)this.statement.connection).oer);
        return n8;
    }

    protected static final int readStreamFromWire(byte[] byArray, int n2, int n3, int[] nArray, boolean[] blArray, boolean[] blArray2, T4CMAREngine t4CMAREngine, T4CTTIoer t4CTTIoer) throws SQLException, IOException {
        int n4;
        block13: {
            n4 = -1;
            try {
                if (!blArray2[0]) {
                    if (n3 > 255 || n3 < 0) {
                        SQLException sQLException = DatabaseError.createSqlException(null, 433);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    if (blArray[0]) {
                        if (nArray[0] == 254) {
                            n4 = t4CMAREngine.unmarshalUB1();
                        } else {
                            if (nArray[0] == 0) {
                                t4CTTIoer.connection.internalClose();
                                SQLException sQLException = DatabaseError.createSqlException(null, 401);
                                sQLException.fillInStackTrace();
                                throw sQLException;
                            }
                            blArray2[0] = true;
                            n4 = nArray[0];
                        }
                        blArray[0] = false;
                        nArray[0] = 0;
                    } else {
                        n4 = t4CMAREngine.unmarshalUB1();
                    }
                } else {
                    blArray2[0] = false;
                }
                if (n4 > 0) {
                    t4CMAREngine.unmarshalNBytes(byArray, n2, n4);
                } else {
                    n4 = -1;
                }
            }
            catch (BreakNetException breakNetException) {
                n4 = t4CMAREngine.unmarshalSB1();
                if (n4 != 4) break block13;
                t4CTTIoer.init();
                t4CTTIoer.processError();
            }
        }
        if (n4 == -1) {
            blArray[0] = true;
            t4CMAREngine.unmarshalUB2();
            t4CMAREngine.unmarshalUB2();
        }
        return n4;
    }

    String getString(int n2) throws SQLException {
        String string = super.getString(n2);
        if (string != null && this.definedColumnSize > 0 && string.length() > this.definedColumnSize) {
            string = string.substring(0, this.definedColumnSize);
        }
        return string;
    }
}

