/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.xml.elements;

import junit.extensions.xml.XMLConstants;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.XMLTagResourceBundle;
import junit.extensions.xml.XMLTestCase;
import junit.extensions.xml.elements.AbstractTagHandler;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TestTagHandler
extends AbstractTagHandler
implements XMLConstants {
    public TestTagHandler(Element element, XMLTestCase xMLTestCase) {
        super(element, xMLTestCase);
    }

    public void validateElement() throws XMLException {
        super.validateElement();
        this.checkElementTagName("test");
    }

    public void processElement() throws Exception {
        this.validateElement();
        this.getTestCase().clearFoundObjects();
        Element element = this.getElement();
        this.getTestCase().setName(this.getName());
        NodeList nodeList = this.getElement().getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n) instanceof Element) {
                Element element2 = (Element)nodeList.item(n);
                String string = element2.getTagName();
                XMLTagResourceBundle.getTagHandler(element2, this.getTestCase(), string).processElement();
            }
            ++n;
        }
    }

    private String getName() {
        return this.getString("name");
    }
}

