/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.xml.elements;

import junit.extensions.xml.IXMLTestSuite;
import junit.extensions.xml.XMLConstants;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.XMLTestCase;
import junit.extensions.xml.XMLTestSuite;
import junit.extensions.xml.XMLUtil;
import junit.extensions.xml.elements.AbstractTagHandler;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SuiteTagHandler
extends AbstractTagHandler
implements XMLConstants {
    private IXMLTestSuite testSuite;

    public SuiteTagHandler(Element element, IXMLTestSuite iXMLTestSuite) {
        super(element, null);
        this.testSuite = iXMLTestSuite;
    }

    public IXMLTestSuite getTestSuite() {
        return this.testSuite;
    }

    public void validateElement() throws XMLException {
        super.validateElement();
        this.checkElementTagName("suite");
    }

    public void processElement() throws Exception {
        this.validateElement();
        NodeList nodeList = this.getElement().getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n) instanceof Element) {
                Element element = (Element)nodeList.item(n);
                String string = element.getTagName();
                if ("suite".equals(string)) {
                    this.testSuite.addTest(new XMLTestSuite(this.testSuite.getFileName(), element));
                } else if ("test".equals(string)) {
                    this.testSuite.addTest(new XMLTestCase(this.testSuite.getFileName(), element));
                } else if ("file".equals(string)) {
                    this.testSuite.addFile(XMLUtil.getAttribute(element, "name"));
                }
            }
            ++n;
        }
    }
}

